@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="row">
    @foreach ( $fetched_themes as $directory => $theme )
    <div class="col-md-6 col-xl-4">
        <div class="card text-center">
            <div class="card-body"><h4 class="card-title mt-0">{{$theme['name']}}</h4></div>
            <img class="img-fluid list-group-item" src="{{$theme['screenshot']}}" alt="Card image cap">
            <div class="bg- p-2 ">
                {{admin_lang('version')}} {{$theme['version']}} | {{admin_lang('author')}} <a href="{{$theme['authoruri']}}" target="_blank">{{$theme['author']}}</a>
            </div>
            <div class="card-body">
                @if ( $theme['compatible'] ) 
                    @if ( $theme['activated'] )
                    <button class="btn btn-sm btn-light">{{admin_lang('activate' )}}</button>
                    @else
                        <a class="card-link btn btn-sm waves-effect waves-light btn-success" href="{{get_admin_url('themes/activate/'.$directory.'/'.csrf_token())}}">{{admin_lang('activate' )}}</a>
                    @endif
                @else 
                    <a class="card-link btn btn-sm waves-effect waves-light btn-success" href="https://codecanyon.net/item/php-help-manager/12031944?ref=themearabia" target="_blank">{{admin_lang('requires_version')}} {{$theme['requires']}}</a>
                @endif
                <a class="card-link btn btn-sm waves-effect waves-light btn-info" href="{{$theme['website']}}" target="_blank">{{admin_lang('theme_page')}}</a>
            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection