@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{admin_lang('profile')}} :: {{ $data['username'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="#">{{ admin_lang('userscompany') }}</a></li>
            <li class="breadcrumb-item active">{{ $data['username']}}</li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-xl-4">
        <div class="card overflow-hidden">
            <div class="bg-soft-primary bg-soft-usercover" style="background-image: url({{get_user_cover($data['userid'])}})">
                <div class="row">
                    <div class="col-12">
                        <div class="text-primary p-3">
                            <h5 class="text-primary">{{ $data['username'] }}</h5>
                            <p>{{ $data['email'] }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body pt-0">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="avatar-md profile-user-wid mb-4">
                            <img src="{{ get_user_avatar($data['userid']) }}" alt="" class="img-thumbnail rounded-circle">
                        </div>
                        <h5 class="font-size-15 text-truncate">{{ $data['username'] }}</h5>
                        <p class="text-muted mb-0 text-truncate">
                            @if($data['userlevel'] == 'admin')
                            <span class="badge badge-pill bg-danger">{{admin_lang('userlevel_'.$data['userlevel'])}}</span>
                            @else
                            <span class="badge badge-pill bg-info">{{admin_lang('userlevel_'.$data['userlevel'])}}</span>
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="account_info">
                    <div class="account_info-group"><label>{{admin_lang('userscompany')}}:</label> {{ $data['company_name'] }}</div>
                    <div class="account_info-group"><label>{{admin_lang('contract_id')}}:</label> {{ $data['contract_id'] }}</div>
                    <div class="account_info-group"><label>{{admin_lang('username')}}:</label> {{ $data['username'] }}</div>
                    <div class="account_info-group"><label>{{admin_lang('email')}}:</label> <a href="mailto:{{ $data['email'] }}">{{ $data['email'] }}</a></div>
                    <div class="account_info-group"><label>{{admin_lang('created')}}:</label> {{ date('m/d/Y', strtotime($data['user']->created_at)) }}</div>
                    <div class="account_info-group"><label>{{admin_lang('updated')}}:</label> {{ date('m/d/Y', strtotime($data['user']->updated_at)) }}</div>
                    <div class="account_info-group"><label>{{admin_lang('last_seen')}}:</label> @if($data['signintime']){{date('m/d/Y', $data['signintime'])}}@else{{admin_lang('none')}}@endif</div>
                </div>
            </div>
        </div>
    </div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
@if($errors->any())
<div class="alert alert-danger">
    <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
</div>
@endif
@action('admin_user_profile_before_container', $data['user'])
<div class="tacf-box-container">
    <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="profile_user" data-cookie-tab="tab-details">

        <a href="#" class="active" data-tab=".tab-edit"><i class="bx bx-pencil"></i> {{admin_lang('edit')}}</a>
        <a href="#" class="" data-tab=".tab-details"><i class="bx bx-file"></i> {{ admin_lang('details') }}</a>
        @action('admin_user_profile_tabs', $data['user'])

    </div>
    <div class="tacf-tabs-content">
        <div class="tacf-tab-content tab-details  p-0">
            <ul class="list-group list-group-flush">
                <li class="list-group-item"><strong>{{admin_lang('id')}}:</strong> {{$data['user']->id}}</li>
                <li class="list-group-item"><strong>{{admin_lang('two_factor')}} :</strong> {{Auth::user()->two_factor == 1 ? 'YES' : 'NO'}}</li>
                <li class="list-group-item"><strong>{{admin_lang('username')}}:</strong> {{ $data['user']->username }}</li>
                <li class="list-group-item"><strong>{{admin_lang('email')}}:</strong> <a href="mailto:{{ $data['user']->email }}">{{ $data['user']->email }}</a></li>
                <li class="list-group-item"><strong>{{admin_lang('role')}}:</strong> @if($data['user']->userlevel == 'admin')<span class="badge badge-pill bg-danger">{{admin_lang('userlevel_'.$data['user']->userlevel)}}</span>@else<span class="badge badge-pill bg-info">{{admin_lang('userlevel_'.$data['user']->userlevel)}}</span>@endif</li>
                @action('admin_user_profile_details', $data['user'])
                <li class="list-group-item"><strong>{{admin_lang('created')}}:</strong> {{ date('m-d-Y', strtotime($data['user']->created_at)) }}</li>
                <li class="list-group-item"><strong>{{admin_lang('updated')}}:</strong> {{ date('m-d-Y', strtotime($data['user']->updated_at)) }}</li>
                <li class="list-group-item"><strong>{{admin_lang('last_seen')}}:</strong> @if($data['signintime']){{date('m/d/Y', $data['signintime'])}}@else{{admin_lang('none')}}@endif</li>
                <li class="list-group-item"><strong>{{admin_lang('ip')}}:</strong> <a href="{{get_admin_url('users/platform/'.$data['details']['ip'])}}">{{$data['details']['ip']}}</a></li>
                <li class="list-group-item"><strong>{{admin_lang('useragent')}}:</strong> {{$data['details']['useragent']}}</li>
                <li class="list-group-item"><strong>{{admin_lang('platformname')}}:</strong> <a href="{{get_admin_url('users/platform/'.$data['details']['platformname'])}}">{{$data['details']['platformname']}}</a></li>
                <li class="list-group-item"><strong>{{admin_lang('browserfamily')}}:</strong> <a href="{{get_admin_url('users/browser/'.$data['details']['browserfamily'])}}">{{$data['details']['browserfamily']}}</a></li>
            </ul>
        </div>
        @if(is_permission('comments'))
        <div class="tacf-tab-content tab-comments pl-3 pr-3 pb-3 pt-0">
            @include('dashboard.comments.index_loop_comments')
        </div>
        @endif
        <div class="tacf-tab-content tab-edit  active">
            @include('dashboard.usercompanys.user_form')
        </div>
        @action('admin_user_profile_tabs_content', $data['user'])
    </div>
</div>
@action('admin_user_profile_after_container', $data['user'])
@endsection
@section('style_files')
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('libs/multiselect/css/multiselect.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
<script src="{{ asset('libs/multiselect/js/jquery.multiselect.js') }}"></script>
<script src="{{ asset('dashboard/js/custom-file-input.min.js') }}"></script>
<script type="text/javascript">
bsCustomFileInput.init();
$(function() {$('#permission').multiSelect();});
</script>
@endsection
