<!DOCTYPE html>
<html lang="{{$site_lang}}" dir="{{$site_dir}}">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ get_option('sitename') }} - {{ (isset($page_title))? $page_title : '' }}</title>
    <link rel="icon" href="{{ get_asset('images/favicon.ico') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500">
    <link href="{{ get_asset('css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    @if($site_dir == 'rtl')<link rel="stylesheet" href="{{ get_asset('css/auth.rtl.min.css') }}" type="text/css" />@else<link rel="stylesheet" href="{{ get_asset('css/auth.min.css') }}" type="text/css" />>@endif
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="signin {{$site_dir}}">
<div class="container padding_60">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5 col-xl-4">
            <div class="card overflow-hidden">
                <div class="bg-cover">
                    <div class="row">
                        <div class="col-7">
                            <div class="text-primary p-3">
                                <h5 class="text-primary">{{ lang('register') }}</h5>
                                <p>{{ lang('get_your_free_account') }}</p>
                            </div>
                        </div>
                        <div class="col-5 align-self-end"><img src="{{ get_asset('images/auth.png') }}" alt="" class="img-fluid"></div>
                    </div>
                </div>
                <div class="card-body signin-form-wrap">
                    <div class="home-icon-wid mb-4">
                        <a href="{{url('/')}}">
                            <span class="home-icon rounded-circle">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" width="24"><path fill="currentColor" d="M541 229.16l-61-49.83v-77.4a6 6 0 0 0-6-6h-20a6 6 0 0 0-6 6v51.33L308.19 39.14a32.16 32.16 0 0 0-40.38 0L35 229.16a8 8 0 0 0-1.16 11.24l10.1 12.41a8 8 0 0 0 11.2 1.19L96 220.62v243a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-128l64 .3V464a16 16 0 0 0 16 16l128-.33a16 16 0 0 0 16-16V220.62L520.86 254a8 8 0 0 0 11.25-1.16l10.1-12.41a8 8 0 0 0-1.21-11.27zm-93.11 218.59h.1l-96 .3V319.88a16.05 16.05 0 0 0-15.95-16l-96-.27a16 16 0 0 0-16.05 16v128.14H128V194.51L288 63.94l160 130.57z" class=""></path></svg>
                            </span>
                        </a>
                    </div>
                    @if($errors->any())
                        <div class="alert alert-warning">
                            <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
                        </div>
                    @endif
                    <form class="form-horizontal" method="POST" action="{{ url('register') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="remember" value="1">
                        <div class="mb-3">
                            <label class="form-label">{{lang('username')}}</label>
                            <div class="icon-group">
                                <div class="form-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M313.6 288c-28.7 0-42.5 16-89.6 16-47.1 0-60.8-16-89.6-16C60.2 288 0 348.2 0 422.4V464c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48v-41.6c0-74.2-60.2-134.4-134.4-134.4zM416 464c0 8.8-7.2 16-16 16H48c-8.8 0-16-7.2-16-16v-41.6C32 365.9 77.9 320 134.4 320c19.6 0 39.1 16 89.6 16 50.4 0 70-16 89.6-16 56.5 0 102.4 45.9 102.4 102.4V464zM224 256c70.7 0 128-57.3 128-128S294.7 0 224 0 96 57.3 96 128s57.3 128 128 128zm0-224c52.9 0 96 43.1 96 96s-43.1 96-96 96-96-43.1-96-96 43.1-96 96-96z" class=""></path></svg>    
                                </div>
                                <input type="text" class="form-control" name="username" placeholder="{{ lang('enter_username') }}" value="{{ old('username') }}">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{lang('email_address')}}</label>
                            <div class="icon-group">
                                <div class="form-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M464 64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM48 96h416c8.8 0 16 7.2 16 16v41.4c-21.9 18.5-53.2 44-150.6 121.3-16.9 13.4-50.2 45.7-73.4 45.3-23.2.4-56.6-31.9-73.4-45.3C85.2 197.4 53.9 171.9 32 153.4V112c0-8.8 7.2-16 16-16zm416 320H48c-8.8 0-16-7.2-16-16V195c22.8 18.7 58.8 47.6 130.7 104.7 20.5 16.4 56.7 52.5 93.3 52.3 36.4.3 72.3-35.5 93.3-52.3 71.9-57.1 107.9-86 130.7-104.7v205c0 8.8-7.2 16-16 16z" class=""></path></svg>    
                                </div>
                                <input type="email" class="form-control" name="email" placeholder="{{ lang('enter_email') }}" value="{{ old('email') }}">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{lang('password')}}</label>
                            <div class="icon-group">
                                <div class="form-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="currentColor" d="M48 480a16 16 0 0 1-16-16v-41.6A102.47 102.47 0 0 1 134.4 320c19.6 0 39.1 16 89.6 16s70-16 89.6-16c2.7 0 5.3.6 7.9.8a79.45 79.45 0 0 1 13.1-30.7 132.34 132.34 0 0 0-21.1-2.1c-28.7 0-42.5 16-89.6 16s-60.8-16-89.6-16C60.2 288 0 348.2 0 422.4V464a48 48 0 0 0 48 48h288.4a78.34 78.34 0 0 1-14.8-32zm176-224A128 128 0 1 0 96 128a128 128 0 0 0 128 128zm0-224a96 96 0 1 1-96 96 96.15 96.15 0 0 1 96-96zm272 336a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96-80h-16v-48a80 80 0 0 0-160 0v48h-16a48 48 0 0 0-48 48v128a48 48 0 0 0 48 48h192a48 48 0 0 0 48-48V336a48 48 0 0 0-48-48zm-144-48a48 48 0 0 1 96 0v48h-96zm160 224a16 16 0 0 1-16 16H400a16 16 0 0 1-16-16V336a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z" class=""></path></svg>
                                </div>
                                <input type="password" class="form-control" name="password" placeholder="{{ lang('enter_password') }}" value="{{ old('password') }}">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{lang('confirm_password')}}</label>
                            <div class="icon-group">
                                <div class="form-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="currentColor" d="M48 480a16 16 0 0 1-16-16v-41.6A102.47 102.47 0 0 1 134.4 320c19.6 0 39.1 16 89.6 16s70-16 89.6-16c2.7 0 5.3.6 7.9.8a79.45 79.45 0 0 1 13.1-30.7 132.34 132.34 0 0 0-21.1-2.1c-28.7 0-42.5 16-89.6 16s-60.8-16-89.6-16C60.2 288 0 348.2 0 422.4V464a48 48 0 0 0 48 48h288.4a78.34 78.34 0 0 1-14.8-32zm176-224A128 128 0 1 0 96 128a128 128 0 0 0 128 128zm0-224a96 96 0 1 1-96 96 96.15 96.15 0 0 1 96-96zm272 336a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96-80h-16v-48a80 80 0 0 0-160 0v48h-16a48 48 0 0 0-48 48v128a48 48 0 0 0 48 48h192a48 48 0 0 0 48-48V336a48 48 0 0 0-48-48zm-144-48a48 48 0 0 1 96 0v48h-96zm160 224a16 16 0 0 1-16 16H400a16 16 0 0 1-16-16V336a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z" class=""></path></svg>
                                </div>
                                <input type="password" class="form-control" name="password_confirmation" placeholder="{{ lang('enter_repeat_password') }}" value="{{ old('password_confirmation') }}">
                            </div>
                        </div>


                        <div class="mt-3">
                            <button class="btn btn-primary btn-block" type="submit">{{ lang('register') }}</button>
                        </div>
                    </form>
                    <div class="box-singup">
                        {{lang('already_have_account')}} <a href="{{url('login')}}">{{lang('login')}}</a>
                    </div>
                </div>
            </div>
            <div class="mt-3 text-center">
                <p class="copyright">{{lang('site_copyright', ['sitename' => get_option('sitename')])}}</p>
            </div>
        </div>
    </div>
</div>
</body>
</html>