<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" {!! (config('lang.direction')=='rtl' ) ? ' dir="rtl"' : '' !!}>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ (isset($page_title))? $page_title. ' | ' : '' }}{{ get_option('sitename') }}</title>
    <link rel="stylesheet" href="{{ get_asset('css/maintenance.css') }}">
</head>
<body>
 
    <div id="wrapper" class="coming-soon">
        <!-- coming soon -->
        <section class="slider">
            <div class="content">
                <h2 id="count2">{{get_option('maintenance_title')}}</h2>
                <p>{!!nl2br(e(get_option('maintenance_message')))!!}</p>
                @if(get_option('maintenance_datestatus'))
                <div id="coming-soon">
                    <div class="countdown">
                        <div>
                            <span id="dday"></span>
                            <span id="days">Days</span>
                        </div>
                    </div>
                    <div class="countdown">
                        <div>
                            <span id="dhour"></span>
                            <span id="hours">Hours</span>
                        </div>
                    </div>
                    <div class="countdown">
                        <div>
                            <span id="dmin"></span>
                            <span id="minutes">Mins</span>
                        </div>
                    </div>
                    <div class="countdown">
                        <div>
                            <span id="dsec"></span>
                            <span id="seconds">Secs</span>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </section>
    </div>
    @if(get_option('maintenance_datestatus'))
    <script src="{{ get_asset('js/jquery.min.js') }}"></script>
    <script src="{{ get_asset('js/coming-soon.js') }}"></script>
    <script>
    var current = "Message After Time End!";
    countdown({{$maintenance_year}},{{$maintenance_month}},{{$maintenance_day}});
    </script>
    @endif
</body>
</html>
