@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($news_style == 'fixed') justify-content-center @endif">
        @if($news_style == 'left_sidebar')
        @include(get_extends('news.sidebar'))
        @endif
        <div class="@if($news_style == 'full') col-lg-12  @elseif($news_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            @if($the_cate_name)
            <div class="head-title">
                <h4>{{$the_cate_name}}</h4>
            </div>
            @endif
            <div class="row">
                @foreach ($posts as $item)
                <div class="{{$news_column}}">
                    <div class="blog-grid">
                        <div class="blog-grid-image">
                            <a href="{{url('new/'.$item->post_name)}}">
                                <img src="{{get_attachment_url($item->thumbnail, 'medium')}}" alt="{{$item->post_title}}">
                            </a>
                            <span class="meta-date">{{time_format($item->post_modified, 'date')}}</span>
                        </div>
                        <h3 class="blog-grid-title">
                            <a href="{{url('new/'.$item->post_name)}}">{{$item->post_title}}</a>
                        </h3>
                        <p class="blog-grid-excerpt">{{$item->post_excerpts}}</p>
                    </div>
                </div>
                @endforeach
            </div>
            {{ $posts->links(get_include('plugins.pagination')) }}
        </div>
        @if($news_style == 'right_sidebar')
        @include(get_extends('news.sidebar'))
        @endif
    </div>
</div>
@endsection