<aside class="col-lg-3 col-md-4 col-sm-12 sidebar @if(get_theme_option('sticky_sidebar')) sticky-sidebar @endif">
    <div class="theiaStickySidebar">
        @action('sidebar_before', $post_type)
        @if($news_widget_search)
        <div class="widget widget-search-input">
            <div class="widget-title"><i class="pe-7s-search"></i> {{lang('search')}}</div>
            <form action="{{url('news')}}" method="get">
                <div class="box-input">
                    <input class="input" type="text" name="search" placeholder="{{$news_search_text}}" maxlength="50" value="{{safe_input(request()->get('search'))}}">
                </div>
            </form>
        </div>
        @endif
        @if($news_widget_categories)
        <div class="widget widget-list">
            <div class="widget-title">
                <i class="pe-7s-ticket"></i> {{lang('categories')}}
            </div>
            <ul>
                @foreach ($widget_categories as $item)
                <li class="cat-item @if($item->id == $the_term_id) active @endif"><a href="{{url('news/'.$item->slug)}}">{{$item->name}} <span class="count">{{$item->posts_count}}</span></a></li>
                @endforeach
            </ul>
        </div>
        @endif
        @if($news_widget_recent)
        <div class="widget widget-recent-post">
            <div class="widget-title"><i class="pe-7s-gleam"></i> {{lang('recent')}}</div>
            <ul>
                @foreach ($widget_recent as $item)
                <li>
                    <a href="{{url('new/'.$item->post_name)}}" title="{{$item->post_title}}" class="thumb">
                        <img src="{{get_attachment_url($item->thumbnail)}}" alt="{{$item->post_title}}">
                    </a>
                    <div class="recent-post-widget-content">
                        <h5><a href="{{url('new/'.$item->post_name)}}">{{$item->post_title}}</a></h5>
                        <p class="recent-post-date">{{extension_lang('posts', 'posted')}}: {{time_ago($item->post_modified)}}</p>
                    </div>
                </li>
                @endforeach
            </ul>
        </div>
        @endif
        @if($news_widget_tags)
        <div class="widget widget-list">
            <div class="widget-title"><i class="pe-7s-ticket"></i> {{lang('tags')}}</div>
            <div class="tagcloud">
                @foreach ($widget_tags as $key => $count)
                <a href="{{url('news/tag/'.trim($key))}}">{{trim($key)}} ({{$count}})</a>
                @endforeach                
            </div>
        </div>
        @endif
        @action('sidebar_after', $post_type)
    </div>
</aside>