@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($news_style == 'fixed') justify-content-center @endif">
        @if($news_style == 'left_sidebar')
        @include(get_extends('news.sidebar'))
        @endif
        <div class="@if($news_style == 'full') col-lg-12  @elseif($news_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            <h4 class="post-title">{{$single->post_title}}</h4>
            <div class="post-meta">
                <span class="meta-author"><i class="pe-7s-user"></i> {{get_username($single->post_author)}}</span>
                <span class="meta-date"><i class="pe-7s-date"></i> {{time_format($single->post_modified, 'date')}}</span>
                <span class="meta-comment"><i class="pe-7s-comment"></i> {{get_count_comments($single->id, $single->post_type)}} {{lang('comments')}}</span>
                <span class="meta-views"><i class="pe-7s-look"></i> {{$single->post_views}} {{lang('views')}}</span>
                <span class="meta-categories"><i class="pe-7s-ticket"></i> <a href="{{url('news/'.get_term_slug($single->term_id))}}">{{get_term_name($single->term_id)}}</a></span>
            </div>
            <div class="post-content">
                {!!$single->post_content!!}
            </div>
            <div class="stars-tags">
                <div class="row">
                    <div class="col-md-8">
                        @if($news_meta_shareit)
                        @include(get_extends('plugins.share_socials'), ['title' => $single->post_title, 'link' => url('post/'.$single->post_name)])
                        @endif
                    </div>
                    <div class="col-md-4">
                        <ul class="tags">
                            @foreach ($tags as $tag)
                            <li><a href="{{$tag['link']}}">{{$tag['name']}}</a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            @include(get_extends('plugins.comments'), ['single' => $single])
        </div>
        @if($news_style == 'right_sidebar')
        @include(get_extends('news.sidebar'))
        @endif
    </div>
</div>
@endsection