<?php

/**
 * Theme Name: Default
 * Theme URI: http://themearabia.net/php_help_manager/themes/default
 * Version: 1.0
 * Requires: 5.0
 * Description: Theme Description
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

use Illuminate\Http\Request;

if (!class_exists('theme_default')) {
    class theme_default {

        protected $theme_folder = 'default';
        protected $theme_id     = 'theme_default';
        protected $theme_icon   = 'bx bx-layout';
        protected $theme_order  = '1';
        protected $option_name  = 'theme_options_default';
        protected $options      = [];

        function __construct()
        {
            $this->theme_path  = resource_path('views/frontend/'.$this->theme_folder);
            $this->theme_url   = url(env('APP_ROOT_PAHT').'/resources/views/frontend/'.$this->theme_folder);
            $this->options     = maybe_unserialize(get_option($this->option_name));
            $this->path_pattern = get_asset('images/patterns');
            if(is_admin()){
                Eventy::addAction('admin_sidebar_appearance', [$this, 'admin_sidebar_appearance'], $this->theme_order, 1);
                Eventy::addAction('admin_blade_action_page_template', [$this, 'page_template'], $this->theme_order, 1);
                Eventy::addAction('admin_theme_options_menu', [$this, 'admin_options_menu'], $this->theme_order, 1);
                Eventy::addAction('admin_theme_options_content', [$this, 'admin_options_content'], $this->theme_order, 1);
                Eventy::addAction('admin_theme_options_save', [$this, 'admin_options_save'], $this->theme_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'action_widgets_homepage_options'], $this->theme_order, 1);
            }
            else {
                Eventy::addFilter('filter_data_home', [$this, 'filter_data_home'], $this->theme_order, 1);
                Eventy::addFilter('get_options_autoload', [$this, 'get_options_autoload'], $this->theme_order, 1);
                Eventy::addAction('action_start_body', [$this, 'action_start_body'], $this->theme_order, 1);
                Eventy::addAction('action_script', [$this, 'action_script'], $this->theme_order, 1);
                Eventy::addAction('action_script_code', [$this, 'action_script_code'], $this->theme_order, 1);
                Eventy::addAction('blade_action_header_before', [$this, 'action_header_before'], $this->theme_order, 1);
                Eventy::addAction('blade_action_header_after', [$this, 'action_header_after'], $this->theme_order, 1);
                Eventy::addAction('blade_action_footer_before', [$this, 'action_footer_before'], $this->theme_order, 1);
                Eventy::addAction('blade_action_footer_after', [$this, 'action_footer_after'], $this->theme_order, 1);
                Eventy::addAction('blade_body_class', [$this, 'body_class'], $this->theme_order, 1);
                Eventy::addAction('blade_sub_header_background', [$this, 'sub_header_background'], $this->theme_order, 1);
                Eventy::addFilter('widgets_homepage_data_about', [$this, 'about_filter_data_home'], $this->theme_order, 1);
                Eventy::addFilter('filter_data_page_about_style1', [$this, 'filter_data_page_about_style1'], $this->theme_order, 1);
            }
        }


        public function filter_data_page_about_style1($arg){
            $newdata            = [];

            /**
             * about
             */
            $about_options = [
                'status'        => $this->get_option('about_status', 'off'),
                'about_page'    => $this->get_option('about_page', '0'),
                'title'         => $this->get_option('about_title', ''),
                'description'   => $this->get_option('about_description', ''),
                'image'         => $this->get_option('about_image', ''),
                'text'          => $this->get_option('about_text', ''),
                'column'        => $this->get_option('about_column', 'col-md-3'),
                'class'         => (in_array($this->get_option('about_class', 'bg_white'), ['bg_black', 'bg_color']))? $this->get_option('about_class').' title-white' : $this->get_option('about_class', 'bg_white'),
                'image_style'   => '',
            ];
            if($this->get_option('about_class', 'bg_white') == 'bg_img'){
                $about_options['class'] = 'bg-image text-white '.$this->get_option('about_attachment', 'fixed').' '.$this->get_option('about_repeat', 'no_repeat').' '.$this->get_option('about_bgsize', 'cover');
                $about_options['image_style'] = ' style="background-image: url('.$this->get_option('about_background').')"';
            }
            $newdata['about_options'] = $about_options;
            $get_aboutboxs = maybe_unserialize(get_option($this->option_name.'_aboutboxs_homepage'));
            $newdata['aboutboxs'] = (is_array($get_aboutboxs))? $get_aboutboxs : [];

            return mega_parse_args($newdata, $arg);
        }

        /**
         * about_filter_data_home($arg)
         */
        public function about_filter_data_home($data = [])
        {
            $default_options['title']           = '';
            $default_options['description']     = '';
            $default_options['more_button']     = false;
            $default_options['more_icon']       = '';
            $default_options['more_txt']        = '';
            $default_options['more_url']        = false;
            $default_options['bgclass']         = 'bg_white';
            $default_options['bgattachment']    = 'fixed';
            $default_options['bgrepeat']        = 'no_repeat';
            $default_options['bgsize']          = 'cover';
            $default_options['image']           = false;
            $default_options['image_style']     = '';
            $default_options['column']          = '1column';
            $default_options['cate']            = [];
            $default_options['catelink']        = 'off';
            $options = mega_parse_args($data, $default_options);
            $newdata = [];
            $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
            if($options['bgclass'] == 'bg_img')
            {
                $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
            }
            $newdata['options'] = $options;
            $newdata['column']  = $options['column'];
            return $newdata;
        }

        public function filter_data_home($arg){
            $newdata            = [];

            /**
             * widgets
             */
            $get_widgets        = maybe_unserialize(get_option($this->option_name.'_widgets_homepage'));
            $newdata['widgets'] = (is_array($get_widgets))? $get_widgets : [];

            /**
             * about
             */
            $about_options = [
                'status'        => $this->get_option('about_status', 'off'),
                'title'         => $this->get_option('about_title', ''),
                'description'   => $this->get_option('about_description', ''),
                'image'         => $this->get_option('about_image', ''),
                'text'          => $this->get_option('about_text', ''),
                'column'        => $this->get_option('about_column', 'col-md-3'),
                'class'         => (in_array($this->get_option('about_class', 'bg_white'), ['bg_black', 'bg_color']))? $this->get_option('about_class').' title-white' : $this->get_option('about_class', 'bg_white'),
                'image_style'   => '',
            ];
            if($this->get_option('about_class', 'bg_white') == 'bg_img'){
                $about_options['class'] = 'bg-image text-white '.$this->get_option('about_attachment', 'fixed').' '.$this->get_option('about_repeat', 'no_repeat').' '.$this->get_option('about_bgsize', 'cover');
                $about_options['image_style'] = ' style="background-image: url('.$this->get_option('about_background').')"';
            }
            $newdata['about_options'] = $about_options;
            $get_aboutboxs = maybe_unserialize(get_option($this->option_name.'_aboutboxs_homepage'));
            $newdata['aboutboxs'] = (is_array($get_aboutboxs))? $get_aboutboxs : [];

            return mega_parse_args($newdata, $arg);
        }

        public function page_template($value){
            //extensions
            $template = [
                'support'           => ['extensions' => ['tickets'], 'title' => $this->lang('support')],
                'contact_style1'    => ['extensions' => false, 'title' => $this->lang('contact_style1')],
                'contact_style2'    => ['extensions' => false, 'title' => $this->lang('contact_style2')],
                'contact_style3'    => ['extensions' => false, 'title' => $this->lang('contact_style3')],
                'team_style1'       => ['extensions' => ['team'], 'title' => $this->lang('team_style1')],
                'team_style2'       => ['extensions' => ['team'], 'title' => $this->lang('team_style2')],
                'team_style3'       => ['extensions' => ['team'], 'title' => $this->lang('team_style3')],
                'team_style4'       => ['extensions' => ['team'], 'title' => $this->lang('team_style4')],
                'team_style5'       => ['extensions' => ['team'], 'title' => $this->lang('team_style5')],
                'about_style1'      => ['extensions' => false, 'title' => $this->lang('about_style1')],
            ];

            foreach($template as $key => $temp){
                if(is_array($temp['extensions'])){
                    if(is_extensions($temp['extensions'])){
                        $select = ($value == $key)? 'selected=""' : '';
                        echo '<option value="'.$key.'" '.$select.'>'.$temp['title'].'</option>';
                    }
                }
                elseif($temp['extensions'] == false) {
                    $select = ($value == $key)? 'selected=""' : '';
                    echo '<option value="'.$key.'" '.$select.'>'.$temp['title'].'</option>';
                }
            }
        }

        public function action_widgets_homepage_options($value)
        {
            $options = ['about' => admin_lang('about')];
            foreach($options as $key => $val)
            {
                $select = ($value == $key)? 'selected=""' : '';
                echo '<option value="'.$key.'" '.$select.'>'.$val.'</option>';
            }            
        }

        function get_options_autoload($arg = [])
        {
            if((is_array($this->options))){
                foreach($this->options as $key => $option)
                {
                    $newdata['thop_'.$key] = $option;
                }
                return mega_parse_args($newdata, $arg);
            }
            else {
                return $arg;
            }
        }

        public function sub_header_background(){
            $src = get_theme_option('sub_header_background');
            if($src){
                echo 'data-parallax="scroll" data-image-src="'.get_theme_option('sub_header_background').'"';
            }
        }

        public function body_class(){
            $class = ' ';
            if(get_theme_option('class_header') != 'normal'){
                $class .= ' '.get_theme_option('class_header');
            }

            if(get_theme_option('boxed')){
                $class .= ' boxed';
            }

            echo $class;
        }

        public function action_header_before(){
            $favicon     = $this->get_option('favicon');
            if ($favicon){
                echo '<link rel="icon" href="'.$favicon.'">';
            }
            else{
                echo '<link rel="icon" href="'.get_asset('images/favicon.ico').'">';
            }
    
        }

        public function action_header_after()
        {
            $background     = $this->get_option('boxed_background');
            $margintop      = $this->get_option('boxed_margintop');
            $marginbottom   = $this->get_option('boxed_marginbottom');
            $repeat         = $this->get_option('boxed_repeat');
            $attachment     = $this->get_option('boxed_attachment');
            $boxed_bgsize   = $this->get_option('boxed_bgsize');

            $stylesheet = '<style type="text/css">';
            if($this->get_option('boxed')){

                if($this->get_option('boxed_bgtype') == 'image'){
                    $stylesheet    .= '.boxed {background: transparent url(\''.$background.'\') '.$attachment.' '.$repeat.' center top;background-size: '.$boxed_bgsize.';margin-top: '.$margintop.'px;margin-bottom: '.$marginbottom.'px;}';
                }
                else
                {
                    $pattern        = $this->get_option('boxed_pattern');
                    $pattern_img = array(
                        'pattern1'  => $this->path_pattern.'/pattern1.jpg',
                        'pattern3'  => $this->path_pattern.'/pattern2.png',
                        'pattern3'  => $this->path_pattern.'/pattern3.jpg',
                        'pattern4'  => $this->path_pattern.'/pattern4.png',
                        'pattern5'  => $this->path_pattern.'/pattern5.png',
                        'pattern6'  => $this->path_pattern.'/pattern6.png',
                        'pattern7'  => $this->path_pattern.'/pattern7.png',
                        'pattern8'  => $this->path_pattern.'/pattern8.png',
                        'pattern9'  => $this->path_pattern.'/pattern9.png',
                        'pattern10' => $this->path_pattern.'/pattern10.png',
                        'pattern11' => $this->path_pattern.'/pattern11.png',
                        'pattern12' => $this->path_pattern.'/pattern12.png',
                        'pattern13' => $this->path_pattern.'/pattern13.jpg',
                        'pattern14' => $this->path_pattern.'/pattern14.png',
                        'pattern15' => $this->path_pattern.'/pattern15.gif',
                        'pattern16' => $this->path_pattern.'/pattern16.png',
                        'pattern17' => $this->path_pattern.'/pattern17.png',
                        'pattern18' => $this->path_pattern.'/pattern18.png',
                        'pattern19' => $this->path_pattern.'/pattern19.png',
                        'pattern20' => $this->path_pattern.'/pattern20.png',
                        'pattern21' => $this->path_pattern.'/pattern21.png'
                    );
                    $stylesheet    .= '.boxed {background: transparent url(\''.$pattern_img[$pattern].'\');margin-top: '.$margintop.'px;margin-bottom: '.$marginbottom.'px;}';
                }
            }
            $stylesheet .= '</style>';

            if($this->get_option('pageloaded')){
                $stylesheet .= '<link rel="stylesheet" href="'.get_asset('css/loaded.min.css').'" type="text/css" />';
            }
            
            if($this->get_option('skinscolor')){
                if(get_theme_option('minify_css')){
                    $stylesheet .= '<link rel="stylesheet" id="skins-'.$this->get_option('skinscolor').'" href="'.get_asset('css/skins/'.$this->get_option('skinscolor').'.min.css').'" type="text/css" />';
                }
                else {
                    $stylesheet .= '<link rel="stylesheet" id="skins-'.$this->get_option('skinscolor').'" href="'.get_asset('css/skins/'.$this->get_option('skinscolor').'.css').'" type="text/css" />';
                }
            }
            
            
            echo $stylesheet;
            echo $this->get_option('header_code');
            echo $this->get_option('customcss');
        }

        public function action_footer_before(){
            if($this->get_option('gotoup')){
                echo '<div class="go-up"><i class="'.$this->get_option('gotoup_icon', 'pe-7s-angle-up').'"></i></div>';
            }
        }

        public function action_footer_after(){
            echo $this->get_option('footer_code');
            echo $this->get_option('customjs');
        }

        public function action_start_body(){
            $html = '';
            if($this->get_option('pageloaded')){
                $html .= '
                <div id="preloader">
                    <div class="cube-wrapper">
                        <div class="cube-folding">
                            <span class="leaf1"></span><span class="leaf2"></span><span class="leaf3"></span><span class="leaf4"></span>
                        </div>
                        <span class="loading">Loading...</span>
                    </div>
                </div>
                ';
            }

            echo $html;
        }

        public function action_script(){
            $html = '';
            if($this->get_option('jpinning')){
                $html .= '<script src="'.get_asset('js/jPinning.min.js').'"></script>';
            }

            if($this->get_option('stickysidebar')){
                $html .= '<script src="'.get_asset('js/ResizeSensor.min.js').'"></script>';
                $html .= '<script src="'.get_asset('js/theia.sticky.sidebar.min.js').'"></script>';
            }            
            echo $html;
        }

        public function action_script_code(){
            $html  = '<script type="text/javascript">';
            $html .= "var is_jpinning = '{$this->get_option('jpinning')}';";
            $html .= "var cookie_id = '{$this->get_option('cookie_id', 'phphelpm5cookie')}';";
            $html .= '</script>';
            echo $html;
        }

        public function lang($string, $replace = [], $file = '', $locale = null){
            $trans = trans('themes/'.$this->theme_folder.'/options.' . $string, $replace, 'en');
            return $trans;
        }

        public function get_option($name, $default = '')
        {
            return (isset($this->options[$name]))? $this->options[$name] : $default;
        }

        public function get_menus(){
            return get_posts_type('menus');
        }

        /**
         * admin_options_menu()
         */
        public function admin_sidebar_appearance()
        {
            $data = ['url' => get_admin_url('themeoptions'), 'title' => admin_lang('theme_options'), 'badge' => ''];
            if(is_permission('theme_options')){
                echo get_admin_view('hooks.admin_sidebar_menu_li', $data)->render();
            }
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data['menus']['general']       = ['icon' => 'bx bx-cog', 'title' => $this->lang('general')];
            $data['menus']['homepage']      = ['icon' => 'bx bx-home', 'title' => $this->lang('home_page')];
            $data['menus']['about']         = ['icon' => 'bx bx-user-pin', 'title' => $this->lang('about')];
            $data['menus']['header']        = ['icon' => 'bx bx-dock-top', 'title' => $this->lang('header')];
            $data['menus']['sub_header']    = ['icon' => 'bx bx-dock-top', 'title' => $this->lang('sub_header')];
            $data['menus']['footer']        = ['icon' => 'bx bx-dock-bottom', 'title' => $this->lang('footer')];
            $data['menus']['style']         = ['icon' => 'bx bx-brush', 'title' => $this->lang('style')];
            $data['menus']['socialmedia']   = ['icon' => 'bx bx-share-alt', 'title' => $this->lang('social_media')];
            $data['menus']['custom']        = ['icon' => 'bx bx-layer', 'title' => $this->lang('custom')];
            $data['menus']['cookie']        = ['icon' => 'bx bx-bulb', 'title' => $this->lang('cookie')];
            $data['menus']['backup']        = ['icon' => 'bx bx-data', 'title' => $this->lang('backup')];

            echo get_admin_view('hooks.admin_theme_options_menu_tab', $data)->render();
        }

        public function get_menus_options(){
            $menus_options = [];
            foreach($this->get_menus() as $menu){
                $menus_options[$menu->id] = $menu->post_title;
            }
            return $menus_options;
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {

            $skinscolor_options = [
                'default'   => ['label' => '', 'boxcolor' => '#11d6f0'],
                'teal'      => ['label' => '', 'boxcolor' => '#20c997'],
                'blue'      => ['label' => '', 'boxcolor' => '#3498db'],
                'cyan'      => ['label' => '', 'boxcolor' => '#2997ab'],
                'lactic'    => ['label' => '', 'boxcolor' => '#26bdef'],
                'purple'    => ['label' => '', 'boxcolor' => '#8e74b2'],
                'purple2'   => ['label' => '', 'boxcolor' => '#4608ad'],
                'yellow'    => ['label' => '', 'boxcolor' => '#f6bb17'],
                'green'     => ['label' => '', 'boxcolor' => '#7daf74'],
                'green2'    => ['label' => '', 'boxcolor' => '#37a000'],
                'pink'      => ['label' => '', 'boxcolor' => '#f1505b'],
                'orange'    => ['label' => '', 'boxcolor' => '#fa7642'],
                'red'       => ['label' => '', 'boxcolor' => '#e74b3e'],
                'darkred'   => ['label' => '', 'boxcolor' => '#c50e0e'],
            ];

            // General
            $data['options']['general']['menus'] = [
                'title'     => $this->lang('menus'),
                'options'   => [
                    ['type' => 'select', 'id' => $this->option_name.'[header_menu]', 'name' => $this->lang('header'), 'value' => $this->get_option('header_menu', '0'), 'options' => $this->get_menus_options()],
                    ['type' => 'select', 'id' => $this->option_name.'[footer_menu]', 'name' => $this->lang('footer'), 'value' => $this->get_option('footer_menu', '0'), 'options' => $this->get_menus_options()],
                ]
            ];

            // home page
            $data['options']['homepage']['widgets'] = [
                'title'     => $this->lang('widgets'),
                'options'   => [
                    ['type' => 'html', 'html' => $this->get_widgets_homepage()]
                ]
            ];

            // about
            $data['options']['about']['about'] = [
                'title'     => $this->lang('about'),
                'options'   => [
                    ['type' => 'upload', 'id' => $this->option_name.'[about_image]', 'name' => admin_lang('image'), 'value' => $this->get_option('about_image', ''), 'src' => 'src'],
                    ['type' => 'textarea', 'id' => $this->option_name.'[about_text]', 'name' => admin_lang('about'), 'rows' => '5', 'value' => $this->get_option('about_text', '')],
                    ['type' => 'radio', 'id' => $this->option_name.'[about_column]', 'name' => admin_lang('column'), 'value' => $this->get_option('about_column', 'col-md-3'), 'options' => [
                        'col-md-3' => '4 '.admin_lang('column'),
                        'col-md-4' => '3 '.admin_lang('column'),
                        'col-md-6' => '2 '.admin_lang('column'),
                    ]],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[about_page]', 'name' => $this->lang('show_in_page'), 'value' => $this->get_option('about_page', 'off')],
                    ['type' => 'border'],
                    ['type' => 'html', 'html' => $this->get_aboutboxs_homepage()]
                ]
            ];

            // header
            $data['options']['header']['header_style'] = [
                'title'     => $this->lang('header_style'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[header_style]', 'name' => $this->lang('header_style'), 'value' => $this->get_option('header_style', 'style1'), 'options' => [
                        'style1'    => ['label' => $this->lang('style_1'), 'img' => get_asset('images/options/header1.png')],
                        'style2'    => ['label' => $this->lang('style_2'), 'img' => get_asset('images/options/header2.png')],
                        'style3'    => ['label' => $this->lang('style_3'), 'img' => get_asset('images/options/header3.png')],
                        'style4'    => ['label' => $this->lang('style_4'), 'img' => get_asset('images/options/header4.png')],
                        'style5'    => ['label' => $this->lang('style_5'), 'img' => get_asset('images/options/header5.png')],
                        'style6'    => ['label' => $this->lang('style_6'), 'img' => get_asset('images/options/header6.png')],
                        'style7'    => ['label' => $this->lang('style_7'), 'img' => get_asset('images/options/header7.png')],
                        'style8'    => ['label' => $this->lang('style_8'), 'img' => get_asset('images/options/header8.png')],
                    ]],
                ]
            ];
            $data['options']['header']['header'] = [
                'title'     => $this->lang('header'),
                'options'   => [
                    ['type' => 'upload', 'id' => $this->option_name.'[logo]', 'name' => $this->lang('logo'), 'value' => $this->get_option('logo'), 'src' => 'src'],
                    ['type' => 'upload', 'id' => $this->option_name.'[logo_mobile]', 'name' => $this->lang('logo_mobile'), 'value' => $this->get_option('logo_mobile'), 'src' => 'src'],
                    ['type' => 'upload', 'id' => $this->option_name.'[favicon]', 'name' => $this->lang('favicon_icon'), 'value' => $this->get_option('favicon', get_asset('images/favicon.ico')), 'src' => 'src'],
                    ['type' => 'code_editor', 'id' => $this->option_name.'[header_code]', 'name' => $this->lang('header_code'),  'value' => $this->get_option('header_code', '')],
                ]
            ];

            // sub_header
            $data['options']['sub_header']['sub_header_style'] = [
                'title'     => $this->lang('sub_header_style'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[sub_header_style]', 'name' => $this->lang('sub_header_style'), 'value' => $this->get_option('sub_header_style', 'style1'), 'options' => [
                        'style1'    => ['label' => $this->lang('style_1'), 'img' => get_asset('images/options/subheader1.png')],
                        'style2'    => ['label' => $this->lang('style_2'), 'img' => get_asset('images/options/subheader2.png')],
                        'style3'    => ['label' => $this->lang('style_3'), 'img' => get_asset('images/options/subheader3.png')],
                        'style4'    => ['label' => $this->lang('style_4'), 'img' => get_asset('images/options/subheader4.png')],
                    ]],
                ]
            ];
            $data['options']['sub_header']['sub_header'] = [
                'title'     => $this->lang('sub_header'),
                'options'   => [
                    ['type' => 'upload', 'id' => $this->option_name.'[sub_header_background]', 'name' => $this->lang('background'), 'value' => $this->get_option('sub_header_background'), 'src' => 'src'],
                    ['type' => 'text', 'id' => $this->option_name.'[sub_header_title]', 'name' => $this->lang('sub_header_title'), 'value' => $this->get_option('sub_header_title')],
                    ['type' => 'text', 'id' => $this->option_name.'[sub_header_title_desc]', 'name' => $this->lang('sub_header_title_desc'), 'value' => $this->get_option('sub_header_title_desc')],
                    ['type' => 'text', 'id' => $this->option_name.'[sub_header_search_text]', 'name' => $this->lang('sub_header_search_text'), 'value' => $this->get_option('sub_header_search_text')],                  
                ]
            ];

            // footer
            $data['options']['footer']['footer_style'] = [
                'title'     => $this->lang('footer_style'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[footer_style]', 'name' => $this->lang('footer_style'), 'value' => $this->get_option('footer_style', 'style1'), 'options' => [
                        'style1'    => ['label' => $this->lang('style_1'), 'img' => get_asset('images/options/footer1.png')],
                        'style2'    => ['label' => $this->lang('style_2'), 'img' => get_asset('images/options/footer2.png')],
                        'style3'    => ['label' => $this->lang('style_3'), 'img' => get_asset('images/options/footer3.png')],
                        'style4'    => ['label' => $this->lang('style_4'), 'img' => get_asset('images/options/footer4.png')],
                    ]],
                ]
            ];
            $data['options']['footer']['mobile_apps'] = [
                'title'     => $this->lang('mobile_apps'),
                'options'   => [
                    ['type' => 'checkbox', 'id' => $this->option_name.'[footer_mobileapps]', 'name' => $this->lang('mobile_apps'), 'value' => $this->get_option('footer_mobileapps', 'off')],
                    ['type' => 'upload', 'id' => $this->option_name.'[footer_mobileapps_background]', 'name' => $this->lang('background'), 'value' => $this->get_option('footer_mobileapps_background'), 'src' => 'src'],   
                    ['type' => 'text', 'id' => $this->option_name.'[footer_mobileapps_title]', 'name' => $this->lang('title'), 'value' => $this->get_option('footer_mobileapps_title')],
                    ['type' => 'textarea', 'id' => $this->option_name.'[footer_mobileapps_desc]', 'name' => $this->lang('description'),  'value' => $this->get_option('footer_mobileapps_desc', '')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[footer_mobileapps_ios]', 'name' => $this->lang('ios'), 'value' => $this->get_option('footer_mobileapps_ios', 'off')],
                    ['type' => 'upload', 'id' => $this->option_name.'[footer_mobileapps_ios_icon]', 'name' => $this->lang('icon'), 'value' => $this->get_option('footer_mobileapps_ios_icon'), 'src' => 'src'],   
                    ['type' => 'text', 'id' => $this->option_name.'[footer_mobileapps_ios_url]', 'name' => $this->lang('url'), 'value' => $this->get_option('footer_mobileapps_ios_url')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[footer_mobileapps_android]', 'name' => $this->lang('android'), 'value' => $this->get_option('footer_mobileapps_android', 'off')],
                    ['type' => 'upload', 'id' => $this->option_name.'[footer_mobileapps_android_icon]', 'name' => $this->lang('icon'), 'value' => $this->get_option('footer_mobileapps_android_icon'), 'src' => 'src'],   
                    ['type' => 'text', 'id' => $this->option_name.'[footer_mobileapps_android_url]', 'name' => $this->lang('url'), 'value' => $this->get_option('footer_mobileapps_android_url')],
                    
                ]
            ];
            $data['options']['footer']['footer'] = [
                'title'     => $this->lang('footer'),
                'options'   => [
                    ['type' => 'text', 'id' => $this->option_name.'[copyright]', 'name' => $this->lang('copyright'), 'value' => $this->get_option('copyright')],
                    ['type' => 'code_editor', 'id' => $this->option_name.'[footer_code]', 'name' => $this->lang('footer_code'),  'value' => $this->get_option('footer_code', '')],
                ]
            ];

            //style 
            $data['options']['style']['style'] = [
                'title'     => $this->lang('style'),
                'options'   => [
                    ['type' => 'checkbox', 'id' => $this->option_name.'[pageloaded]', 'name' => $this->lang('page_loaded'), 'value' => $this->get_option('pageloaded')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[sticky_sidebar]', 'name' => $this->lang('sticky_sidebar'), 'value' => $this->get_option('sticky_sidebar')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[userlink_header]', 'name' => $this->lang('userlink_header'), 'value' => $this->get_option('userlink_header')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[gotoup]', 'name' => $this->lang('gotoup'), 'value' => $this->get_option('gotoup')],
                    ['type' => 'fonticon', 'id' => $this->option_name.'[gotoup_icon]', 'name' => $this->lang('gotoup_icon'), 'value' => $this->get_option('gotoup_icon')],
                    ['type' => 'radio', 'id' => $this->option_name.'[class_header]', 'name' => $this->lang('header'), 'value' => $this->get_option('class_header', 'normal'), 'options' => [
                        'normal'    => $this->lang('normal'),
                        'sticky'    => $this->lang('sticky'),
                        'jpinning'  => $this->lang('jpinning')
                    ]],

                    ['type' => 'checkbox', 'id' => $this->option_name.'[minify_css]', 'name' => $this->lang('minify_css'), 'value' => $this->get_option('minify_css')],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[minify_js]', 'name' => $this->lang('minify_js'), 'value' => $this->get_option('minify_js')],
                    
                    ['type' => 'skinscolor', 'options' => $skinscolor_options, 'id' => $this->option_name.'[skinscolor]', 'name' => $this->lang('layout_color'), 'value' => $this->get_option('skinscolor', 'default')],
                ]
            ];
            $data['options']['style']['boxed'] = [
                'title'     => $this->lang('boxed'),
                'options'   => [
                    ['type' => 'checkbox', 'id' => $this->option_name.'[boxed]', 'name' => $this->lang('boxed'), 'value' => $this->get_option('boxed')],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[boxed_margintop]', 'name' => $this->lang('boxed_margintop'), 'value' => $this->get_option('boxed_margintop', 0), 'min' => '0', 'max' => '150', 'step' => '1'],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[boxed_marginbottom]', 'name' => $this->lang('boxed_marginbottom'), 'value' => $this->get_option('boxed_marginbottom', 0), 'min' => '0', 'max' => '150', 'step' => '1'],
                    ['type' => 'radio', 'id' => $this->option_name.'[boxed_attachment]', 'name' => $this->lang('boxed_attachment'), 'value' => $this->get_option('boxed_attachment', ''), 'options' => [
                        'scroll'    => $this->lang('scroll'),
                        'fixed'     => $this->lang('fixed'),
                        'local'     => $this->lang('local'),
                        'initial'   => $this->lang('initial'),
                        'inherit'   => $this->lang('inherit'),
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[boxed_repeat]', 'name' => $this->lang('boxed_repeat'), 'value' => $this->get_option('boxed_repeat', ''), 'options' => [
                        'repeat'     => $this->lang('repeat'),
                        'no_repeat'  => $this->lang('no_repeat'),
                        'repeat_x'   => $this->lang('repeat_x'),
                        'repeat_y'   => $this->lang('repeat_y')
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[boxed_bgsize]', 'name' => $this->lang('boxed_bgsize'), 'value' => $this->get_option('boxed_bgsize', ''), 'options' => [
                        'auto'      => $this->lang('auto'),
                        'length'    => $this->lang('length'),
                        'cover'     => $this->lang('cover'),
                        'contain'   => $this->lang('contain'),
                        'initial'   => $this->lang('initial'),
                        'inherit'   => $this->lang('inherit'),
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[boxed_bgtype]', 'name' => $this->lang('boxed_bgtype'), 'value' => $this->get_option('boxed_bgtype', ''), 'options' => [
                        'image'     => $this->lang('image'),
                        'pattern'   => $this->lang('pattern'),
                    ]],
                    ['type' => 'upload', 'id' => $this->option_name.'[boxed_background]', 'name' => $this->lang('boxed_background'), 'value' => $this->get_option('boxed_background'), 'src' => 'src'],   
                    ['type' => 'radio', 'id' => $this->option_name.'[boxed_pattern]', 'name' => $this->lang('boxed_pattern'), 'value' => $this->get_option('boxed_pattern', 'pattern1'), 'options' => [
                        'pattern1'    => ['label' => $this->lang('pattern_1'),  'img' => get_asset('images/options/pattern1.jpg')],
                        'pattern2'    => ['label' => $this->lang('pattern_2'),  'img' => get_asset('images/options/pattern2.png')],
                        'pattern3'    => ['label' => $this->lang('pattern_3'),  'img' => get_asset('images/options/pattern3.jpg')],
                        'pattern4'    => ['label' => $this->lang('pattern_4'),  'img' => get_asset('images/options/pattern4.png')],
                        'pattern5'    => ['label' => $this->lang('pattern_5'),  'img' => get_asset('images/options/pattern5.png')],
                        'pattern6'    => ['label' => $this->lang('pattern_6'),  'img' => get_asset('images/options/pattern6.png')],
                        'pattern7'    => ['label' => $this->lang('pattern_7'),  'img' => get_asset('images/options/pattern7.png')],
                        'pattern8'    => ['label' => $this->lang('pattern_8'),  'img' => get_asset('images/options/pattern8.png')],
                        'pattern9'    => ['label' => $this->lang('pattern_9'),  'img' => get_asset('images/options/pattern9.png')],
                        'pattern10'   => ['label' => $this->lang('pattern_10'), 'img' => get_asset('images/options/pattern10.png')],
                        'pattern11'   => ['label' => $this->lang('pattern_11'), 'img' => get_asset('images/options/pattern11.png')],
                        'pattern12'   => ['label' => $this->lang('pattern_12'), 'img' => get_asset('images/options/pattern12.png')],
                        'pattern13'   => ['label' => $this->lang('pattern_13'), 'img' => get_asset('images/options/pattern13.jpg')],
                        'pattern14'   => ['label' => $this->lang('pattern_14'), 'img' => get_asset('images/options/pattern14.png')],
                        'pattern15'   => ['label' => $this->lang('pattern_15'), 'img' => get_asset('images/options/pattern15.gif')],
                        'pattern16'   => ['label' => $this->lang('pattern_16'), 'img' => get_asset('images/options/pattern16.png')],
                        'pattern17'   => ['label' => $this->lang('pattern_17'), 'img' => get_asset('images/options/pattern17.png')],
                        'pattern18'   => ['label' => $this->lang('pattern_18'), 'img' => get_asset('images/options/pattern18.png')],
                        'pattern19'   => ['label' => $this->lang('pattern_19'), 'img' => get_asset('images/options/pattern19.png')],
                        'pattern20'   => ['label' => $this->lang('pattern_20'), 'img' => get_asset('images/options/pattern20.png')],
                        'pattern21'   => ['label' => $this->lang('pattern_21'), 'img' => get_asset('images/options/pattern21.png')],
                    ]],
                ]
            ];

            // social media
            $data['options']['socialmedia']['socials'] = [
                'title'     => $this->lang('socials'),
                'options'   => [
                    ['type' => 'text', 'id' => $this->option_name.'[facebook]', 'name' => $this->lang('facebook'), 'value' => $this->get_option('facebook', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[twitter]', 'name' => $this->lang('twitter'), 'value' => $this->get_option('twitter', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[youtube]', 'name' => $this->lang('youtube'), 'value' => $this->get_option('youtube', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[vimeo]', 'name' => $this->lang('vimeo'), 'value' => $this->get_option('vimeo', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[behance]', 'name' => $this->lang('behance'), 'value' => $this->get_option('behance', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[linkedin]', 'name' => $this->lang('linkedin'), 'value' => $this->get_option('linkedin', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[pinterest]', 'name' => $this->lang('pinterest'), 'value' => $this->get_option('pinterest', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[instagram]', 'name' => $this->lang('instagram'), 'value' => $this->get_option('instagram', false)],
                    ['type' => 'text', 'id' => $this->option_name.'[telegram]', 'name' => $this->lang('telegram'), 'value' => $this->get_option('telegram', false)]
                ]
            ];

            // Custom
            $data['options']['custom']['customcss'] = [
                'title'     => $this->lang('customcss'),
                'options'   => [
                    ['type' => 'code_editor', 'id' => $this->option_name.'[customcss]', 'name' => $this->lang('customcss'),  'value' => $this->get_option('customcss', '')],
                ]
            ];
            $data['options']['custom']['customjs'] = [
                'title'     => $this->lang('customjs'),
                'options'   => [
                    ['type' => 'code_editor', 'id' => $this->option_name.'[customjs]', 'name' => $this->lang('customjs'),  'value' => $this->get_option('customjs', '')],
                ]
            ];

            // cookie
            $data['options']['cookie']['cookie'] = [
                'title'     => $this->lang('cookie'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[cookie_status]', 'name' => $this->lang('cookie_status'), 'value' => $this->get_option('cookie_status', 'off'), 'options' => [
                        'on'  => $this->lang('on'),
                        'off' => $this->lang('off'),
                    ]],
                    ['type' => 'text', 'id' => $this->option_name.'[cookie_id]', 'name' => $this->lang('cookie_id'), 'value' => $this->get_option('cookie_id')],
                    ['type' => 'radio', 'id' => $this->option_name.'[cookie_position]', 'name' => $this->lang('cookie_position'), 'value' => $this->get_option('cookie_position', 'left'), 'options' => [
                        'left'  => $this->lang('left'),
                        'right' => $this->lang('right')
                    ]],
                    ['type' => 'upload', 'id' => $this->option_name.'[cookie_image]', 'name' => $this->lang('cookie_image'), 'value' => $this->get_option('cookie_image'), 'image' => get_asset('images/cookie.svg') , 'src' => 'src'], 
                    ['type' => 'text', 'id' => $this->option_name.'[cookie_title]', 'name' => $this->lang('cookie_title'), 'value' => $this->get_option('cookie_title')],
                    ['type' => 'textarea', 'id' => $this->option_name.'[cookie_desc]', 'name' => $this->lang('cookie_desc'),  'value' => $this->get_option('cookie_desc', '')],
                    ['type' => 'text', 'id' => $this->option_name.'[cookie_decline]', 'name' => $this->lang('cookie_decline'), 'value' => $this->get_option('cookie_decline')],
                    ['type' => 'text', 'id' => $this->option_name.'[cookie_consent]', 'name' => $this->lang('cookie_consent'), 'value' => $this->get_option('cookie_consent')],
                    ['type' => 'radio', 'id' => $this->option_name.'[cookie_style]', 'name' => $this->lang('style'), 'value' => $this->get_option('cookie_style', 'style1'), 'options' => [
                        'style1' => ['label' => $this->lang('style_1'), 'img' => get_asset('images/options/cookie1.png')],
                        'style2' => ['label' => $this->lang('style_2'), 'img' => get_asset('images/options/cookie2.png')],
                        'style3' => ['label' => $this->lang('style_3'), 'img' => get_asset('images/options/cookie3.png')],
                    ]],
                ]
            ];

            // backup
            $data['options']['backup']['export'] = [
                'title'     => $this->lang('export'),
                'options'   => [
                   ['type' => 'textarea_full', 'id' => '', 'rows' => '15',  'value' => get_option($this->option_name)],
                   ['type' => 'link', 'class' => 'btn btn-primary', 'url' => get_admin_url('themeoptions/backupexport-'.$this->option_name), 'text' => $this->lang('download'), 'align' => 'border-0']
                ]
            ];
            $data['options']['backup']['import'] = [
                'title'     => $this->lang('import'),
                'options'   => [
                   ['type' => 'textarea_full', 'id' => 'backup_import', 'rows' => '15',  'setid' => 'backup_import', 'value' => ''],
                   ['type' => 'button', 'button' => 'submit', 'class' => 'btn btn-primary', 'name' => 'import', 'value' => 'import', 'text' => $this->lang('import'), 'align' => 'border-0']
                ]
            ];

            echo get_admin_view('hooks.admin_theme_options_menu_content', $data)->render();
        }

        function get_widgets_homepage()
        {
            $get_widgets        = maybe_unserialize(get_option($this->option_name.'_widgets_homepage'));
            $data['widgets']    = (is_array($get_widgets))? $get_widgets : [];
            $data['option_name']    = 'widgets_homepage';
            return get_admin_view('hooks.admin_theme_options_widgets', $data)->render();
        }

        function get_aboutboxs_homepage()
        {
            $get_about          = maybe_unserialize(get_option($this->option_name.'_aboutboxs_homepage'));
            $data['about_boxs'] = (is_array($get_about))? $get_about : [];
            return get_admin_view('hooks.admin_theme_options_about', $data)->render();
        }

        /**
         * admin_options_save()
         */
        public function admin_options_save($request)
        {
            if($request->has('import') and $request->get('import') == 'import' and $request->get('backup_import')){
                update_option($this->option_name, $request->get('backup_import'));
            }
            else {
                update_option($this->option_name.'_widgets_homepage', maybe_serialize($request->get('widgets_homepage')));
                update_option($this->option_name.'_aboutboxs_homepage', maybe_serialize($request->get('aboutboxs_homepage')));
                update_option($this->option_name, maybe_serialize($request->get($this->option_name)));
            }
        }

    }
    new theme_default();
}