@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row">
        @if(is_extensions('team') and isset($teams))
        @foreach ($teams as $item)
        <div class="{{$column_style5}} col-12">
            <div class="box-team-style2 box-team-hover">
                <img src="{{get_attachment_url(get_post_meta('thumbnails', $item->id), 'thumbnail')}}" alt="{{$item->post_title}}" />
                <h5>{{$item->post_title}} <em>{{get_post_meta('job', $item->id)}}</em></h5>
                <p>{{$item->post_excerpts}}</p>
                <ul class="socials">
                    @if(get_post_meta('facebook', $item->id))<li class="facebook"><a href="{{get_post_meta('facebook', $item->id)}}"><i class="fab fa-facebook-f"></i></a></li>@endif
                    @if(get_post_meta('twitter', $item->id))<li class="twitter"><a href="{{get_post_meta('twitter', $item->id)}}"><i class="fab fa-twitter"></i></a></li>@endif
                    @if(get_post_meta('instagram', $item->id))<li class="instagram"><a href="{{get_post_meta('instagram', $item->id)}}"><i class="fab fa-instagram"></i></a></li>@endif
                </ul>
            </div>
        </div>
        @endforeach
        @endif
    </div>
</div>
@endsection