@if(get_option('comments_status') == 'system')
    @if(count($comments))
    <div class="comments-list">
        <div class="head-title"><h6>{{lang('comments')}} ( {{get_count_comments($single->id, $single->post_type)}} )</h6></div>
        <ol class="commentlist clearfix">
            @foreach ($comments as $comment)
            @if(!$comment->cparent) 
            <li class="comment comment-{{$comment->cid}}">
                <div class="comment-body clearfix"> 
                    <div class="avatar"><img src="@if($comment->cuid){{get_user_avatar($comment->cuid)}}@else{{get_user_avatar_username($comment->cuname)}}@endif" alt=""></div>
                    <div class="comment-text">
                        <div class="author clearfix">
                            <div class="comment-meta">
                                <span>@if($comment->cuid) {{get_username($comment->cuid)}} @else {{$comment->cuname}} @endif</span>
                                <div class="date">{{date('D d M Y, h:i a', $comment->cmodified)}}</div> 
                            </div>
                            <a href="#" class="comment-reply reply-parent-comment" data-parent="{{$comment->cid}}"><i class="fa fa-reply"></i> {{lang('reply')}}</a>
                        </div>
                        <div class="text"><p>{!! nl2br($comment->ccontent) !!}</p></div>
                    </div>
                </div>
            </li>
            @endif
            @foreach (get_comments_parent($comment->cid, $single->post_type) as $children)
            <li class="comment comment-{{$children->cid}} children">
                <div class="comment-body clearfix"> 
                    <div class="avatar"><img src="@if($children->cuid){{get_user_avatar($children->cuid)}}@else{{get_user_avatar_username($children->cuname)}}@endif" alt=""></div>
                    <div class="comment-text">
                        <div class="author clearfix">
                            <div class="comment-meta">
                                <span>@if($children->cuid) {{get_username($children->cuid)}} @else {{$children->cuname}} @endif</span>
                                <div class="date">{{date('D d M Y, h:i a', $comment->cmodified)}}</div> 
                            </div>
                        </div>
                        <div class="text"><p>{!! nl2br($children->ccontent) !!}</p></div>
                    </div>
                </div>
            </li>
            @endforeach
            @endforeach
        </ol>
    </div>
    @endif
    @if($single->comment_status)
    <div class="comment-form">
        <div class="head-title"><h4>{{lang('leave_comment')}}</h4></div>
        @if(get_option('comments_gueststatus') or Auth::check())
            @if(session()->has('success'))<div class="alert alert-success alert-dismissible fade show">{{ session()->get('success') }}</div>@endif
            <form id="form-comment" method="POST" action="{{ url('sendcomment') }}">
                {{ csrf_field() }}
                @if (Auth::guest())
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group">
                            <div class="frm-input frm-icon">
                                <i class="far fa-user"></i>
                                <input type="text" name="username" class="form-control" placeholder="{{lang('enter_username')}}" value="{{old('username')}}" />
                            </div>
                            @if($errors->has('username'))<div class="validation">{{ $errors->first('username') }}</div>@endif
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group">
                            <div class="frm-input frm-icon">
                                <i class="far fa-envelope"></i>
                                <input type="email" name="email" class="form-control" placeholder="{{lang('enter_email')}}" value="{{old('email')}}" />
                            </div>
                            @if($errors->has('email'))<div class="validation">{{ $errors->first('email') }}</div>@endif
                        </div>
                    </div>
                </div>
                @endif
                <div class="form-group">
                    <textarea class="form-control height-md" name="comment" placeholder="{{lang('enter_comment')}}">{{old('comment')}}</textarea>
                    @if($errors->has('comment'))<div class="validation">{{ $errors->first('comment') }}</div>@endif
                </div>
                @if(get_option_inarray('apikeys_options', 'captcha_status'))
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{get_option_inarray('apikeys_options', 'recaptcha_key')}}"></div>
                        @if($errors->has('g-recaptcha-response'))<div class="validation">{{ $errors->first('g-recaptcha-response') }}</div>@endif
                    </div>
                @endif
                <input type="hidden" name="pid" value="{{$single->id}}" />
                <input type="hidden" name="commenttype" value="{{$single->post_type}}" />
                <input type="hidden" name="action" value="addcomment" />
                <button type="submit" class="button"><span>{{lang('submit')}}</span></button>
            </form>
        @endif
        @if(!get_option('comments_gueststatus') and Auth::guest()) <div class="alert alert-warning text-center" role="alert">{{lang('close_comment_user_only')}}</div> @endif
    </div>
    @endif
@elseif(get_option('comments_status') == 'disqus')
<div id="disqus_thread"></div>
@elseif(get_option('comments_status') == 'graph_comment')
<div id="graphcomment"></div>
@endif



@push('scripts')
@if($errors->any() or session()->has('success'))
<script>$('html').animate({scrollTop: $('#form-comment').offset().top - 80}, 500);</script>
@endif
@if(get_option_inarray('apikeys_options', 'captcha_status'))
@if(site_config('language') == 'ar')
<script src="https://www.google.com/recaptcha/api.js?hl=ar"></script>
@else
<script src="https://www.google.com/recaptcha/api.js"></script>
@endif
@endif
@if(get_option('comments_status') == 'disqus')
<script>(function() {var d = document, s = d.createElement('script');s.src = '//{{ get_option('disqusid') }}.disqus.com/embed.js';s.setAttribute('data-timestamp', +new Date());(d.head || d.body).appendChild(s);})();</script>
@elseif(get_option('comments_status') == 'graph_comment')
<script>window.gc_params = {graphcomment_id: '{{ get_option('graphcommentid') }}',fixed_header_height: 0,};(function() {var gc = document.createElement('script'); gc.type = 'text/javascript'; gc.async = true;gc.src = '//graphcomment.com/js/integration.js?' + Math.round(Math.random() * 1e8);(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(gc);})();</script>
@endif
@endpush
