@if(get_theme_option('cookie_status') == 'on')
@if(get_theme_option('cookie_style') == 'style2')
<div class="cookieinfo cookiebox">
    <div class="cookieinfo-close cookie-consent loading">{{ get_theme_option('cookie_consent') }}</div>
    <span>{!!get_theme_option('cookie_desc')!!}</span>
</div>
@elseif(get_theme_option('cookie_style') == 'style3')
<div class="cookies-banner cookiebox">
    <div class="cookies-banner-container container">
        <p class="cookies-banner-text" style="background-image: url({{ get_theme_option('cookie_image', get_asset('images/cookie2.svg')) }})">{!!get_theme_option('cookie_desc')!!}</p>
        <span class="cookies-banner-action">
            <button class="cookies-banner-button cookie-consent loading">{{ get_theme_option('cookie_consent') }}</button>
        </span>
    </div>
</div>
@else
<div class="cookie-box cookiebox {{ get_theme_option('cookie_position') }}">
    <div class="cookie-box-inner">
        <img src="{{ get_theme_option('cookie_image', get_asset('images/cookie.svg')) }}" alt="cookie">
        <div class="cookie-content">
            <h3>{{ get_theme_option('cookie_title') }}</h3>
            <p>{!!get_theme_option('cookie_desc')!!}</p>
            <div class="buttons">
                <button class="button cookie-decline">{{ get_theme_option('cookie_decline') }}</button>
                <button class="button cookie-consent loading">{{ get_theme_option('cookie_consent') }}</button>
            </div>
        </div>
    </div>
</div>
@endif
<script src="{{ get_asset('js/jquery.cookie.js') }}"></script>
<script src="{{ get_asset('js/cookie.min.js') }}"></script>
@endif