@extends(get_extends('layouts.master'))
@section('content')
<div class="padding_80">
    <div class="container">
        <div class="row @if($testimonials_style == 'fixed') justify-content-center @endif">
            <div class="@if($testimonials_style == 'full') col-lg-12  @elseif($testimonials_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
                @if($testimonials_form_status)
                <div class="testimonial-form">
                    @if($testimonials_form_title)<div class="head-title"><h4>{{$testimonials_form_title}}</h4></div>@endif
                    @if($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    @if(session()->has('success'))<div class="alert alert-success alert-dismissible fade show">{{ session()->get('success') }}</div>@endif
                    <form method="post" id="form-submit-testimonial" action="{{ url('/testimonials/submitrating') }}" role="form">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="frm-input frm-icon">
                                        <i class="far fa-user"></i>
                                        <input type="text" name="username" class="form-control" placeholder="{{lang('enter_username')}}" value="{{old('username')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-rating">
                                    <label class="label-rating">rating</label>
                                    <div class="frm-input frm-rating">
                                        <div class="rating">
                                            <input type="radio" name="rating" value="5" checked="" id="rating-5">
                                            <label for="rating-5"></label>
                                            <input type="radio" name="rating" value="4" id="rating-4">
                                            <label for="rating-4"></label>
                                            <input type="radio" name="rating" value="3" id="rating-3">
                                            <label for="rating-3"></label>
                                            <input type="radio" name="rating" value="2" id="rating-2">
                                            <label for="rating-2"></label>
                                            <input type="radio" name="rating" value="1" id="rating-1">
                                            <label for="rating-1"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="frm-input frm-icon">
                                <textarea name="message" rows="4" id="message" class="form-control height-sm" placeholder="{{lang('message')}}"></textarea>
                            </div>
                        </div>
                        <button class="button">{{lang('submit')}}</button>
                    </form>
                </div>
                @endif
                <div class="row align-items-end">
                    @foreach ($testimonials as $item)
                    <div class="col-md-4 col-12">
                        <div class="testimonial-item">
                            <div class="testimonial-content">
                                <div class="testimonial-review">
                                    <p>{{$item->post_content}}</p>
                                </div>
                            </div>            
                            <div class="testimonial-footer">
                                <div class="testimonial-avatar">
                                    <img src="@if($item->thumbnail){{get_attachment_url($item->thumbnail, 'thumbnail')}}@else{{$testimonials_avatar}}@endif" alt="{{$item->post_title}}">
                                </div>              
                                <div class="testimonial-owner-content">
                                    <p class="testimonial-owner">{{$item->post_title}}</p>
                                    <p class="testimonial-position">{{$item->position}}</p>
                                    <div class="testimonial-rating">
                                        <ul class="stars">
                                            @for ($i = 1; $i <= 5; $i++)<li class="@if($i <= $item->rating) active @endif"><i class="fa fa-star"></i></li>@endfor
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="text-center">
                    {{ $testimonials->links(get_include('plugins.pagination')) }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection