<div class="padding_80 {{$options['bgclass']}}" {!!$options['image_style']!!}>
    <div class="container">
        @if($options['title'])
        <div class="main_title">
            <h2>{{$options['title']}}</h2>
            <p>{{$options['description']}}</p>
            <span class="divider"></span>
        </div>
        @endif
        @if($options['style'] == 'owlcarousel')
        <div class="row">
            <div class="col-md-12">
                @if(isset($clients))
                <div class="owl-carousel owl-{{$options['widgetid']}}">
                    @foreach ($clients as $item)
                    <div class="item">
                        <div class="client">
                            <a href="{{$item->client_url}}"><img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="img-responsive" alt="{{$item->post_title}}"></a>
                        </div>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
        @else
        <div class="row g-0 clients-wrap">
            @if(isset($clients))
            @foreach ($clients as $item)
            <div class="col-lg-3 col-md-4 col-xs-6">
                <div class="client-logo">
                    <a href="{{$item->client_url}}"><img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="img-responsive" alt="{{$item->post_title}}"></a>
                </div>
            </div>
            @endforeach
            @endif
        </div>
        @endif
        @if($options['more_button'])
        <div class="row">
            <div class="col-md-12">
                <div class="home-more">
                    <a href="{{$options['more_url']}}">@if($options['more_icon'])<i class="{{$options['more_icon']}}"></i>@endif {{$options['more_txt']}}</a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@push('scripts_code')
@if($options['style'] == 'owlcarousel')
$('.owl-{{$options['widgetid']}}').owlCarousel({
    @if($site_dir == 'rtl') rtl: true, @endif
    navigation: false,
    pagination: false,
    autoPlay: true,
    items: {{$options['owlrespc']}},
    loop: !1,
    dots: true,
    margin: 25,
    responsive: {0:{items:{{$options['owlresphone']}}},800:{items:{{$options['owlrestablet']}}},1000:{items:{{$options['owlrespc']}}}}
});
@endif
@endpush