<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DriverController;
use App\Http\Controllers\Api\CompanyController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// AuthController Routes.
Route::post('/login', [AuthController::class, 'loginUser']);
Route::post('/verify_email', [AuthController::class,'verify_email'])->name('verify_email');
Route::get('/change_password/{id}', [AuthController::class,'change_password'])->name('change_password');
Route::post('/change_password_check', [AuthController::class,'change_password_check'])->name('change_password_check');
Route::get('/verification/{id}', [AuthController::class,'verification'])->name('verification');
Route::post('/verified',[AuthController::class,'verifiedOtp'])->name('verifiedOtp');
Route::post('/resend-otp/{mode?}',[AuthController::class,'resendOtp'])->name('resendOtp');

// DriverController Routes.
Route::get('drivers', [DriverController::class, 'drivers'])->name('drivers');
Route::get('ajaxlist_driver', [DriverController::class,'ajaxlist_driver'])->name('ajaxlist_driver');
Route::get('driver_fund', [DriverController::class, 'driver_fund'])->name('driver_fund');
Route::get('ajaxlist_driver_fund', [DriverController::class,'ajaxlist_driver_fund'])->name('ajaxlist_driver_fund');
Route::get('add_driver/{mode?}', [DriverController::class, 'add_driver'])->name('add_driver');
Route::post('store_driver', [DriverController::class, 'store_driver'])->name('store_driver');
Route::post('quick_driver_add', [DriverController::class, 'quick_driver_add'])->name('quick_driver_add');
Route::post('admin_driver_add', [DriverController::class, 'admin_driver_add'])->name('admin_driver_add');
Route::post('admin_quick_driver_add', [DriverController::class, 'admin_quick_driver_add'])->name('admin_quick_driver_add');
Route::get('/add_load_funds/{id?}', [DriverController::class, 'add_load_funds'])->name('add_load_funds');
Route::post('store_load_funds', [DriverController::class,'store_load_funds'])->name('store_load_funds');
Route::get('/driver/{id?}/{mode?}', [DriverController::class, 'driver_edit'])->name('driver_edit');
Route::put('driver_card_details', [DriverController::class,'driver_card_details'])->name('driver_card_details');
Route::put('/driver_actions', [DriverController::class, 'driver_actions'])->name('driver_actions');
Route::put('/driver_card_pin', [DriverController::class, 'driver_card_pin'])->name('driver_card_pin');
Route::put('/driver_personal_data', [DriverController::class, 'driver_personal_data'])->name('driver_personal_data');
Route::delete('/driver_delete/{id}', [DriverController::class, 'driver_delete'])->name('driver_delete');
Route::get('get_cashavailable/{id}', [DriverController::class,'get_cashavailable'])->name('get_cashavailable');
Route::get('card_info/{id}', [DriverController::class,'card_info'])->name('card_info');
Route::get('liveSmartDriverData/{id}', [DriverController::class,'liveSmartDriverData'])->name('liveSmartDriverData');
Route::get('/driver_profile/{id?}', [DriverController::class, 'driver_profile'])->name('driver_profile');
Route::put('/user_send_form', [DriverController::class, 'user_send_form'])->name('user_send_form');
Route::put('/personal_data_add', [DriverController::class, 'personal_data_add'])->name('personal_data_add');

// CompanyController Routes.
Route::get('/companys', [CompanyController::class, 'companys'])->name('companys');
Route::get('/company_add', [CompanyController::class, 'company_add'])->name('company_add');
Route::post('/company_store', [CompanyController::class, 'company_store'])->name('company_store');
Route::get('/company_edit', [CompanyController::class, 'company_edit'])->name('company_edit');
Route::post('/company_actions', [CompanyController::class, 'company_actions'])->name('company_actions');
Route::get('/disable_company/{id}', [CompanyController::class, 'disable_company'])->name('disable_company');
Route::get('/enable_company/{id}', [CompanyController::class, 'enable_company'])->name('enable_company');
Route::get('/delete_company/{id}/', [CompanyController::class, 'delete_company'])->name('delete_company');
