<?php $__env->startSection('content'); ?>
    <style>
        .red {
            color: red;
        }
    </style>
    <?php app('eventy')->action('admin_dashboard_before_counter'); ?>
    <?php if(Auth::user()->userlevel == 'supervisor'): ?>
        <div class="col-md-3 mb-3">
            <a href="<?php echo e(get_admin_url('driveradd/quickAdd')); ?>" class="btn btn-primary btn-sm">Quick Add</a>
        </div>
        <div class="row">
            <?php app('eventy')->action('admin_dashboard_counter'); ?>
            <?php if(session()->has('success')): ?>
                <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                        data-bs-dismiss="alert" aria-label="Close"></button><?php echo e(session()->get('success')); ?></div>
                <?php session()->forget('success');?>
            <?php endif; ?>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Balance</p>
                                <h4
                                    class="mb-0 <?php echo e(Auth::user()->credit_available < Auth::user()->low_limit_threshold ? 'red' : ''); ?>">
                                    $ <?php echo e(number_format(get_balance(), 2)); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="<?php echo e(route('driver')); ?>" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Active Drivers</p>
                                <h4 class="mb-0"><?php echo e(get_driver_count()); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="<?php echo e(route('driver')); ?>" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium" style="margin-bottom: 5px;">Total Active Card</p>
                                <h4 class="mb-0"><?php echo e(get_card_count()); ?></h4>
                                <p style="margin-bottom: 0px;">$ <?php echo e(sum_of_cash_available()); ?></p>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium" style="margin-bottom: 5px;">Low Balance Alert</p>
                                <h4>$ <?php echo e(number_format(Auth::user()->low_limit_threshold, 2)); ?></h4>
                                <form action="<?php echo e(route('low_limit_threshold', Auth::user()->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="text" class="mb-2" name="low_limit_threshold"
                                        value="<?php echo e(Auth::user()->low_limit_threshold ? Auth::user()->low_limit_threshold : ''); ?>"
                                        size="8" placeholder="Low Limit Threshold">
                                    <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                </form>
                            </div>
                            <!-- <div class="flex-shrink-0 align-self-center">
                                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                                </div>
                                            </div> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php elseif(Auth::user()->userlevel == 'admin'): ?>
        <div class="row">
            <?php app('eventy')->action('admin_dashboard_counter'); ?>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Balance</p>
                                <h4 class="mb-0">$ <?php echo e(get_sum_of_all_company_user()); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="<?php echo e(route('driver')); ?>" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Active Drivers</p>
                                <h4 class="mb-0"><?php echo e(get_admin_driver_count()); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="<?php echo e(route('driver')); ?>" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Active Cards</p>
                                <h4 class="mb-0"><?php echo e(get_admin_card_count()); ?> </h4>
                                <p style="margin-bottom: 0px;">$ <?php echo e(sum_of_admin_cash_available()); ?></p>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="<?php echo e(route('usercompanys')); ?>" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Company</p>
                                <h4 class="mb-0"><?php echo e(get_company_count()); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="row">
            <?php app('eventy')->action('admin_dashboard_counter'); ?>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Cash Available</p>
                                <h4 class="mb-0">$ <?php echo e(number_format(getCardAvaCash($driver->SMART_DRIVERID), 2)); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium"><?php echo e(admin_lang('administrator')); ?></p>
                                <h4 class="mb-0"><?php echo e(get_user_level_count('admin')); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium"><?php echo e(admin_lang('supervisor')); ?></p>
                                <h4 class="mb-0"><?php echo e(get_user_level_count('supervisor')); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium"><?php echo e(admin_lang('users')); ?></p>
                                <h4 class="mb-0"><?php echo e(get_user_level_count('user')); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium"><?php echo e(admin_lang('media_library')); ?></p>
                                <h4 class="mb-0"><?php echo e(get_media_count()); ?></h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-camera font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php app('eventy')->action('admin_dashboard_after_counter'); ?>
    <?php if(Auth::user()->userlevel == 'admin' || Auth::user()->userlevel == 'supervisor'): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-sm-flex flex-wrap">
                            <h4 class="card-title mb-4"><?php echo e(admin_lang('total_active_cards')); ?></h4>
                        </div>
                        <div class="col-md-2">
                            <form action="<?php echo e(route('index_dashboard')); ?>" method="GET">
                                <select name="past_year" id="past_year"
                                    class="form-control custom-select form-select custom-select-sm form-control form-control-sm mb-3"
                                    required>
                                    <option
                                        value="<?php echo e(date('Y')); ?>"<?php echo e(!request()->has('past_year') || request()->get('past_year') == date('Y') ? ' selected' : ''); ?>>
                                        <?php echo e(date('Y')); ?></option>
                                    <?php
                                    $currentYear = date('Y');
                                    for ($i = $currentYear - 1; $i >= $currentYear - 3; $i--) {
                                        echo '<option value="' . $i . '"' . (request()->has('past_year') && request()->get('past_year') == $i ? ' selected' : '') . '>' . $i . '</option>';
                                    }
                                    ?>
                                </select>

                                <button type="submit" class="btn btn-primary btn-sm"><?php echo e(admin_lang('submit')); ?></button>
                            </form>
                        </div>
                        <div id="stacked-column-chart" class="apex-charts" dir="ltr">

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="d-sm-flex flex-wrap">
                    <h4 class="card-title">Last Driver Add</h4>
                </div>
                <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                    <thead>
                        <tr>
                            <th>First Name</th>
                            <th>Last Name</th>
                            <th>Card #</th>
                            <th><strong><b>Cash</b></strong></th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Sub Status</th>
                            <?php if(Auth::user()->userlevel == 'admin'): ?>
                                <th>Company</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($driver->FIRST_NAME); ?>

                                </td>
                                <td>
                                    <?php echo e($driver->LAST_NAME); ?>

                                </td>
                                <td>
                                    <?php if(!empty($driver->CARD_NUM)): ?>
                                        <?php if(Auth::user()->userlevel == 'admin'): ?>
                                            <?php echo e($driver->CARD_NUM); ?>

                                        <?php else: ?>
                                            <?php echo e(substr($driver->CARD_NUM, 0, 6)); ?>******<?php echo e(substr($driver->CARD_NUM, -4)); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td><strong><b>
                                            $ <?php echo e(number_format($driver->cashAvailable, 2)); ?>

                                        </b></strong>
                                </td>
                                <td>
                                    <?php echo e($driver->DRIVER_PHONE); ?>

                                </td>
                                <td>
                                    <?php echo e($driver->STATUS == 1 ? 'Active' : 'InActive'); ?>

                                </td>
                                <td>
                                    <?php echo e($driver->SUB_STATUS); ?>

                                </td>
                                <?php if(Auth::user()->userlevel == 'admin'): ?>
                                    <td>
                                        <?php echo e($driver->users->company_name); ?>

                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="d-sm-flex flex-wrap">
                    <h4 class="card-title">Last Driver Fund Add</h4>
                </div>
                <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                    <thead>
                        <tr>
                            <th>Driver Name</th>
                            <th>Amount</th>
                            <th>Issue To</th>
                            <th>Notes</th>
                            <th>Ref ID</th>
                            <th>Created Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $driver_fund; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                               <?php echo e($driver->drivers->USERNAME); ?>

                            </td>
                            <td>
                                $ <?php echo e(number_format($driver->amount, 2)); ?>

                            </td>
                            <td>
                                <?php echo e($driver->issue_to); ?>

                            </td>
                            <td>
                                <?php echo e($driver->notes); ?>

                            </td>
                            <td>
                               <?php echo e($driver->ref_id); ?>

                           </td>
                           <td>
                               <?php echo e(date('m-d-Y', strtotime($driver->created_at))); ?>

                           </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_code'); ?>
    <script type="text/javascript" src="<?php echo e(asset('dashboard/js/apexcharts.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('dashboard/js/echarts.min.js')); ?>"></script>
    <script>
        <?php if(Auth::user()->userlevel == 'admin' || Auth::user()->userlevel == 'supervisor'): ?>
            var options_visitors = {
                chart: {
                    height: 270,
                    type: "bar",
                    stacked: !0,
                    toolbar: {
                        show: !1
                    },
                    zoom: {
                        enabled: !0
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: !1,
                        columnWidth: "15%",
                        endingShape: "rounded"
                    }
                },
                dataLabels: {
                    enabled: !1
                },
                series: [{
                    name: "",
                    data: [
                        <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($card['data']); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                }],
                xaxis: {
                    categories: [
                        <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($card['name']); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                },
                colors: ["#556ee6"],
                legend: {
                    position: "bottom"
                },
                fill: {
                    opacity: 1
                }
            };
            chart_visitors = new ApexCharts(document.querySelector("#stacked-column-chart"), options_visitors);
            chart_visitors.render();
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/index_dashboard.blade.php ENDPATH**/ ?>