
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e($page_title); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($page_title); ?></li>
        </ol>
    </div>
</div>
<div class="row mb-3">
    <div class="col-md-3 data-tables-filter">
        <form method="GET" action="" class="form-filter">
            <input type="search" name="s" class="form-control form-control-sm" value="<?php echo e(request()->get('s')); ?>" placeholder="<?php echo e(admin_lang('search')); ?>">
            <button type="submit" class="btn btn-sm btn-primary button-form-filter"><?php echo e(admin_lang('search')); ?></button>
        </form>
    </div>
    <div class="col-md-9">

    </div>
</div>
<div class="card">
    <div class="card-body">
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button><?php echo e(session()->get('success')); ?></div>
        <?php endif; ?>
        <form class="form-horizontal" method="POST" action="<?php echo e(get_admin_url('UsercompanysActions')); ?>">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1"><?php echo e(admin_lang('bulk_actions')); ?></option>
                            <option value="enable"><?php echo e(admin_lang('enable')); ?></option>
                            <option value="disable"><?php echo e(admin_lang('disable')); ?></option>
                            <option value="delete"><?php echo e(admin_lang('delete')); ?></option>
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="<?php echo e(admin_lang('apply')); ?>" onclick="return confirm(\'<?php echo e(admin_lang('apply_confirm')); ?>\');">
                    </div>
                </div>
                <div class="col-md-8 align-right">
                    <a href="<?php echo e($url_new); ?>" class="btn btn-sm btn-primary"><?php echo e(admin_lang('add_new')); ?></a>
                </div>
            </div>
            <table id="jq-table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th><?php echo e(admin_lang('username')); ?></th>
                        <th class="hidden-phone text-center"><?php echo e(admin_lang('email')); ?></th>
                        <?php app('eventy')->action('admin_users_th'); ?>
                        <th class="hidden-phone text-center"><?php echo e(admin_lang('role')); ?></th>
                        <th class="hidden-phone text-center"><strong><b>Balance</b></strong></th>
                        <th class="hidden-phone text-center"><?php echo e(admin_lang('created')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="td-checkbox">
                            <?php if($user->id == env('default_adminid')): ?>
                            <i class="bx bxs-shield-alt-2"></i>
                            <?php else: ?>
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="<?php echo e($user->id); ?>" id="select-<?php echo e($user->id); ?>" />
                                <label class="custom-control-label" for="select-<?php echo e($user->id); ?>"></label>
                            </div>
                            <?php endif; ?>
                            <?php if($user->status): ?><span class="sq-post-status disable"></span><?php else: ?><span class="sq-post-status enable"></span><?php endif; ?>
                        </td>
                        <td>
                            <img src="<?php echo e(get_user_avatar($user->id)); ?>" class="image-table">
                            <strong><a href="<?php echo e(get_admin_url('profilecompany/'.$user->id)); ?>"><?php echo e(get_username($user->id)); ?></a></strong>
                            <div class="row-actions">
                                <a href="<?php echo e(get_admin_url('profilecompany/'.$user->id)); ?>"><?php echo e(admin_lang('profile')); ?></a>
                                <?php if($user->id != env('default_adminid')): ?>
                                |
                                <?php if($user->status): ?>
                                <a href="<?php echo e(get_admin_url('disable'.$url_prefix.'/'.$user->id)); ?>" class="green"><?php echo e(admin_lang('disable')); ?></a> |
                                <?php else: ?>
                                <a href="<?php echo e(get_admin_url('enable'.$url_prefix.'/'.$user->id)); ?>" class="red"><?php echo e(admin_lang('enable')); ?></a> |
                                <?php endif; ?>
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="<?php echo e(get_admin_url('deleteuser/'.$user->id.'/'.csrf_token() )); ?>" data-body="<?php echo e(admin_lang('delete_confirm')); ?> # <?php echo e($user->username); ?>?" class="red"><?php echo e(admin_lang('delete')); ?></a>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="hidden-phone text-center"><a href="mailto:<?php echo e($user->email); ?>"><?php echo e($user->email); ?></a></td>
                        <?php app('eventy')->action('admin_users_td', $user); ?>
                        <td class="hidden-phone text-center"><?php echo e(admin_lang('userlevel_'.$user->userlevel)); ?></td>
                        <td class="hidden-phone text-center"><strong><b>$ <?php echo e($user->credit_available >= '0' ? $user->credit_available : '0.00'); ?></b></strong></td>
                        <td class="hidden-phone text-center" dir="ltr"><?php echo e(date('m-d-Y', strtotime($user->created_at))); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </form>
        <?php echo e($users->links('dashboard.layouts.pagination')); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/usercompanys/index_users.blade.php ENDPATH**/ ?>