
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e($page_title); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <?php if($sub_page_title): ?>
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('comments')); ?>"><?php echo e(admin_lang('comments')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($sub_page_title); ?></li>
            <?php else: ?>
            <li class="breadcrumb-item active"><?php echo e($page_title); ?></li>
            <?php endif; ?>
        </ol>
    </div>
</div>
<div class="row mb-3">
    <div class="col-md-3 data-tables-filter">
        <form method="GET" action="" class="form-filter">
            <input type="search" name="s" class="form-control form-control-sm" value="<?php echo e(request()->get('s')); ?>" placeholder="<?php echo e(admin_lang('search')); ?>">
            <button type="submit" class="btn btn-sm btn-primary button-form-filter"><?php echo e(admin_lang('search')); ?></button>
        </form>
    </div>
    <div class="col-md-6"></div>
</div>
<?php if(session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button><?php echo session()->get('success'); ?></div>
<?php endif; ?>
<div class="card">
    <div class="card-body">
        <form class="form-horizontal" method="POST" action="<?php echo e(get_admin_url('CommentsActions')); ?>">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1"><?php echo e(admin_lang('bulk_actions')); ?></option>
                            <option value="unapprove"><?php echo e(admin_lang('unapproved')); ?></option>
                            <option value="approve"><?php echo e(admin_lang('approve')); ?></option>
                            <option value="delete"><?php echo e(admin_lang('delete')); ?></option>
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="<?php echo e(admin_lang('apply')); ?>" onclick="return confirm(\'<?php echo e(admin_lang('apply_confirm')); ?>\');">
                    </div>
                </div>
                <div class="col-md-4">

                </div>
                <div class="col-md-4 data-tables-filter">
                    
                </div>
            </div>
            <table id="jq-table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th class="hidden-phone"><?php echo e(admin_lang('author')); ?></th>
                        <th style="width: 60%"><?php echo e(admin_lang('comment')); ?></th>
                        <th style="width: 80px;" class="hidden-phone text-center"><?php echo e(admin_lang('date')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="td-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="<?php echo e($comment->cid); ?>" id="select-<?php echo e($comment->cid); ?>" />                                        
                                <label class="custom-control-label" for="select-<?php echo e($comment->cid); ?>"></label>
                            </div>
                            <?php if($comment->cstatus): ?><span class="sq-post-status disable"></span><?php else: ?><span class="sq-post-status enable"></span><?php endif; ?>
                            <div>#<?php echo e($comment->cid); ?></div>
                        </td>
                        <td>
                            <div class="avatar2"><img src="<?php if($comment->cuid): ?><?php echo e(get_user_avatar($comment->cuid)); ?><?php else: ?><?php echo e(get_user_avatar_username($comment->cuname)); ?><?php endif; ?>" alt="<?php if($comment->cuid): ?><?php echo e(get_username($comment->cuid)); ?><?php else: ?><?php echo e($comment->cuname); ?><?php endif; ?>"></div>
                            <ul class="tdul-list">
                                <li>
                                    <h6><?php if($comment->cuid): ?><a href="<?php echo e(get_admin_url('profile/'.$comment->cuid)); ?>"><?php echo e(get_username($comment->cuid)); ?></a><?php else: ?><?php echo e($comment->cuname); ?><?php endif; ?></h6>
                                    <h6 class="mb-1"><a href="mailto:<?php echo e($comment->cuemail); ?>"><?php echo e($comment->cuemail); ?></a></h6>
                                </li>
                                <li>
                                    <small>
                                        <a href="<?php echo e(get_admin_url('comments/ip/'.$comment->ip)); ?>"><?php echo e($comment->ip); ?></a> | 
                                        <a href="<?php echo e(get_admin_url('comments/platfrom/'.$comment->platformname)); ?>"><?php echo e($comment->platformname); ?></a> | 
                                        <a href="<?php echo e(get_admin_url('comments/browser/'.$comment->browserfamily)); ?>"><?php echo e($comment->browserfamily); ?></a>
                                    </small>
                                </li>
                            </ul>
                        </td>
                        <td>
                            <h6><?php echo get_post_title_from_comment($comment->cpid, $comment->ctype); ?></h6>
                            <p><?php echo nl2br($comment->ccontent); ?></p>
                            <div class="row-actions">
                                <a href="<?php echo e(get_admin_url('editcomment/'.$comment->cid)); ?>"><?php echo e(admin_lang('edit')); ?></a> | 
                                <?php if($comment->cstatus): ?>
                                <a href="<?php echo e(get_admin_url('disablecomment/'.$comment->cid)); ?>" class="red"><?php echo e(admin_lang('unapproved')); ?></a> |
                                <?php else: ?>
                                <a href="<?php echo e(get_admin_url('enablecomment/'.$comment->cid)); ?>" class="green"><?php echo e(admin_lang('approve')); ?></a> |
                                <?php endif; ?>
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="<?php echo e(get_admin_url('deletecomment/'.$comment->cid.'/'.csrf_token() )); ?>" data-body="<?php echo e(admin_lang('delete_confirm')); ?> # <?php echo e($comment->cid); ?>?" class="red"><?php echo e(admin_lang('delete')); ?></a>
                            </div>
                        </td>
                        <td class="hidden-phone text-center" dir="ltr"><?php echo e(time_format($comment->cmodified, 'date', 'd/m/Y')); ?><br /><?php echo e(time_format($comment->cmodified, 'time')); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </form>
        <?php echo e($comments->links('dashboard.layouts.pagination')); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\waqf_new\resources\views/dashboard/comments/index_comments.blade.php ENDPATH**/ ?>