
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e($page_title); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($page_title); ?></li>
        </ol>
    </div>
</div>
<?php if(session()->has('success')): ?>
    <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button><?php echo session()->get('success'); ?></div>
<?php endif; ?>
<div class="row">
    <div class="col-12">
        <div class="email-leftbar card">
            <div class="mail-list">
                <a href="<?php echo e(get_admin_url('messages/contactus')); ?>" <?php if($list_class == 'contactus'): ?> class="active" <?php endif; ?>><i class="bx bx-envelope mr-2"></i> <?php echo e(admin_lang('contactus')); ?> <?php echo get_messages_html('contactus'); ?></a>
            </div>
        </div>
        <div class="email-rightbar mb-3">
            <div class="card">
                <form class="form-horizontal" method="POST" action="<?php echo e(get_admin_url('MessagesActions')); ?>">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="type" value="<?php echo e($post_type); ?>">
                    <input type="hidden" name="query" value="action">
                    <div class="btn-toolbar p-3" role="toolbar">
                        <div class="actionselect ml-3 mr-3">
                            <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                                <option value="-1"><?php echo e(admin_lang('bulk_actions')); ?></option>
                                <option value="markread"><?php echo e(admin_lang('mark_read')); ?></option>
                                <option value="markunread"><?php echo e(admin_lang('mark_unread')); ?></option>
                                <option value="delete"><?php echo e(admin_lang('delete')); ?></option>
                            </select>
                            <input type="submit" class="btn btn-sm btn-primary" value="<?php echo e(admin_lang('apply')); ?>" onclick="return confirm(\'<?php echo e(admin_lang('apply_confirm')); ?>\');">
                        </div>
                    </div>
                    <ul class="message-list">
                        <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li <?php if($post->post_status): ?> class="active" <?php endif; ?>>
                            <div class="col-mail col-mail-1">
                                <div class="checkbox-wrapper-mail">
                                    <input type="checkbox" id="select-<?php echo e($post->id); ?>" name="mark[]" value="<?php echo e($post->id); ?>" />
                                    <label for="select-<?php echo e($post->id); ?>" class="toggle"></label>
                                </div>
                                <a class="title" href="<?php echo e(get_admin_url('message/show-'.$post->id)); ?>">
                                    <span class="teaser"><?php if($post->post_status): ?><?php echo e($post->post_title); ?><?php else: ?> <strong><?php echo e($post->post_title); ?></strong> <?php endif; ?></span>
                                </a>
                            </div>
                            <div class="col-mail col-mail-2">
                                <a href="<?php echo e(get_admin_url('message/show-'.$post->id)); ?>" class="subject">
                                    <span class="teaser"><?php echo e(get_post_meta_inarray($post->post_excerpts, 'username')); ?></span>
                                </a>
                                <div class="date"><?php echo e(time_format($post->post_modified, 'date', 'd/m/Y')); ?></div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </form>
            </div>
            <?php echo e($posts->links('dashboard.layouts.pagination')); ?>

            <br />
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_files'); ?>
<script>
$(function() {
    $(".th-checkbox input:checkbox").on("click", function() {
        var that = this;
        $(".message-list").find("li input:checkbox").each(function() {
            this.checked = that.checked;
            $(this).closest("li").toggleClass("selected");
        });
    });
});
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\waqf_new\resources\views/dashboard/messages/index_messages.blade.php ENDPATH**/ ?>