
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e(admin_lang('profile')); ?> :: <?php echo e($data['username']); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <li class="breadcrumb-item"><a href="#"><?php echo e(admin_lang('users')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($data['username']); ?></li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-xl-4">
        <div class="card overflow-hidden">
            <div class="bg-soft-primary bg-soft-usercover" style="background-image: url(<?php echo e(get_user_cover($data['userid'])); ?>)">
                <div class="row">
                    <div class="col-12">
                        <div class="text-primary p-3">
                            <h5 class="text-primary"><?php echo e($data['username']); ?></h5>
                            <p><?php echo e($data['email']); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body pt-0">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="avatar-md profile-user-wid mb-4">
                            <img src="<?php echo e(get_user_avatar($data['userid'])); ?>" alt="" class="img-thumbnail rounded-circle">
                        </div>
                        <h5 class="font-size-15 text-truncate"><?php echo e($data['username']); ?></h5>
                        <p class="text-muted mb-0 text-truncate">
                            <?php if($data['userlevel'] == 'admin'): ?>
                            <span class="badge badge-pill bg-danger"><?php echo e(admin_lang('userlevel_'.$data['userlevel'])); ?></span>
                            <?php else: ?>
                            <span class="badge badge-pill bg-info"><?php echo e(admin_lang('userlevel_'.$data['userlevel'])); ?></span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="account_info">
                    <div class="account_info-group"><label><?php echo e(admin_lang('username')); ?>:</label> <?php echo e($data['username']); ?></div>
                    <div class="account_info-group"><label><?php echo e(admin_lang('email')); ?>:</label> <a href="mailto:<?php echo e($data['email']); ?>"><?php echo e($data['email']); ?></a></div>
                    <div class="account_info-group"><label><?php echo e(admin_lang('created')); ?>:</label> <?php echo e(date('m/d/Y H:i:s', strtotime($data['user']->created_at))); ?></div>
                    <div class="account_info-group"><label><?php echo e(admin_lang('updated')); ?>:</label> <?php echo e(date('m/d/Y H:i:s', strtotime($data['user']->updated_at))); ?></div>
                    <div class="account_info-group"><label><?php echo e(admin_lang('last_seen')); ?>:</label> <?php if($data['signintime']): ?><?php echo e(date('m/d/Y H:i:s', $data['signintime'])); ?><?php else: ?><?php echo e(admin_lang('none')); ?><?php endif; ?></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php if(session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button><?php echo session()->get('success'); ?></div>
<?php endif; ?>
<?php if($errors->any()): ?>
<div class="alert alert-danger">
    <ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
</div>
<?php endif; ?>
<?php app('eventy')->action('admin_user_profile_before_container', $data['user']); ?>
<div class="tacf-box-container">
    <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="profile_user" data-cookie-tab="tab-details">
        <a href="#" class="active" data-tab=".tab-details"><i class="bx bx-file"></i> <?php echo e(admin_lang('details')); ?></a>
        <a href="#" class="" data-tab=".tab-edit"><i class="bx bx-pencil"></i> <?php echo e(admin_lang('edit')); ?></a>
        <?php app('eventy')->action('admin_user_profile_tabs', $data['user']); ?>
    </div>
    <div class="tacf-tabs-content">
        <div class="tacf-tab-content tab-details p-0 active">
            <ul class="list-group list-group-flush">
                <li class="list-group-item"><strong><?php echo e(admin_lang('id')); ?>:</strong> <?php echo e($data['user']->id); ?></li>
                <?php if(Auth::user()->userlevel == 'supervisor'): ?>
                <li class="list-group-item"><strong>Contract ID:</strong> <?php echo e($data['user']->contract_id); ?></li>
                <li class="list-group-item"><strong>AR ID:</strong> <?php echo e($data['user']->ar_id); ?></li>
                <li class="list-group-item"><strong>Two Factor Auth:</strong> <?php echo e(Auth::user()->two_factor == 1 ? 'YES': 'NO'); ?></li>
                <?php elseif(Auth::user()->userlevel == 'user'): ?>
                <li class="list-group-item"><strong>Two Factor Auth:</strong> <?php echo e(Auth::user()->two_factor == 1 ? 'YES': 'NO'); ?></li>
                <?php endif; ?>
                <li class="list-group-item"><strong><?php echo e(admin_lang('username')); ?>:</strong> <?php echo e($data['user']->username); ?></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('email')); ?>:</strong> <a href="mailto:<?php echo e($data['user']->email); ?>"><?php echo e($data['user']->email); ?></a></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('role')); ?>:</strong> <?php if($data['user']->userlevel == 'admin'): ?><span class="badge badge-pill bg-danger"><?php echo e(admin_lang('userlevel_'.$data['user']->userlevel)); ?></span><?php else: ?><span class="badge badge-pill bg-info"><?php echo e(admin_lang('userlevel_'.$data['user']->userlevel)); ?></span><?php endif; ?></li>
                <?php app('eventy')->action('admin_user_profile_details', $data['user']); ?>
                <li class="list-group-item"><strong><?php echo e(admin_lang('created')); ?>:</strong> <?php echo e($data['user']->created_at); ?></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('updated')); ?>:</strong> <?php echo e($data['user']->updated_at); ?></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('last_seen')); ?>:</strong> <?php if($data['signintime']): ?><?php echo e(date('d/m/Y H:i:s', $data['signintime'])); ?><?php else: ?><?php echo e(admin_lang('none')); ?><?php endif; ?></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('ip')); ?>:</strong> <a href="<?php echo e(get_admin_url('users/platform/'.$data['details']['ip'])); ?>"><?php echo e($data['details']['ip']); ?></a></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('useragent')); ?>:</strong> <?php echo e($data['details']['useragent']); ?></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('platformname')); ?>:</strong> <a href="<?php echo e(get_admin_url('users/platform/'.$data['details']['platformname'])); ?>"><?php echo e($data['details']['platformname']); ?></a></li>
                <li class="list-group-item"><strong><?php echo e(admin_lang('browserfamily')); ?>:</strong> <a href="<?php echo e(get_admin_url('users/browser/'.$data['details']['browserfamily'])); ?>"><?php echo e($data['details']['browserfamily']); ?></a></li>
            </ul>
        </div>
        <?php if(is_permission('comments')): ?>
        <div class="tacf-tab-content tab-comments pl-3 pr-3 pb-3 pt-0">
            <?php echo $__env->make('dashboard.comments.index_loop_comments', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php endif; ?>
        <div class="tacf-tab-content tab-edit">
            <?php echo $__env->make('dashboard.users.user_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php app('eventy')->action('admin_user_profile_tabs_content', $data['user']); ?>
    </div>
</div>
<?php app('eventy')->action('admin_user_profile_after_container', $data['user']); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style_files'); ?>
<link href="<?php echo e(asset('libs/tacf/tacf.min.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('libs/multiselect/css/multiselect.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_files'); ?>
<script src="<?php echo e(asset('libs/tacf/tacf.min.js')); ?>"></script>
<script src="<?php echo e(asset('libs/multiselect/js/jquery.multiselect.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/js/custom-file-input.min.js')); ?>"></script>
<script type="text/javascript">
bsCustomFileInput.init();
$(function() {$('#permission').multiSelect();});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/users/profile_user.blade.php ENDPATH**/ ?>