<?php
    $propertys = config('globalarray.PROPERTYTYPE');
    $pincode = config('globalarray.PINCODE');
?>
<style>
    #country-list {
        float: left;
        list-style: none;
        margin-top: -3px;
        padding: 0;
        width: 190px;
        position: absolute;
    }

    #country-list li {
        padding: 10px;
        background: #f0f0f0;
        border-bottom: #bbb9b9 1px solid;
    }

    #country-list li:hover {
        background: #ece3d2;
        cursor: pointer;
    }

    #search-box {
        padding: 10px;
    }


    .control-label:after {
        content: "*";
        color: red;
    }
</style>
<?php if($mode == 'quickAdd'): ?>
    <form method="POST" action="<?php echo e(get_admin_url('quickDriverAdd')); ?>" class="form-horizontal"
        enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
        <div class="row">

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">First Name</label><br>
                    <input type="text" name="FIRST_NAME" id="FIRST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('FIRST_NAME')); ?>">
                    <?php if($errors->has('FIRST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('FIRST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Last Name</label><br>
                    <input type="text" name="LAST_NAME" id="LAST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('LAST_NAME')); ?>">
                    <?php if($errors->has('LAST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('LAST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

        </div>

        <?php if(session()->has('error')): ?>
            <span class="text-danger"><?php echo e(session()->get('error')); ?></span>
            <?php
                session()->forget('error');
            ?>
        <?php endif; ?>

        <div class="form-group mt-2">
            <button type="submit" class="btn btn-primary"><span></span>Add</button>
            <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger"><span></span>Cancel</a>
        </div>


    </form>
<?php elseif($mode == 'admin_driver_add'): ?>
    <form method="POST" action="<?php echo e(get_admin_url('admin_driver_add')); ?>" class="form-horizontal"
        enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
        <div class="row">

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Company</label><br>
                    <select name="MEM_ID" id="MEM_ID"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm"
                        required>
                        <option value="">Select Company</option>
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?>

                                <?php echo e($company->contract_id ? "({$company->contract_id})" : ''); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('MEM_ID')): ?>
                        <span class="text-danger"><?php echo e($errors->first('MEM_ID')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">User Name</label><br>
                    <input type="text" name="USERNAME" id="USERNAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('USERNAME')); ?>">
                    <?php if($errors->has('USERNAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('USERNAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Password</label><br>
                    <input type="text" name="PASSWORD" id="PASSWORD" cLass="form-control col-md-6"
                        value="<?php echo e(old('PASSWORD')); ?>">
                    <?php if($errors->has('PASSWORD')): ?>
                        <span class="text-danger"><?php echo e($errors->first('PASSWORD')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Login Pin</label><br>
                    <input type="text" name="pin_number" id="pin_number" cLass="form-control col-md-6"
                        value="<?php echo e(old('pin_number')); ?>">
                    <?php if($errors->has('pin_number')): ?>
                        <span class="text-danger"><?php echo e($errors->first('pin_number')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">First Name</label><br>
                    <input type="text" name="FIRST_NAME" id="FIRST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('FIRST_NAME')); ?>">
                    <?php if($errors->has('FIRST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('FIRST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Last Name</label><br>
                    <input type="text" name="LAST_NAME" id="LAST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('LAST_NAME')); ?>">
                    <?php if($errors->has('LAST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('LAST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Address</label><br>
                    <input type="text" name="ADDRESS" id="ADDRESS" cLass="form-control col-md-6"
                        value="<?php echo e(old('ADDRESS')); ?>">
                    <?php if($errors->has('ADDRESS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('ADDRESS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">City</label><br>
                    <input type="text" name="CITY" id="CITY" cLass="form-control col-md-6"
                        value="<?php echo e(old('CITY')); ?>">
                    <?php if($errors->has('CITY')): ?>
                        <span class="text-danger"><?php echo e($errors->first('CITY')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">State</label><br>
                    <?php $state = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'WA', 'WV', 'WI', 'WY']; ?>
                    <select name="STATE" id="STATE"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                        <option value="">Select State</option>
                        <?php $__currentLoopData = $state; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item); ?>"><?php echo e($item); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('STATE')): ?>
                        <span class="text-danger"><?php echo e($errors->first('STATE')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Postal Code</label><br>
                    <input type="text" name="POSTAL" id="POSTAL" cLass="form-control col-md-6"
                        value="<?php echo e(old('POSTAL')); ?>">
                    <?php if($errors->has('POSTAL')): ?>
                        <span class="text-danger"><?php echo e($errors->first('POSTAL')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Country</label><br>
                    <input type="text" name="COUNTRY" id="COUNTRY" cLass="form-control col-md-6"
                        value="<?php echo e(old('COUNTRY', 'USA')); ?>">
                    <?php if($errors->has('COUNTRY')): ?>
                        <span class="text-danger"><?php echo e($errors->first('COUNTRY')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Dob</label><br>
                    <input type="date" name="DOB" id="DOB" cLass="form-control col-md-6"
                        value="<?php echo e(old('DOB')); ?>">
                    <?php if($errors->has('DOB')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DOB')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Social Security No.</label><br>
                    <input type="text" name="SSN_NUM" id="SSN_NUM" cLass="form-control col-md-6"
                        value="<?php echo e(old('SSN_NUM')); ?>">
                    <?php if($errors->has('SSN_NUM')): ?>
                        <span class="text-danger"><?php echo e($errors->first('SSN_NUM')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Email</label><br>
                    <input type="email" name="DRIVER_EMAIL" id="DRIVER_EMAIL" cLass="form-control col-md-6"
                        value="<?php echo e(old('DRIVER_EMAIL')); ?>">
                    <?php if($errors->has('DRIVER_EMAIL')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DRIVER_EMAIL')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Phone</label><br>
                    <input type="text" name="DRIVER_PHONE" id="DRIVER_PHONE" class="form-control col-md-6"
                        value="<?php echo e(old('DRIVER_PHONE')); ?>">
                    <?php if($errors->has('DRIVER_PHONE')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DRIVER_PHONE')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Status</label><br>
                    <input type="radio" value="1" name="STATUS" checked="" id="active"> <label
                        for="active">Active</label>
                    <input type="radio" value="0" name="STATUS" id="inactive"> <label
                        for="inactive">InActive</label>
                    <?php if($errors->has('STATUS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('STATUS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Sub Status</label><br>

                    <select name="SUB_STATUS" id="SUB_STATUS"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                        <option value="New Card Order">New Card Order</option>
                    </select>
                    <?php if($errors->has('SUB_STATUS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('SUB_STATUS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>


        </div>

        <div class="form-group mt-2">
            <button type="submit" class="btn btn-primary"><span></span>Add</button>
            <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger"><span></span>Cancel</a>
        </div>


    </form>
<?php elseif($mode == 'admin_quick_driver_add'): ?>
    <form method="POST" action="<?php echo e(get_admin_url('adminQuickDriverAdd')); ?>" class="form-horizontal"
        enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Company</label><br>
                    <select name="MEM_ID" id="MEM_ID"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm"
                        required>
                        <option value="">Select Company</option>
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?>

                                <?php echo e($company->contract_id ? "({$company->contract_id})" : ''); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('MEM_ID')): ?>
                        <span class="text-danger"><?php echo e($errors->first('MEM_ID')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">First Name</label><br>
                    <input type="text" name="FIRST_NAME" id="FIRST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('FIRST_NAME')); ?>">
                    <?php if($errors->has('FIRST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('FIRST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Last Name</label><br>
                    <input type="text" name="LAST_NAME" id="LAST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('LAST_NAME')); ?>">
                    <?php if($errors->has('LAST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('LAST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

        </div>

        <?php if(session()->has('error')): ?>
            <span class="text-danger"><?php echo e(session()->get('error')); ?></span>
            <?php
                session()->forget('error');
            ?>
        <?php endif; ?>

        <div class="form-group mt-2">
            <button type="submit" class="btn btn-primary"><span></span>Add</button>
            <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger"><span></span>Cancel</a>
        </div>


    </form>
<?php else: ?>
    <form method="POST" action="<?php echo e(get_admin_url('driverSendForm')); ?>" class="form-horizontal"
        enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
        <div class="row">

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">User Name</label><br>
                    <input type="text" name="USERNAME" id="USERNAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('USERNAME')); ?>">
                    <?php if($errors->has('USERNAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('USERNAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Password</label><br>
                    <input type="text" name="PASSWORD" id="PASSWORD" cLass="form-control col-md-6"
                        value="<?php echo e(old('PASSWORD')); ?>">
                    <?php if($errors->has('PASSWORD')): ?>
                        <span class="text-danger"><?php echo e($errors->first('PASSWORD')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Login Pin</label><br>
                    <input type="text" name="pin_number" id="pin_number" cLass="form-control col-md-6"
                        value="<?php echo e(old('pin_number')); ?>">
                    <?php if($errors->has('pin_number')): ?>
                        <span class="text-danger"><?php echo e($errors->first('pin_number')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">First Name</label><br>
                    <input type="text" name="FIRST_NAME" id="FIRST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('FIRST_NAME')); ?>">
                    <?php if($errors->has('FIRST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('FIRST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Last Name</label><br>
                    <input type="text" name="LAST_NAME" id="LAST_NAME" cLass="form-control col-md-6"
                        value="<?php echo e(old('LAST_NAME')); ?>">
                    <?php if($errors->has('LAST_NAME')): ?>
                        <span class="text-danger"><?php echo e($errors->first('LAST_NAME')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Address</label><br>
                    <input type="text" name="ADDRESS" id="ADDRESS" cLass="form-control col-md-6"
                        value="<?php echo e(old('ADDRESS')); ?>">
                    <?php if($errors->has('ADDRESS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('ADDRESS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">City</label><br>
                    <input type="text" name="CITY" id="CITY" cLass="form-control col-md-6"
                        value="<?php echo e(old('CITY')); ?>">
                    <?php if($errors->has('CITY')): ?>
                        <span class="text-danger"><?php echo e($errors->first('CITY')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">State</label><br>
                    <?php $state = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'WA', 'WV', 'WI', 'WY']; ?>
                    <select name="STATE" id="STATE"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                        <option value="">Select State</option>
                        <?php $__currentLoopData = $state; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item); ?>"><?php echo e($item); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('STATE')): ?>
                        <span class="text-danger"><?php echo e($errors->first('STATE')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Postal Code</label><br>
                    <input type="text" name="POSTAL" id="POSTAL" cLass="form-control col-md-6"
                        value="<?php echo e(old('POSTAL')); ?>">
                    <?php if($errors->has('POSTAL')): ?>
                        <span class="text-danger"><?php echo e($errors->first('POSTAL')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Country</label><br>
                    <input type="text" name="COUNTRY" id="COUNTRY" cLass="form-control col-md-6"
                        value="<?php echo e(old('COUNTRY', 'USA')); ?>">
                    <?php if($errors->has('COUNTRY')): ?>
                        <span class="text-danger"><?php echo e($errors->first('COUNTRY')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Dob</label><br>
                    <input type="date" name="DOB" id="DOB" cLass="form-control col-md-6"
                        value="<?php echo e(old('DOB')); ?>">
                    <?php if($errors->has('DOB')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DOB')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Social Security No.</label><br>
                    <input type="text" name="SSN_NUM" id="SSN_NUM" cLass="form-control col-md-6"
                        value="<?php echo e(old('SSN_NUM')); ?>">
                    <?php if($errors->has('SSN_NUM')): ?>
                        <span class="text-danger"><?php echo e($errors->first('SSN_NUM')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Email</label><br>
                    <input type="email" name="DRIVER_EMAIL" id="DRIVER_EMAIL" cLass="form-control col-md-6"
                        value="<?php echo e(old('DRIVER_EMAIL')); ?>">
                    <?php if($errors->has('DRIVER_EMAIL')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DRIVER_EMAIL')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Phone</label><br>
                    <input type="text" name="DRIVER_PHONE" id="DRIVER_PHONE" cLass="form-control col-md-6"
                        value="<?php echo e(old('DRIVER_PHONE')); ?>">
                    <?php if($errors->has('DRIVER_PHONE')): ?>
                        <span class="text-danger"><?php echo e($errors->first('DRIVER_PHONE')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Status</label><br>
                    <input type="radio" value="1" name="STATUS" checked="" id="active"> <label
                        for="active">Active</label>
                    <input type="radio" value="0" name="STATUS" id="inactive"> <label
                        for="inactive">InActive</label>
                    <?php if($errors->has('STATUS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('STATUS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Sub Status</label><br>

                    <select name="SUB_STATUS" id="SUB_STATUS"
                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                        <option value="New Card Order">New Card Order</option>
                    </select>
                    <?php if($errors->has('SUB_STATUS')): ?>
                        <span class="text-danger"><?php echo e($errors->first('SUB_STATUS')); ?></span>
                    <?php endif; ?>
                </div>
            </div>


        </div>

        <div class="form-group mt-2">
            <button type="submit" class="btn btn-primary"><span></span>Add</button>
            <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger"><span></span>Cancel</a>
        </div>


    </form>
<?php endif; ?>

<script src="http://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.2/js/toastr.min.js"></script>
<link rel="stylesheet" href="http://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<script>
    $(document).ready(function() {



        $("#property_country_id").on("change", function() {
            var Id = $(this).val();
            url = "<?php echo e(get_admin_url('ajax_state')); ?>";
            params = {
                id: Id
            };
            getlistajax(url, params, 'property_state_id');
        });

        $("#property_state_id").on("change", function() {
            var Id = $(this).val();
            url = "<?php echo e(get_admin_url('ajax_city')); ?>";
            params = {
                id: Id
            };
            getlistajax(url, params, 'property_city_id');
        });

        $("#property_city_id").on("change", function() {
            var Id = $(this).val();
            url = "<?php echo e(get_admin_url('ajax_area')); ?>";
            params = {
                id: Id
            };
            getlistajax(url, params, 'property_area_id');
        });


        // autocompleted selected for pin_number no

        $("#search-box").keyup(function() {

            $.ajax({
                type: "GET",
                url: "<?php echo e(get_admin_url('autoselected')); ?>",
                data: 'keyword=' + $(this).val(),
                beforeSend: function() {
                    $("#search-box").css("background",
                        "#FFF url(LoaderIcon.gif) no-repeat 165px");
                },
                success: function(data) {
                    $("#suggesstion-box").show();
                    $("#suggesstion-box").html(data);
                    $("#search-box").css("background", "#FFF");
                }
            });
        });


    });

    function selectCountry(val) {
        $("#search-box").val(val);
        $("#suggesstion-box").hide();
    }
</script>
<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD5BQa0hFcyKzBa_dA2cbKt3QvdiWhxOvY&libraries&callback=initAutocomplete&libraries=places&v=weekly"
    defer></script>


<script>
    // This sample uses the Places Autocomplete widget to:
    // 1. Help the user select a place
    // 2. Retrieve the address components associated with that place
    // 3. Populate the form fields with those address components.
    // This sample requires the Places library, Maps JavaScript API.
    // Include the libraries=places parameter when you first load the API.
    // For example: <script
    // src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">
    let autocomplete;
    let address1Field;
    let address2Field;
    let postalField;

    function initAutocomplete() {
        address1Field = document.querySelector("#ADDRESS");
        postalField = document.querySelector("#POSTAL");
        // Create the autocomplete object, restricting the search predictions to
        // addresses in the US and Canada.
        autocomplete = new google.maps.places.Autocomplete(address1Field, {
            componentRestrictions: {
                country: ["us"]
            },
            fields: ["address_components", "geometry"],
            types: ["address"],
        });
        address1Field.focus();
        // When the user selects an address from the drop-down, populate the
        // address fields in the form.
        autocomplete.addListener("place_changed", fillInAddress);
    }

    function fillInAddress() {
        // Get the place details from the autocomplete object.
        const place = autocomplete.getPlace();
        let address1 = "";
        let postcode = "";

        // Get each component of the address from the place details,
        // and then fill-in the corresponding field on the form.
        // place.address_components are google.maps.GeocoderAddressComponent objects
        // which are documented at http://goo.gle/3l5i5Mr
        for (const component of place.address_components) {
            // @ts-ignore remove once typings fixed
            const componentType = component.types[0];

            switch (componentType) {
                case "street_number": {
                    address1 = `${component.long_name} ${address1}`;
                    break;
                }

                case "route": {
                    address1 += component.short_name;
                    break;
                }

                case "postal_code": {
                    postcode = `${component.long_name}${postcode}`;
                    break;
                }

                case "postal_code_suffix": {
                    postcode = `${postcode}-${component.long_name}`;
                    break;
                }
                case "locality":
                    document.querySelector("#CITY").value = component.long_name;
                    break;
                case "administrative_area_level_1": {
                    document.querySelector("#STATE").value = component.short_name;
                    break;
                }
                case "POSTAL":
                    document.querySelector("#POSTAL").value = component.postcode;
                    break;
            }
        }

        address1Field.value = address1;
        postalField.value = postcode;
        // After filling the form with address components from the Autocomplete
        // prediction, set cursor focus on the second address line to encourage
        // entry of subpremise information such as apartment, unit, or floor number.
    }

    window.initAutocomplete = initAutocomplete;
</script>
<script>
    $(document).ready(function () {
        $('#DRIVER_PHONE').inputmask('(999)-999-9999');
        $('#SSN_NUM').inputmask('999-99-9999');
    });
</script>
<?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/driver/driver_form.blade.php ENDPATH**/ ?>