<?php
/**
 * Extension Name: Frequently Asked Questions
 * Extension URI: http://themearabia.net/extension/faqs
 * license: free
 * Version: 3.0
 * Requires: 5.0
 * Description: Frequently Asked Questions
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

if (!class_exists('extensions_faqs')) {

    class extensions_faqs
    {
        protected $veiwdir      = 'posts.faqs';
        protected $ex_id        = 'faqs';
        protected $ex_type      = 'faqs';
        protected $option_name  = 'options_faqs';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'faqs';
        protected $ex_icon      = 'bx bx-help-circle';
        protected $ex_order     = '50';
        protected $options      = [];

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options = maybe_unserialize(get_option($this->option_name));
            if(is_admin())
            {
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_menu', [$this, 'admin_options_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_content', [$this, 'admin_options_content'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_extension_url', [$this, 'admin_extension_url'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_faqs_posts', [$this, 'widgets_options_faqs_posts_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_faqs_posts', [$this, 'widgets_options_faqs_posts'], $this->ex_order, 1);
            }
            else
            {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_faqs_posts', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        /**
         * filter_data_home($arg)
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('faqs'))
            {
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['column']          = '1column';
                $default_options['cate']            = [];
                $default_options['catelink']        = 'off';
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['faqs']   = $this->get_query($options['cate'])->limit($options['limit'])->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * get_query()
         */
        public function get_query($terms = [])
        {
            $query = DB::table(POSTS_TABLE)
            ->where(['post_type' => $this->ex_type, 'post_status' => '1']);
            if(is_array($terms) and count($terms)){
                $query->whereIn('term_id', $terms);
            }
            $query->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC');
            
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'faqs_posts' => [
                    'title' => extension_lang($this->ex_lang, 'faqs'), 
                    'option' => 'faqs_posts'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'faqs'));
        }

        /**
         * widgets_options_faqs_posts()
         */
        public function widgets_options_faqs_posts($data)
        {
            $categories = [];
            foreach(get_categories_type($this->ex_type) as $cate)
            {
                if(get_post_count_status($this->ex_type, $cate->id))
                {
                    $categories[] = [
                        'name'  => $cate->name,
                        'id'    => $data['option_name'].'['.$data['key'].'][cate]['.$cate->id.']',
                        'value' => $cate->id,
                    ];
                }
            }
            $column     = (isset($data['widget']['column']))? $data['widget']['column'] : '1column';
            $catelink   = (isset($data['widget']['catelink']))? $data['widget']['catelink'] : '0';
            $cate       = (isset($data['widget']['cate']))? $data['widget']['cate'] : [];
            $limit      = (isset($data['widget']['limit']))? $data['widget']['limit'] : 4;
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                '1column' => '1 '.admin_lang('column'),
                '2column' => '2 '.admin_lang('column'),
            ]];
            $option_catelink = ['id' => $data['option_name'].'['.$data['key'].'][catelink]', 'box_class' => 'form-group', 'name' => extension_lang($this->ex_lang, 'cate_link'), 'value' => $catelink, 'options' => [
                'off' => admin_lang('off'),
                'name' => extension_lang($this->ex_lang, 'cate_name'),
                'nameurl' => extension_lang($this->ex_lang, 'cate_name_url'),
            ]];
            $options_cate = ['id' => $data['option_name'].'['.$data['key'].'][cate]', 'box_class' => 'form-group', 'name' => admin_lang('categories'), 'options' => $categories, 'value' => $cate];
            $option_limit = ['id' => $data['option_name'].'['.$data['key'].'][limit]', 'box_class' => 'form-group', 'name' => admin_lang('post_per_page'), 'value' => $limit, 'min' => '1', 'max' => '32', 'step' => '1'];
            
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_radio_input($option_catelink, false).'
                </div>
                <div class="col-md-6">
                    '.field_checkbox_array_input($options_cate, false).'
                </div>
                <div class="col-md-6">
                    '.field_slider_number_input($option_limit, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_faqs_posts_echo($data)
         */
        public function widgets_options_faqs_posts_echo($data)
        {
            echo $this->widgets_options_faqs_posts($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'faqs_posts'    => 'widgets.widget_faqs'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_extension_url
         */
        public function admin_extension_url()
        {
            $url    = url('faqs');
            $title  = extension_lang($this->ex_lang, 'faqs');
            $icon   = 'pe-7s-help1';
            $key    = 'faqs';
            echo '
            <li>
                <div class="form-check">
                    <input class="form-check-input menu-item-checkbox" type="checkbox" id="menu-item-extension-'.$key.'" name="menu-item" data-url="'.$url.'" data-title="'.$title.'" data-icon="'.$icon.'">
                    <label class="form-check-label" for="menu-item-extension-'.$key.'">'.$title.'</label>
                </div>
            </li>
            ';
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => 'faqs']];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'faqs'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'faqs'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'faqs'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'faqs'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'faqs'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('categories'), 'url' => get_admin_url('categories/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data = ['id' => $this->ex_id, 'icon' => $this->ex_icon, 'title' => extension_lang($this->ex_lang, 'faqs')];
            echo get_admin_view('hooks.admin_options_menu_tab', $data)->render();
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {
            $style          = (isset($this->options['style']))? $this->options['style'] : 'full';
            $catelink       = (isset($this->options['catelink']))? $this->options['catelink'] : '';
            $column         = (isset($this->options['column']))? $this->options['column'] : '';
            $post_per_page  = (isset($this->options['post_per_page']))? $this->options['post_per_page'] : 3;
            $data['options'][$this->ex_id]['section_general'] = [
                'title'     => admin_lang('general'),
                'options'   => [
                    ['name' => admin_lang('style'), 'id' => $this->option_name.'[style]', 'type' => 'radio', 'value' => $style, 'options' => [
                        'left_sidebar'  => ['label' => admin_lang('left_sidebar'), 'img' => asset('dashboard/images/options/left_sidebar.png')],
                        'right_sidebar' => ['label' => admin_lang('right_sidebar'), 'img' => asset('dashboard/images/options/right_sidebar.png')],
                        'fixed'         => ['label' => admin_lang('centered'), 'img' => asset('dashboard/images/options/fixed.png')],
                        'full'          => ['label' => admin_lang('full_width'), 'img' => asset('dashboard/images/options/full.png')],
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[catelink]', 'name' => extension_lang($this->ex_lang, 'cate_link'), 'value' => $catelink, 'options' => [
                        'off' => admin_lang('off'),
                        'name' => extension_lang($this->ex_lang, 'cate_name'),
                        'nameurl' => extension_lang($this->ex_lang, 'cate_name_url'),
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column]', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                        '1column' => '1 '.admin_lang('column'),
                        '2column' => '2 '.admin_lang('column'),
                    ]],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[post_per_page]', 'name' => admin_lang('post_per_page'), 'value' => $post_per_page, 'min' => '1', 'max' => '40', 'step' => '1'],
                ]
            ];
            echo get_admin_view('hooks.admin_options_menu_content', $data)->render();
        }

    }

    new extensions_faqs();
}
