<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\Auth;
use Closure;
use Illuminate\Http\Request;


class AdminMiddleware
{
    

    public function __construct()
    {
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    public function handle(Request $request, Closure $next)
    {
        $roles=['admin', 'supervisor', 'new'];
        if (Auth::check() && in_array(Auth::user()->userlevel, $roles)) {
                return $next($request);
        } else {
            return redirect(get_admin_url('login'));
        }
    }

}
