<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use App\Models\CertificatePrintLog;
class Deceased extends Model
{ 
    use HasFactory, Notifiable;
    protected $table="deceased_master";
     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    

    protected $fillable = [
        'graveyard_id',
        'entry_no',
        'graveyard_book_no',
        'graveyard_receipt_no',
        'deceased_identity',
        'graveyard_receipt',
        'deceased_name',
        'deceased_surname',
        'deceased_father_husband_name',
        'deceased_name_gj',
        'deceased_surname_gj',
        'deceased_father_husband_name_gj',
        'gender',
        'birth_date',
        'age',
        'photo',
        'identity_proof',
        'identity_proof_file',
        'place_death',
        'reason_death',
        'hospital_letter_file',
        'is_postmortem',
        'postmortem_fileno',
        'postmortem_date',
        'postmortem_file',
        'death_date',
        'digging_charge',
        'graveyard_charge',
        'death_certificate_charge'

    ];


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    public function graveyard()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(Graveyard::class ,'id', 'graveyard_id');
    }

    public function deceasedaddress()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(DeceasedAddress::class ,'deceased_id', 'id');
    }

    public function deceasedinformer()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(DeceasedInformer::class ,'deceased_id', 'id');
    }
    public function print_info()
    {
        return $this->hasMany(CertificatePrintLog::class ,'deceased_id', 'id');
    }
    public function deceasedCorrection()
    {
        return $this->hasMany(DeceasedCorrection::class ,'deceased_id', 'id');
    }

      
}
