<aside class="col-lg-3 col-md-4 col-sm-12 sidebar @if(get_theme_option('sticky_sidebar')) sticky-sidebar @endif">
    <div class="theiaStickySidebar">
        @action('sidebar_before', $post_type)
        @if($books_widget_search)
        <div class="widget widget-search-input">
            <div class="widget-title"><i class="pe-7s-search"></i> {{lang('search')}}</div>
            <form action="{{url('books')}}" method="get">
                <div class="box-input">
                    <input class="input" type="text" name="search" placeholder="{{$books_search_text}}" maxlength="50" value="{{safe_input(request()->get('search'))}}">
                </div>
            </form>
        </div>
        @endif
        @if($books_widget_categories)
        <div class="widget widget-list">
            <div class="widget-title">
                <i class="pe-7s-ticket"></i> {{lang('categories')}}
            </div>
            <ul>
                @foreach ($widget_categories as $item)
                <li class="cat-item @if($item->id == $the_term_id) active @endif"><a href="{{url('books/'.$item->slug)}}">{{$item->name}} <span class="count">{{$item->posts_count}}</span></a></li>
                @endforeach
            </ul>
        </div>
        @endif
        @if($books_widget_recent)
        <div class="widget widget-recent-post">
            <div class="widget-title"><i class="pe-7s-gleam"></i> {{lang('recent')}}</div>
            <ul>
                @foreach ($widget_recent as $item)
                <li class="book-grid-item">
                    <a href="{{url('book/'.$item->post_name)}}">
                        <img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="thumb fullh" alt="{{$item->post_title}}">
                    </a>
                    <div class="book-grid-meta">
                        <h5><a href="{{url('book/'.$item->post_name)}}">{{$item->post_title}}</a></h5>
                        <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{$item->author}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{$item->year}}</p>
                    </div>
                </li>
                @endforeach
            </ul>
        </div>
        @endif
        @if($books_widget_popular)
        <div class="widget widget-recent-post">
            <div class="widget-title"><i class="pe-7s-like"></i> {{lang('popular')}}</div>
            <ul>
                @foreach ($widget_popular as $item)
                <li class="book-grid-item">
                    <a href="{{url('book/'.$item->post_name)}}">
                        <img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="thumb fullh" alt="{{$item->post_title}}">
                    </a>
                    <div class="book-grid-meta">
                        <h5><a href="{{url('book/'.$item->post_name)}}">{{$item->post_title}}</a></h5>
                        <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{$item->author}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{$item->year}}</p>
                    </div>
                </li>
                @endforeach
            </ul>
        </div>
        @endif
        @if($books_widget_tags)
        <div class="widget widget-list">
            <div class="widget-title"><i class="pe-7s-ticket"></i> {{lang('tags')}}</div>
            <div class="tagcloud">
                @foreach ($widget_tags as $key => $count)
                <a href="{{url('books/tag/'.trim($key))}}">{{trim($key)}} ({{$count}})</a>
                @endforeach                
            </div>
        </div>
        @endif
        @action('sidebar_after', $post_type)
    </div>
</aside>