@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row">
        @if(is_extensions('team') and isset($teams))
        @foreach ($teams as $item)
        <div class="{{$column_style2}} col-12">
            <div class="box-team-style3">
                <div class="avatar">
                    <img src="{{get_attachment_url(get_post_meta('thumbnails', $item->id), 'full')}}" alt="{{$item->post_title}}" />
                    <div class="team-hover">
                        <div class="socials-ul">
                            <ul>
                                @if(get_post_meta('facebook', $item->id))<li class="facebook"><a href="{{get_post_meta('facebook', $item->id)}}"><i class="fab fa-facebook-f"></i></a></li>@endif
                                @if(get_post_meta('twitter', $item->id))<li class="twitter"><a href="{{get_post_meta('twitter', $item->id)}}"><i class="fab fa-twitter"></i></a></li>@endif
                                @if(get_post_meta('instagram', $item->id))<li class="instagram"><a href="{{get_post_meta('instagram', $item->id)}}"><i class="fab fa-instagram"></i></a></li>@endif
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="team-info">
                    <h3 class="team-name">{{$item->post_title}}</h3>
                    <span class="team-job">{{get_post_meta('job', $item->id)}}</span>
                </div>
            </div>
        </div>
        @endforeach
        @endif
    </div>
</div>
@endsection