<div class="padding_80 {{$options['bgclass']}}" {!!$options['image_style']!!}>
    <div class="container">
        @if($options['title'])
        <div class="main_title">
            <h2>{{$options['title']}}</h2>
            <p>{{$options['description']}}</p>
            <span class="divider"></span>
        </div>
        @endif
        
        @if(is_extensions('documentation') and isset($documentation_posts))
        <div class="row">
            @foreach ($documentation_posts as $item)
            <div class="{{$column}}">
                <div class="document-item">
                    <h5><a href="{{url('doc/'.$item->post_name)}}">{{$item->post_title}}</a></h5>
                    <div class="row">
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-user"></i> {{$item->author}}
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-ticket"></i> <a href="{{url('documentation/'.$item->term_slug)}}">{{$item->term_name}}</a>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-clock"></i> {{$item->released}}
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-anchor"></i> {{$item->version}}
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-notebook"></i> <a href="{{$item->url}}" target="_blank">{{extension_lang('documentation', 'online_document')}}</a>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-12">
                            <i class="pe-7s-cloud-download"></i> <a href="{{$item->download}}" target="_blank">{{extension_lang('documentation', 'download')}}</a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endif
        @if($options['more_button'])
        <div class="row">
            <div class="col-md-12">
                <div class="home-more">
                    <a href="{{url('documentation')}}">@if($options['more_icon'])<i class="{{$options['more_icon']}}"></i>@endif {{$options['more_txt']}}</a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>