<div class="padding_80 {{$options['bgclass']}}" {!!$options['image_style']!!}>
    <div class="container">
        @if($options['title'])
        <div class="main_title">
            <h2>{{$options['title']}}</h2>
            <p>{{$options['description']}}</p>
            <span class="divider"></span>
        </div>
        @endif
        @if($options['style'] == 'style1')
        <div class="row">
            @foreach ($kb_categories as $cate)
            <div class="{{$column}} col-12">
                <div class="topics-list">
                    <h5><a href="{{url('kbc/'.$cate->slug)}}">{{$cate->name}} <span class="badge">{{$cate->posts_count}}</span></a></h5>
                    <ul>
                        @foreach (get_posts(['cid' => $cate->id, 'type' => 'knowledgebase', 'limit' => $options['limit']]) as $item)
                        <li><a href="{{url('kb/'.$item->post_name)}}"><i class="pe-7s-note2"></i> {{$item->post_title}}</a></li>
                        @endforeach
                    </ul>
                    <a href="{{url('kbc/'.$cate->slug)}}" class="readmore">{{lang('read_more')}} <i class="fas fa-angle-right"></i></a>
                </div>
            </div>
            @endforeach
        </div>
        @elseif($options['style'] == 'style2')
        <div class="row feature-box-full">
            @foreach ($kb_categories as $cate)
            <div class="{{$column}} col-12">
                <div class="item-box">
                    <div class="icon"><img src="{{get_attachment_url($cate->image)}}" alt="{{$cate->name}}"></div>
                    <h3>{{$cate->name}}</h3>
                    <p>{{$cate->description}}</p>
                    <a href="{{url('kbc/'.$cate->slug)}}" class="button-more">{{lang('read_more')}}</a>
                </div>
            </div>
            @endforeach
        </div>
        @elseif($options['style'] == 'style3')
        <div class="row">
            @foreach ($kb_categories as $cate)
            <div class="{{$column}} col-12">
                <div class="feature-box">
                    <div class="icon"><img src="{{get_attachment_url($cate->image)}}" alt="{{$cate->name}}"></div>
                    <h3>{{$cate->name}}</h3>
                    <p>{{$cate->description}}</p>
                    <a href="{{url('kbc/'.$cate->slug)}}" class="button-more">{{lang('read_more')}}</a>
                </div>
            </div>
            @endforeach
        </div>
        @endif
        @if($options['more_button'])
        <div class="row">
            <div class="col-md-12">
                <div class="home-more">
                    <a href="@if($options['more_url']){{$options['more_url']}}@else{{url('kb')}}@endif">@if($options['more_icon'])<i class="{{$options['more_icon']}}"></i>@endif {{$options['more_txt']}}</a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>