<div class="padding_80 {{$options['bgclass']}}" {!!$options['image_style']!!}>
    <div class="container">
        @if($options['title'])
        <div class="main_title">
            <h2>{{$options['title']}}</h2>
            <p>{{$options['description']}}</p>
            <span class="divider"></span>
        </div>
        @endif
        @if($options['style'] == 'owlcarousel')
        <div class="row">
            <div class="col-md-12">
                @if(is_extensions('testimonials') and isset($testimonials))
                <div class="owl-carousel owl-{{$options['widgetid']}}" data-column="{{$options['column']}}">
                    @foreach ($testimonials as $item)
                    <div class="item">
                        <div class="testimonial-item">
                            <div class="testimonial-content">
                                <div class="testimonial-review">
                                    <p>{{$item->post_content}}</p>
                                </div>
                            </div>            
                            <div class="testimonial-footer">
                                <div class="testimonial-avatar">
                                    <img src="@if($item->thumbnail){{get_attachment_url($item->thumbnail, 'thumbnail')}}@else{{$options['avatar']}}@endif" alt="{{$item->post_title}}">
                                </div>              
                                <div class="testimonial-owner-content">
                                    <p class="testimonial-owner">{{$item->post_title}}</p>
                                    <p class="testimonial-position">{{$item->position}}</p>
                                    <div class="testimonial-rating">
                                        <ul class="stars">
                                            @for ($i = 1; $i <= 5; $i++)<li class="@if($i <= $item->rating) active @endif"><i class="fa fa-star"></i></li>@endfor
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
        @else
        <div class="row align-items-end">
            @if(is_extensions('testimonials') and isset($testimonials))
            @foreach ($testimonials as $item)
            <div class="{{$options['column']}} col-12">
                <div class="testimonial-item">
                    <div class="testimonial-content">
                        <div class="testimonial-review">
                            <p>{{$item->post_content}}</p>
                        </div>
                    </div>            
                    <div class="testimonial-footer">
                        <div class="testimonial-avatar">
                            <img src="@if($item->thumbnail){{get_attachment_url($item->thumbnail, 'thumbnail')}}@else{{$options['avatar']}}@endif" alt="{{$item->post_title}}">
                        </div>              
                        <div class="testimonial-owner-content">
                            <p class="testimonial-owner">{{$item->post_title}}</p>
                            <p class="testimonial-position">{{$item->position}}</p>
                            <div class="testimonial-rating">
                                <ul class="stars">
                                    @for ($i = 1; $i <= 5; $i++)<li class="@if($i <= $item->rating) active @endif"><i class="fa fa-star"></i></li>@endfor
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
            @endif
        </div>
        @endif
        @if($options['more_button'])
        <div class="row">
            <div class="col-md-12">
                <div class="home-more">
                    <a href="@if($options['more_url']){{$options['more_url']}}@else{{url('testimonials')}}@endif">@if($options['more_icon'])<i class="{{$options['more_icon']}}"></i>@endif {{$options['more_txt']}}</a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@push('scripts_code')
@if($options['style'] == 'owlcarousel')
$('.owl-{{$options['widgetid']}}').owlCarousel({
    @if($site_dir == 'rtl') rtl: true, @endif
    navigation: false,
    pagination: false,
    autoPlay: true,
    loop: !1,
    dots: true,
    margin: 25,
    responsive: {0:{items:{{$options['owlresphone']}}},800:{items:{{$options['owlrestablet']}}},1000:{items:{{$options['owlrespc']}}}}
});
@endif
@endpush