<?php
/**
 * Extension Name: Team
 * Extension URI: http://themearabia.net/extension/team
 * license: free
 * Version: 2.0
 * Requires: 5.0
 * Description: Team
 * Author: Themearabia
 * Author URI: http://themearabia.net
*/

if (!class_exists('extensions_team')) {
    class extensions_team
    {
        protected $veiwdir      = 'posts.team';
        protected $ex_id        = 'team';
        protected $ex_type      = 'team';
        protected $option_name  = 'options_team';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'team';
        protected $ex_icon      = 'bx bx-group';
        protected $ex_order     = '30';

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin())
            {
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_menu', [$this, 'admin_options_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_content', [$this, 'admin_options_content'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_newpost_'.$this->ex_type, [$this, 'filter_newpost'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_editpost_'.$this->ex_type, [$this, 'filter_editpost'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_team', [$this, 'widgets_options_team_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_team', [$this, 'widgets_options_team'], $this->ex_order, 1);
            }
            else
            {
                Eventy::addFilter('filter_data_page_team_style1', [$this, 'data_page_team'], $this->ex_order, 1);
                Eventy::addFilter('filter_data_page_team_style2', [$this, 'data_page_team'], $this->ex_order, 1);
                Eventy::addFilter('filter_data_page_team_style3', [$this, 'data_page_team'], $this->ex_order, 1);
                Eventy::addFilter('filter_data_page_team_style4', [$this, 'data_page_team'], $this->ex_order, 1);
                Eventy::addFilter('filter_data_page_team_style5', [$this, 'data_page_team'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_team', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        public function data_page_team($data){
            if(is_extensions('team')){
                $newdata = [];
                $newdata['column_style1'] = (isset($this->options['column_style1']))? $this->options['column_style1'] : 'col-md-3';
                $newdata['column_style2'] = (isset($this->options['column_style2']))? $this->options['column_style2'] : 'col-md-3';
                $newdata['column_style3'] = (isset($this->options['column_style3']))? $this->options['column_style3'] : 'col-md-3';
                $newdata['column_style4'] = (isset($this->options['column_style4']))? $this->options['column_style4'] : 'col-md-6';
                $newdata['column_style5'] = (isset($this->options['column_style5']))? $this->options['column_style5'] : 'col-md-6';
                $newdata['teams'] = $this->get_query()->get();
                return mega_parse_args($newdata, $data);
            }
            else {
                return $data;
            }   
        }

        /**
         * filter_data_home($data = [])
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('team'))
            {
                $default_options['widgetid']        = 'team';
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['style']           = 'style1';
                $default_options['column']          = 'col-md-3';
                $default_options['limit']           = 8;
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['teams']   = $this->get_query()->limit($options['limit'])->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * get_query()
         */
        public function get_query()
        {
            $query = DB::table('posts')
            ->leftJoin('postsmeta as job', function ($join) {$join->on('job.post_id', '=', 'posts.id')->where('job.meta_key', '=', 'job');})
            ->leftJoin('postsmeta as facebook', function ($join) {$join->on('facebook.post_id', '=', 'posts.id')->where('facebook.meta_key', '=', 'facebook');})
            ->leftJoin('postsmeta as twitter', function ($join) {$join->on('twitter.post_id', '=', 'posts.id')->where('twitter.meta_key', '=', 'twitter');})
            ->leftJoin('postsmeta as instagram', function ($join) {$join->on('instagram.post_id', '=', 'posts.id')->where('instagram.meta_key', '=', 'instagram');})
            ->leftJoin('postsmeta as thumbnails', function ($join) {$join->on('thumbnails.post_id', '=', 'posts.id')->where('thumbnails.meta_key', '=', 'thumbnails');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_name').
                db_select_column_as('posts', 'post_excerpts').
                db_select_column_as('posts', 'id').
                db_select_column_as('job', 'meta_value', 'job').
                db_select_column_as('facebook', 'meta_value', 'facebook').
                db_select_column_as('twitter', 'meta_value', 'twitter').
                db_select_column_as('instagram', 'meta_value', 'instagram').
                db_select_column_as('thumbnails', 'meta_value', 'thumbnail', '')
            )
            ->where(['post_type' => $this->ex_type, 'post_status' => '1'])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC');
            
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'team' => [
                    'title' => extension_lang($this->ex_lang, 'team'), 
                    'option' => 'team'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'team'));
        }

        /**
         * widgets_options_team()
         */
        public function widgets_options_team($data)
        {
            $style          = (isset($data['widget']['style']))? $data['widget']['style'] : 'style1';
            $limit          = (isset($data['widget']['limit']))? $data['widget']['limit'] : 4;
            $column         = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-3';
            $option_style = ['id' => $data['option_name'].'['.$data['key'].'][style]', 'box_class' => 'form-group', 'name' => admin_lang('style'), 'value' => $style, 'options' => [
                'style1' => admin_lang('style').' 1',
                'style2' => admin_lang('style').' 2',
                'style3' => admin_lang('style').' 3',
                'style4' => admin_lang('style').' 4',
                'style5' => admin_lang('style').' 5'
            ]];
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-3' => '4 '.admin_lang('column'), 
                'col-md-4' => '3 '.admin_lang('column'), 
                'col-md-6' => '2 '.admin_lang('column'), 
                'col-md-12' => '1 '.admin_lang('column')
            ]];
            $option_limit = ['id' => $data['option_name'].'['.$data['key'].'][limit]', 'box_class' => 'form-group', 'name' => admin_lang('post_per_page'), 'value' => $limit, 'min' => '1', 'max' => '32', 'step' => '1'];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_style, false).'
                </div>
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_slider_number_input($option_limit, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_team_echo($data)
         */
        public function widgets_options_team_echo($data)
        {
            echo $this->widgets_options_team($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'team'    => 'widgets.widget_team'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => $this->ex_type]];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'team'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'team'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'team'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'team'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'team'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data = ['id' => $this->ex_id, 'icon' => $this->ex_icon, 'title' => extension_lang($this->ex_lang, 'team')];
            echo get_admin_view('hooks.admin_options_menu_tab', $data)->render();
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {
            $column_style1 = (isset($this->options['column_style1']))? $this->options['column_style1'] : 'col-md-3';
            $column_style2 = (isset($this->options['column_style2']))? $this->options['column_style2'] : 'col-md-3';
            $column_style3 = (isset($this->options['column_style3']))? $this->options['column_style3'] : 'col-md-3';
            $column_style4 = (isset($this->options['column_style4']))? $this->options['column_style4'] : 'col-md-6';
            $column_style5 = (isset($this->options['column_style5']))? $this->options['column_style5'] : 'col-md-6';
            $data['options'][$this->ex_id]['section_general'] = [
                'title'     => admin_lang('general'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[column_style1]', 'name' => admin_lang('column').'[ '.admin_lang('style').' 1 ]', 'value' => $column_style1, 'options' => [
                        'col-md-3' => '4 '.admin_lang('column'), 
                        'col-md-4' => '3 '.admin_lang('column'), 
                        'col-md-6' => '2 '.admin_lang('column')
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column_style2]', 'name' => admin_lang('column').'[ '.admin_lang('style').' 2 ]', 'value' => $column_style2, 'options' => [
                        'col-md-3' => '4 '.admin_lang('column'), 
                        'col-md-4' => '3 '.admin_lang('column'), 
                        'col-md-6' => '2 '.admin_lang('column'),
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column_style3]', 'name' => admin_lang('column').'[ '.admin_lang('style').' 3 ]', 'value' => $column_style3, 'options' => [
                        'col-md-3' => '4 '.admin_lang('column'), 
                        'col-md-4' => '3 '.admin_lang('column'), 
                        'col-md-6' => '2 '.admin_lang('column')
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column_style4]', 'name' => admin_lang('column').'[ '.admin_lang('style').' 4 ]', 'value' => $column_style4, 'options' => [
                        'col-md-4' => '3 '.admin_lang('column'), 
                        'col-md-6' => '2 '.admin_lang('column'), 
                        'col-md-12' => '1 '.admin_lang('column')
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column_style5]', 'name' => admin_lang('column').'[ '.admin_lang('style').' 5 ]', 'value' => $column_style5, 'options' => [
                        'col-md-4' => '3 '.admin_lang('column'), 
                        'col-md-6' => '2 '.admin_lang('column'), 
                        'col-md-12' => '1 '.admin_lang('column')
                    ]],
                ]
            ];
            echo get_admin_view('hooks.admin_options_menu_content', $data)->render();
        }

        /**
         * filter_newpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_newpost($arg = [])
        {
            $newdata['job']         = '';
            $newdata['facebook']    = '';
            $newdata['twitter']     = '';
            $newdata['instagram']   = '';
            return array_merge( $newdata, (array) $arg );
        }

        /**
         * filter_editpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_editpost($arg = [])
        {
            $newdata['job']         = get_post_meta('job', $arg['post_id']);
            $newdata['facebook']    = get_post_meta('facebook', $arg['post_id']);
            $newdata['twitter']     = get_post_meta('twitter', $arg['post_id']);
            $newdata['instagram']   = get_post_meta('instagram', $arg['post_id']);
            return array_merge( $newdata, (array) $arg );
        }

    }

    new extensions_team();
}
