<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Driver;

/**
 * extension v1.0
 */

if(!function_exists('extension_path')){
    function extension_path($path = ''){
        return app_path('Extensions/'.$path);
    }
}

if(!function_exists('extension_url')){
    function extension_url($file = ''){
        return url(env('APP_ROOT_PAHT').'/app/Extensions/'.$file);
    }
}

if(!function_exists('is_extensions')){
    function is_extensions($name){
        $is_extensions = [];
        $default_extensions = ['about'];
        if(in_array($name, $default_extensions)){
            return true;
        }
        else {
            $extensions = maybe_unserialize(config('site.start_extensions'));
            if(is_array($extensions) and count($extensions)) {
                foreach($extensions as $key => $extension){
                    if(file_exists(extension_path($extension.'/extension.php'))){
                        $is_extensions[$extension] = true;
                    }
                }
            }

            if(is_array($name)){
                foreach($name as $n){
                    if(isset($is_extensions[$n])){
                        return true;
                    }
                }
            }
            else {
                if(isset($is_extensions[$name])){
                    return true;
                }
            }
        }
        return false;
    }
}

/**
 * widgets v1.0
 */

if(!function_exists('widgets_homepage_blade')){
    function widgets_homepage_blade($widget){
        $widgets_start = ['about' => 'widgets.widget_about'];
        $widgets_start = Eventy::filter('widgets_homepage_start', $widgets_start);
        if($widget['status'] and array_key_exists($widget['widget'], $widgets_start)){
            return $widgets_start[$widget['widget']];
        }
        else {
            return false;
        }
    }
}

if(!function_exists('widgets_homepage_set_data')){
    function widgets_homepage_set_data($key, $widget){
        $widget['widgetid']  = $widget['widget'].'_'.$key;
        $newdata = Eventy::filter('widgets_homepage_data_'.$widget['widget'], $widget);
        return $newdata;
    }
}

if(!function_exists('foreach_widgets_homepage_options')){
    function foreach_widgets_homepage_options($options, $value, $title){
        $options_html = '';
        foreach($options as $key => $option)
        {
            $select = ($value == $key)? 'selected=""' : '';
            if(isset($option['option'])){
                $data_option = 'data-option="'.$option['option'].'"';
            }
            else {
                $data_option = '';
            }

            $options_html .= '<option value="'.$key.'" '.$data_option.' '.$select.'>'.$title.' :: '.$option['title'].'</option>';
        }
        return $options_html;
    }
}

if(!function_exists('get_widgets_homepage_class')){
    function get_widgets_homepage_class($options){

    }
}

if(!function_exists('get_widgets_homepage_style')){
    function get_widgets_homepage_style($options){

    }
}

/**
 * options and config v1.0
 */

if(!function_exists('set_site_config')){
    function set_site_config(){
        $opstions = DB::table(OPTIONS_TABLE)->get();
        foreach($opstions as $option){
            if(is_serialized($option->option_value)){
                foreach(maybe_unserialize($option->option_value) as $key => $value){
                    config(['site.unserialize.'.$option->option_name.'.'.$key => $value]);
                }
            }
            config(['site.'.$option->option_name => $option->option_value]);
        }
    }
}

if(!function_exists('site_config_unserialize')){
    function site_config_unserialize($name, $default = false){
        $config = config('site.unserialize.'.$name);
        return ($config)? $config : $default;
    }
}

if(!function_exists('site_config_options')){
    function site_config_options($options, $name, $default = false){
        $config = config('site.unserialize.'.$options.'_options.'.$name);
        return ($config)? $config : $default;
    }
}

if(!function_exists('site_config')){
    function site_config($name, $default = false){
        $config = config('site.'.$name);
        return ($config)? $config : $default;
    }
}

if(!function_exists('get_option')){
    function get_option($name, $default = ''){
        return (site_config($name)) ? site_config($name) : $default;
    }
}

if(!function_exists('get_theme_option')){
    function get_theme_option($name, $default = ''){
        $theme_option = maybe_unserialize(site_config('theme_options_'.get_option('theme', 'default')));
        if(is_array($theme_option) and isset($theme_option[$name]))
        {
            return $theme_option[$name];
        }
        else {
            return $default;
        }
    }
}

if(!function_exists('get_option_explode')){
    function get_option_explode($string, $delimiter, $key, $default = false){
        $atr = explode($delimiter, $string);
        return (isset($atr[$key]) && $atr[$key])? $atr[$key] : $default;
    }
}

if(!function_exists('get_option_img')){
    function get_option_img($name, $default = false, $path = 'uploads/options/'){
        return (site_config($name)) ? url($path . site_config($name))  : $default;
    }
}

if(!function_exists('get_option_default')){
    function get_option_default($value, $default = ''){
        return ($value)? $value : $default;
    }
}

if(!function_exists('get_option_inarray')){
    function get_option_inarray($name, $key, $default = ''){
        if(is_array($name)){
            $options = $name;
        }
        else {
            $options = maybe_unserialize(get_option($name));
        }

        if(is_array($options) && isset($options[$key])){
            return $options[$key];
        } else{
            return $default;
        }
    }
}

if(!function_exists('update_option')){
    function update_option($name, $value = ''){
        $is_has = DB::table(OPTIONS_TABLE)->where([['option_name', '=', $name]])->exists();
        if ($is_has) {
            DB::table(OPTIONS_TABLE)->where(['option_name' => $name])->update(['option_value' => $value]);
        } else {
            DB::table(OPTIONS_TABLE)->insert(['option_name' => $name, 'option_value' => $value]);
        }
    }
}

if(!function_exists('get_options_autoload')){
    function get_options_autoload($act = ''){
        $opstions = DB::table(OPTIONS_TABLE)->get();
        $setting['config'] = [];
        foreach($opstions as $option){
            if(is_serialized($option->option_value)){
                $setting['config'][$option->option_name] = maybe_unserialize($option->option_value);
            }
            else {
                $setting['config'][$option->option_name] = $option->option_value;
            }
        }

        if(Auth::check() and $act == 'admin')
        {
            $admin_language = get_user_meta('admin_language', Auth::user()->id, 'en');
            $setting['admin_dir'] = ($admin_language == 'ar')? 'rtl' : 'ltr';
            $setting['admin_lang'] = $admin_language;
        }
        else {
            $setting['site_dir'] = get_option('direction', 'ltr');
            $setting['site_lang'] = get_option('language', 'en');
        }

        return $setting;
    }
}

if(!function_exists('get_option_extension')){
    function get_option_extension($config, $key, $default = ''){
        return (isset($config[$key]))? $config[$key] : $default;
    }
}

if(!function_exists('has_config')){
    function has_config($key, $default = '',$config = ''){
        return (isset($config[$key]))? $config[$key] : $default;
    }
}

if(!function_exists('get_theme_image')){
    function get_theme_image($image, $default){
        return (get_theme_option($image))? get_theme_option($image) : get_asset($default);
    }
}

/**
 * views and url and v1.0
 */

if(!function_exists('get_path_theme')){
    function get_path_theme($path){
        $theme = get_option('theme', 'default');
        return  'frontend' . $path . $theme;
    }
}

if(!function_exists('get_view')){
    function get_view($blade, $data = array()){
        $theme              = get_option('theme', 'default');
        $data['get_view']   = ['blade' => $blade, 'theme' => $theme];
        $data               = mega_parse_args(get_options_autoload(), $data);
        $data               = Eventy::filter('get_options_autoload', $data);
        $data               = Eventy::filter('filter_data_get_view', $data);
        $view               = 'frontend.' . $theme . '.' . $blade;
        return view($view, $data);
    }
}

if(!function_exists('get_extends')){
    function get_extends($blade){
        $theme = get_option('theme', 'default');
        $extend = 'frontend.' . $theme . '.' . $blade;
        return $extend;
    }
}

if(!function_exists('get_include')){
    function get_include($blade){
        $theme = get_option('theme', 'default');
        $extend = 'frontend.' . $theme . '.' . $blade;
        return $extend;
    }
}

if(!function_exists('get_asset')){
    function get_asset($file){
        $theme = get_option('theme', 'default');
        return asset('frontend/' . $theme . '/assets/' . $file);
    }
}

if(!function_exists('get_admin_view')){
    function get_admin_view($blade, $data = array()){
        $data = mega_parse_args(get_options_autoload('admin'), $data);
        $view = 'dashboard.' . $blade;
        return view($view, $data);

    }
}

if(!function_exists('get_admin_route')){
    function get_admin_route($route = false){
        $admindir = env('APP_ADMIN_FOLDER', 'admincp');
        if ($route) {
            return $admindir . '/' . $route;
        } else {
            return $admindir;
        }
    }
}

if(!function_exists('get_admin_url')){
    function get_admin_url($url = false){
        $admindir = env('APP_ADMIN_FOLDER', 'admincp');
        if ($url) {
            return url($admindir . '/' . $url);
        } else {
            return $admindir;
        }
    }
}

if(!function_exists('get_staff_view')){
    function get_staff_view($blade, $data_global = array()){
        $data_options = get_global_options();
        $data         = array_merge($data_global, $data_options);
        $view = 'staff.' . $blade;
        return view($view, $data);
    }
}

if(!function_exists('get_staff_route')){
    function get_staff_route($route = false){
        $staffdir = env('APP_STAFF_URL', 'staffcp');
        if ($route) {
            return $staffdir . '/' . $route;
        } else {
            return $staffdir;
        }
    }
}

if(!function_exists('get_staff_url')){
    function get_staff_url($url = false){
        $staffdir = env('APP_STAFF_URL', 'staffcp');
        if ($url) {
            return url($staffdir . '/' . $url);
        } else {
            return $staffdir;
        }
    }
}

if(!function_exists('get_each')){
    function get_each($blade){
        $theme = get_option('theme', 'default');
        $extend = 'frontend.' . $theme . '.' . $blade;
        return $extend;
    }
}

if(!function_exists('get_admin_each')){
    function get_admin_each($blade){
        $extend = 'dashboard.' . $blade;
        return $extend;
    }
}

if(!function_exists('get_admin_language')){
    function get_admin_language($type = 'lang'){
        if(Auth::check())
        {
            $admin_language = get_user_meta('admin_language', Auth::user()->id, 'en');
            $admin_dir  = ($admin_language == 'ar')? 'rtl' : 'ltr';
            $admin_lang = $admin_language;
        }
        else {
            $admin_dir  = 'ltr';
            $admin_lang = 'en';
        }
        return ($type == 'dir')? $admin_dir : $admin_lang;
    }
}

/**
 * serialize v1.0
 */

if(!function_exists('maybe_unserialize')){
    function maybe_unserialize($original, $default = [] ){
        if (is_serialized($original)){
            return @unserialize($original);
        } else{
            return ($default)? $default : $original;
        }
    }
}

if(!function_exists('is_serialized')){
    function is_serialized($data, $strict = true){
        if (!is_string($data)) {return false;}
        $data = trim($data);
        if ('N;' == $data) {return true;}
        if (strlen($data) < 4) {return false;}
        if (':' !== $data[1]) {return false;}
        if ($strict) {
            $lastc = substr($data, -1);
            if (';' !== $lastc && '}' !== $lastc) {return false;}
        } else {
            $semicolon = strpos($data, ';');
            $brace = strpos($data, '}');
            if (false === $semicolon && false === $brace) {return false;}
            if (false !== $semicolon && $semicolon < 3) {return false;}
            if (false !== $brace && $brace < 4) {return false;}
        }
        $token = $data[0];
        switch ($token) {
            case 's':
                if ($strict) {if ('"' !== substr($data, -2, 1)) {return false;}}
                elseif (false === strpos($data, '"')) {return false;}
            case 'a':
            case 'O':
                return (bool) preg_match("/^{$token}:[0-9]+:/s", $data);
            case 'b':
            case 'i':
            case 'd':
                $end = $strict ? '$' : '';
                return (bool) preg_match("/^{$token}:[0-9.E-]+;$end/", $data);
        }
        return false;
    }
}

if(!function_exists('is_serialized_string')){
    function is_serialized_string($data){
        if (!is_string($data)) {return false;}
        $data = trim($data);
        if (strlen($data) < 4) {return false;}
        elseif (':' !== $data[1]) {return false;}
        elseif (';' !== substr($data, -1)) {return false;}
        elseif ($data[0] !== 's') {return false;}
        elseif ('"' !== substr($data, -2, 1)) {return false;}
        else {return true;}
    }
}

if(!function_exists('maybe_serialize')){
    function maybe_serialize($data){
        if (is_array($data) || is_object($data)) {return serialize($data);}
        if (is_serialized($data, false)){return serialize($data);}
        return $data;
    }
}

/**
 * generate v1.0
 */

if(!function_exists('generate_uniqueid')){
    function generate_uniqueid($table, $key = false, $type = '', $length = 7){
        $z = 0;
        while ($z <= 0) {
            $token = generate_token($length, $type);
            if ($key && $table && $table == POSTSMETA_TABLE) {
                $is_key = DB::table($table)->where([['meta_key', '=', $key], ['meta_value', '=', $token]])->exists();
                if (!$is_key) {
                    $z = 1;
                    continue;
                }
                continue;
            } elseif ($key && $table) {
                $is_key = DB::table($table)->where($key, $token)->exists();
                if (!$is_key) {
                    $z = 1;
                    continue;
                }
                continue;
            } else {
                $z = 1;
                continue;
            }
            continue;
        }
        return $token;
    }
}

if(!function_exists('crypto_rand_secure')){
	function crypto_rand_secure($min, $max){
		$range = $max - $min;
		if ($range < 1){return $min; }
		$log = ceil(log($range, 2));
		$bytes = (int) ($log / 8) + 1;
		$bits = (int) $log + 1;
		$filter = (int) (1 << $bits) - 1;
		do {
			$rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
			$rnd = $rnd & $filter;
		} while ($rnd > $range);
		return $min + $rnd;
	}
}

if(!function_exists('str_replace_first')){
    function str_replace_first($from, $to, $content){
        $from = '/'.preg_quote($from, '/').'/';
        return preg_replace($from, $to, $content, 1);
    }
}

if(!function_exists('generate_token')){
	function generate_token($length, $type = false){
        $token = "";
        if($type == 'alp')
        {
            $code = "abcdefghijklmnopqrstuvwxyz";
        }
        elseif($type == 'calp')
        {
            $code = "ABCDEFGHIJKLMNOQRSTUVXYZ";
        }
        elseif($type == 'num')
        {
            $code = "0123456789";
        }
        elseif($type == 'cmix')
        {
            $code = "0123456789ABCDEFGHIJKLMNOQRSTUVXYZ";
        }
        elseif($type == 'mix')
        {
            $code = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOQRSTUVXYZ";
        }
        else
        {
            $code = "0123456789abcdefghijklmnopqrstuvwxyz";
        }

		$max = strlen($code);
		for ($i=0; $i < $length; $i++) {
			$token .= $code[crypto_rand_secure(0, $max-1)];
		}
		return $token;
	}
}

if(!function_exists('generate_license_code')){
	function generate_license_code(){
        $format = get_option('license_code_format');
		$times = substr_count($format,"{[X]}");
		for($i=0;$i<=$times;$i++){
			$format = str_replace_first("{[X]}", generate_token(1, 'num'), $format);
		}
		$times = 0;

		$times = substr_count($format,"{[Y]}");
		for($i=0;$i<=$times;$i++){
			$format = str_replace_first("{[Y]}", generate_token(1, 'alp'), $format);
		}
		$times = 0;

		$times = substr_count($format,"{[Z]}");
		for($i=0;$i<=$times;$i++){
			$format = str_replace_first("{[Z]}", substr(MD5(microtime()), 0, 1), $format);
		}
		$ff = strtoupper($format);
		return $ff;
	}
}

/**
 * languages v1.0
 */

if(!function_exists('lang')){
    function lang($string, $replace = [], $file = 'global', $locale = null){
        $theme = get_option('theme', 'default');
        $locale = in_array(config('site.language'), ['en', 'ar'])? config('site.language') : 'en';
        return trans('themes/'.$theme.'/'.$file . '.' . $string, $replace, $locale);
    }
}

if(!function_exists('admin_lang')){
    function admin_lang($string, $replace = [], $file = 'admin', $locale = false){

        $locale = ($locale)? $locale : get_admin_language();
        return trans($file . '.' . $string, $replace, $locale);
    }
}

if(!function_exists('admin_other_lang')){
    function admin_other_lang($string, $replace = [], $locale = false){
        $locale = get_option('language', 'en');
        return admin_lang($string, $replace, 'admin',$locale);
    }
}

if(!function_exists('extension_lang')){
    function extension_lang($string, $replace = [], $locale = null,$file = 'admin_global'){
        if(is_admin()){
            $locale = get_admin_language();
        }
        else {
            $locale = in_array(config('site.language'), ['en', 'ar'])? config('site.language') : 'en';
        }
        return trans('extensions/'.$file . '.' . $string, $replace, $locale);
    }
}

/**
 * users v1.0
 */

if(!function_exists('has_user_meta')){
    function has_user_meta($key, $id){
        $is_has = DB::table(USERSMETA_TABLE)->where(['user_id' => $id, 'meta_key' => $key])->exists();
        return $is_has;
    }
}

if(!function_exists('get_user_meta')){
    function get_user_meta($key, $id, $return = false){
        if(has_user_meta($key, $id)){
            $meta_value  = DB::table(USERSMETA_TABLE)->where(['user_id' => $id, 'meta_key' => $key])->value('meta_value');
            return $meta_value;
        } else {
            return $return;
        }
    }
}

if(!function_exists('update_user_meta')){
    function update_user_meta($key, $value, $id){
        if(has_user_meta($key, $id)){
            DB::table(USERSMETA_TABLE)->where(['user_id' => $id, 'meta_key' => $key])->update(['meta_value' => $value]);
        } else {
            DB::table(USERSMETA_TABLE)->insert(['user_id' => $id, 'meta_key' => $key, 'meta_value' => $value]);
        }
    }
}

if(!function_exists('get_user_avatar')){
    function get_user_avatar($user_id, $size = '64'){
        return 'https://ui-avatars.com/api/?name='.urlencode(get_user_column($user_id, 'username')).'&color=7F9CF5&background=EBF4FF&size='.$size;
    }
}

if(!function_exists('get_user_avatar_username')){
    function get_user_avatar_username($username, $size = '64'){
        return 'https://ui-avatars.com/api/?name='.urlencode($username).'&color=7F9CF5&background=EBF4FF&size='.$size;
    }
}

if(!function_exists('get_username')){
    function get_username($user_id, $meta = false, $name_meta = array()){
        $name  = DB::table(USERS_TABLE)->where('id', $user_id)->value('username');
        if($meta && isset($name_meta[0])){
            $user_meta  = get_user_meta($meta, $user_id);
            return ($user_meta)? $user_meta . $name_meta[0] . $name . $name_meta[1] : $name;
        } elseif($meta) {
            $user_meta  = get_user_meta($meta, $user_id);
            return ($user_meta)? $user_meta : $name;
        } else {
            return $name;
        }
    }
}

if(!function_exists('get_user_column')){
    function get_user_column($id, $column){
        $column  = DB::table(USERS_TABLE)->where("id", $id)->value($column);
        return $column;
    }
}

if(!function_exists('query_user_meta')){
    function query_user_meta($user_id){
        $query_meta = DB::table(USERSMETA_TABLE)->where('user_id', $user_id)->get();
        $meta = [];
        foreach($query_meta as $item){
            if(is_serialized($item->meta_value)){
                $meta[$item->meta_key] = maybe_unserialize($item->meta_value);
            }
            else{
                $meta[$item->meta_key] = $item->meta_value;
            }
        }
        return $meta;
    }
}

if(!function_exists('get_user_cover')){
    function get_user_cover($user_id, $cover = 'usercover.jpg'){
        return asset('images/'.$cover);
    }
}

if(!function_exists('get_user_totalcount')){
    function get_user_totalcount($userid, $type = false){
        return DB::table(POSTS_TABLE)->select('post_author')->where("post_author", $userid)->where("post_type", $type)->count();
    }
}

if(!function_exists('get_user_level_count')){
    function get_user_level_count($level = ''){
        return DB::table(USERS_TABLE)->where('userlevel', $level)->count();
    }
}

/**
 * posts v1.0
 */

if(!function_exists('has_post_meta')){
    function has_post_meta($key, $id){
        $is_has = DB::table(POSTSMETA_TABLE)->where(['meta_key' => $key, 'post_id' => $id])->exists();
        return $is_has;
    }
}

if(!function_exists('get_post_meta')){
    function get_post_meta($key, $id, $return = false){
        if (has_post_meta($key, $id)) {
            $meta_value  = DB::table(POSTSMETA_TABLE)->where(['meta_key' => $key, 'post_id' => $id])->value('meta_value');
            return $meta_value;
        } else {
            return $return;
        }
    }
}

if(!function_exists('update_post_meta')){
    function update_post_meta($key, $value, $id){
        if (has_post_meta($key, $id)) {
            DB::table(POSTSMETA_TABLE)->where(['post_id' => $id,'meta_key' => $key])->update(['meta_value' => $value]);
        } else {
            DB::table(POSTSMETA_TABLE)->insert(['post_id' => $id,'meta_key' => $key,'meta_value' => $value]);
        }
    }
}
if(!function_exists('getCardAvaCash')){
    function getCardAvaCash($driverId){
            $driver=Driver::find($driverId);
            $card=$driver->CARD_NUM;
            //setCard in EFS
            $efsdata = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $card
            ];
            $response = CallAPI('POST','https://tms.tmdashboard.com/api/esfAPIS/getcurrentcashall_api.php',$efsdata);
            $responseData = json_decode($response);
            $cashAvailable = 0;
            if(!empty($responseData->ns5getCurrentCashAllAmountsResponse)){
                $cashAvailable = $responseData->ns5getCurrentCashAllAmountsResponse->result->value->cashAvailable;
                $driver->cashAvailable = $cashAvailable;
                $driver->save();
            }
            return $cashAvailable;
    }
}
if(!function_exists('get_balance')){
    function get_balance(){
        if(!empty(Auth::user()->contract_id)){
            //setCard in EFS
            $efsdata = [
                'clientID' => getEFSClientID(),
                'contractID' => Auth::user()->contract_id,
            ];
            $response = CallAPI('POST','https://tms.tmdashboard.com/api/esfAPIS/getcreditlimits_api.php',$efsdata);
            $responseData = json_decode($response);
            $creditAvailable = 0;
            if(!empty($responseData->ns5getCreditLimitsResponse)){
                $creditAvailable = $responseData->ns5getCreditLimitsResponse->result->creditAvailable;

                $user = Auth::user();
                $user->credit_available = $creditAvailable;
                $user->save();
            }
            return $creditAvailable;
        }else{
            return $creditAvailable = 0.00;
        }

    }
}

if(!function_exists('get_sum_of_all_company_user')){
    function get_sum_of_all_company_user(){
        $count = DB::table('users')
        ->where('userlevel', 'supervisor')
        ->sum('credit_available');
            return $count;
    }
}

if(!function_exists('get_driver_count')){
    function get_driver_count(){
        $count = DB::table('smartpay_driver')->where('MEM_ID', Auth::user()->id)->where('STATUS', 1)->count();
        return $count;
    }
}

if(!function_exists('get_admin_driver_count')){
    function get_admin_driver_count(){
        $count = DB::table('smartpay_driver')->where('STATUS', 1)->count();
        return $count;
    }
}

if(!function_exists('get_card_count')){
    function get_card_count(){
        $count = DB::table('smartpay_driver')->where('MEM_ID', Auth::user()->id)->where('STATUS', 1)->where('CARD_NUM', '!=', NULL)->count();
        return $count;
    }
}

if(!function_exists('get_admin_card_count')){
    function get_admin_card_count(){
        $count = DB::table('smartpay_driver')->where('STATUS', 1)->where('CARD_NUM', '!=', NULL)->count();
        return $count;
    }
}

if(!function_exists('sum_of_cash_available')){
    function sum_of_cash_available(){
        $count = DB::table('smartpay_driver')->where('MEM_ID', Auth::user()->id)->sum('cashAvailable');
        return $count;
    }
}

if(!function_exists('sum_of_admin_cash_available')){
    function sum_of_admin_cash_available(){
        $count = DB::table('smartpay_driver')->sum('cashAvailable');
        return $count;
    }
}

if(!function_exists('get_company_count')){
    function get_company_count(){
        $count = DB::table('users')->where('userlevel', 'supervisor')->where('status', 1)->count();
        return $count;
    }
}

if(!function_exists('get_post_count')){
    function get_post_count($type, $term_id = ''){
        if ($term_id) {
            $count = DB::table(POSTS_TABLE)->where([['term_id', '=', $term_id], ['post_type', '=', $type]])->count();
        } else {
            $count = DB::table(POSTS_TABLE)->where([['post_type', '=', $type]])->count();
        }
        return $count;
    }
}

if(!function_exists('get_post_count_status')){
    function get_post_count_status($type, $term_id = '', $status = 1){
        if ($term_id) {
            $count = DB::table(POSTS_TABLE)->where([['term_id', '=', $term_id], ['post_type', '=', $type], ['post_status', '=', $status]])->count();
        } else {
            $count = DB::table(POSTS_TABLE)->where([['post_type', '=', $type], ['post_status', '=', $status]])->count();
        }
        return $count;
    }
}

if(!function_exists('get_posts_type')){
    function get_posts_type($type, $term_id = false, $status = false){
        if ($term_id) {
            $where[] =  ['term_id', '=', $term_id];
        }

        if ($status) {
            $where[] =  ['post_status', '=', $status];
        }

        $where[] =  ['post_type', '=', $type];

        $posts = DB::table(POSTS_TABLE)->where($where)->get();

        return $posts;
    }
}

if(!function_exists('get_posts')){
    function get_posts($args){
        if ($args['cid']) {
            $where[] =  ['term_id', '=', $args['cid']];
        }

        $status     = (isset($args['status']))? $args['status'] : 1;
        $where[]    =  ['post_status', '=', $status];
        $where[]    =  ['post_type', '=', $args['type']];
        $limit      = (isset($args['limit']))? $args['limit'] : 10;
        $posts      = DB::table(POSTS_TABLE)->where($where)->limit($limit)->get();
        return $posts;
    }
}

if(!function_exists('get_post_title')){
    function get_post_title($id){
        $title  = DB::table(POSTS_TABLE)->where('id', $id)->value('post_title');
        return $title;
    }
}

if(!function_exists('get_post_name')){
    function get_post_name($id){
        $post_name  = DB::table(POSTS_TABLE)->where('id', $id)->value('post_name');
        return $post_name;
    }
}

if(!function_exists('get_post_column')){
    function get_post_column($id, $column = 'post_title'){
        return DB::table(POSTS_TABLE)->where('id', $id)->value($column);
    }
}

if(!function_exists('update_post_meta_array')){
    function update_post_meta_array($post_id,$args = array()){
        foreach ($args as $key => $value) {
            update_post_meta($key, $value, $post_id);
        }
    }
}

if(!function_exists('update_post_views')){
    function update_post_views($id){
        if (has_post_meta('views', $id)) {
            $views = get_post_meta('views', $id);
            $views++;
            DB::table(POSTSMETA_TABLE)->where([
                'post_id'       => $id,
                'meta_key'      => 'views'
            ])->update(['meta_value' => $views]);
        } else {
            DB::table(POSTSMETA_TABLE)->insert([
                'post_id'       => $id,
                'meta_key'      => 'views',
                'meta_value'    => '1'
            ]);
        }
    }
}

if(!function_exists('get_post_meta_inarray')){
    function get_post_meta_inarray($meta, $key, $default = ''){
        $meta = maybe_unserialize($meta, []);
        return (isset($meta[$key]))? $meta[$key] : $default;
    }
}

if(!function_exists('get_default_postmeta')){
    function get_default_postmeta($post_type){
        $default = [
            'meta_author'       => '0',
            'meta_date'         => '0',
            'meta_comments'     => '0',
            'meta_views'        => '0',
            'meta_shareit'      => '0',
            'views'             => '0',
        ];
        $postmeta = Eventy::filter('admin_filter_default_postmeta_'.$post_type, $default);

        return $postmeta;
    }
}

if(!function_exists('query_posts_meta')){
    function query_posts_meta($post_id){
        $query_meta = DB::table(POSTSMETA_TABLE)->where('post_id', $post_id)->get();
        $meta = get_default_postmeta(get_post_column($post_id, 'post_type'));
        foreach($query_meta as $item){
            if(is_serialized($item->meta_value)){
                $meta[$item->meta_key] = maybe_unserialize($item->meta_value);
            }
            else{
                $meta[$item->meta_key] = $item->meta_value;
            }
        }
        return $meta;
    }
}

if(!function_exists('get_post_count_where')){
    function get_post_count_where($where = []){
        return  DB::table(POSTS_TABLE)->where($where)->count();;
    }
}

if(!function_exists('get_posts_where')){
    function get_posts_where($where = [], $order = []){
        return DB::table(POSTS_TABLE)
        ->where($where)
        ->orderBy('post_pin', 'desc')
        ->orderBy('post_orders', 'asc')
        ->orderBy('post_modified', 'desc')
        ->get();
    }
}

if(!function_exists('get_posts_count')){
    function get_posts_count($type, $plus = 0){
        $count = DB::table(POSTS_TABLE)->where('post_type', $type)->count();
        return $count + $plus;
    }
}

/**
 * terms v1.0
 */

if(!function_exists('get_categories_type')){
    function get_categories_type($type){
        $categories = DB::table(TERMS_TABLE)->where('type', $type)->get();
        return $categories;
    }
}

if(!function_exists('get_term_by_slug')){
    function get_term_by_slug($slug, $type){
        $term = DB::table(TERMS_TABLE)->where(['status' => '1', 'type' => $type, 'slug' => $slug])->get();
        return $term;
    }
}

if(!function_exists('get_term_column')){
    function get_term_column($id, $column = 'name')
    {
        return DB::table(TERMS_TABLE)->where('id', $id)->value($column);
    }
}

if(!function_exists('get_term_name')){
    function get_term_name($id){
        $name  = DB::table(TERMS_TABLE)->where('id', $id)->value('name');
        return ($name)? $name : '';
    }
}

if(!function_exists('get_term_slug')){
    function get_term_slug($id){
        $slug  = DB::table(TERMS_TABLE)->where('id', $id)->value('slug');
        return $slug;
    }
}

if(!function_exists('get_term_count')){
    function get_term_count($type, $plus = 0){
        $count = DB::table(TERMS_TABLE)->where('type', $type)->count();
        return $count + $plus;
    }
}

if(!function_exists('get_term_parent_count')){
    function get_term_parent_count($parent, $type){
        $count = DB::table(TERMS_TABLE)->where(['type' => $type, 'parent' => $parent])->count();
        return $count;
    }
}

/**
 * comments v1.0
 */

if(!function_exists('get_count_comments')){
    function get_count_comments($post_id, $type =''){
        $count = DB::table(COMMENTS_TABLE)->where([
            ['cpid', '=', $post_id],
            ['cstatus', '=', '1'],
            ['ctype', '=', $type]
        ])->get()->count();
        return $count;
    }
}

if(!function_exists('get_comment_column')){
    function get_comment_column($id, $column){
        $column  = DB::table(COMMENTS_TABLE)->where("cid", $id)->value($column);
        return $column;
    }

}

if(!function_exists('get_comments_parent')){
    function get_comments_parent($cparent, $type){
        $comments = DB::table(COMMENTS_TABLE)->where([
            ['ctype', '=', $type], ['cstatus', '=', '1'], ['cparent', '=', $cparent], ['spam_trash', '=', '0']
        ])->orderBy('cmodified', 'ASC')->get();
        return $comments;
    }
}

if(!function_exists('get_post_title_from_comment')){
    function get_post_title_from_comment($pid, $type){
        return '<a href="'.get_admin_url('editpost/'.$pid).'">'.get_post_title($pid).'</a>';
    }
}

if(!function_exists('get_loop_comments_single')){
    function get_loop_comments_single($type, $id, $request){
        $paged = ($request->has('pagecm'))? $request->get('pagecm') : 1;
        $comments = DB::table(COMMENTS_TABLE)->where([
            ['ctype', '=', $type],
            ['cpid', '=', $id],
            ['cstatus', '=', '1'],
            ['cparent', '=', '0'],
            ['spam_trash', '=', '0']
        ])->orderBy('cmodified', 'ASC')->latest('cmodified')->get();
        return $comments;
    }
}

/**
 * other
 */


if(!function_exists('helpers_path')){
    function helpers_path($path = ''){
        return app_path('Helpers/'.$path);
    }
}

if(!function_exists('theme_path')){
    function theme_path($path = ''){
        return resource_path('views/frontend/'.$path);
    }
}

if(!function_exists('theme_url')){
    function theme_url($file = ''){
        return url(env('APP_ROOT_PAHT').'/resources/views/frontend/'.$file);
    }
}

if(!function_exists('is_admin')){
    function is_admin(){
        $admindir = env('APP_ADMIN_FOLDER', 'admincp');
        if(Request()->route()->getPrefix() == '/'.$admindir){
            return true;
        }
        else {
            return false;
        }
    }
}

if(!function_exists('get_media_count')){
    function GetRealIp(){
        foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
            if (array_key_exists($key, $_SERVER) === true){
                foreach (explode(',', $_SERVER[$key]) as $ip){
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false){
                        return $ip;
                    }
                }
            }
        }
        return request()->ip();
    }
}

if(!function_exists('mega_parse_args')){
    function mega_parse_args($args, $defaults = array()){
        if (is_object($args)) {
            $parsed_args = get_object_vars( $args );
        } elseif ( is_array( $args ) ) {
            $parsed_args =& $args;
        } else {
            $parsed_args = [];
        }

        if ( is_array( $defaults ) && $defaults ) {
            return array_merge( $defaults, $parsed_args );
        }
        return $parsed_args;
    }
}

if(!function_exists('get_media_count')){
    function get_media_count(){
        $count = DB::table(ATTACHMENTS_TABLE)->count();
        return $count;
    }
}

if(!function_exists('setting_input_radio')){
    function setting_input_radio($name, $value, $type = '',$inputs = array()){
        $html = '<div class="megapanel-buttons-options">';
        if (is_array($inputs)) {
            if ($type != '') {
                $onoff = ['option-off', 'option-on'];
            }
            foreach ($inputs as $key => $input) {
                $active = ($key == $value) ? 'active' : '';
                $class  = ($type != '') ? $onoff[$key] : 'option-on';
                $html .= '<button type="button" data-value="' . $key . '" class="' . $class . ' ' . $active . '">' . $input . '</button>';
            }
        }
        $html .= '<input type="hidden" name="' . $name . '" value="' . $value . '"></div>';
        return $html;
    }
}

if(!function_exists('setting_input_radio_multiple')){
    function setting_input_radio_multiple($name, $value, $offkey = '',$inputs = array()){

        $html = '<div class="megapanel-buttons-options">';
        if (is_array($inputs)) {
            foreach ($inputs as $key => $input) {
                $active = ($key == $value) ? 'active' : '';
                $class  = ($key == $offkey) ? 'option-off' : 'option-on';
                $html .= '<button type="button" data-value="' . $key . '" class="' . $class . ' ' . $active . '">' . $input . '</button>';
            }
        }
        $html .= '<input type="hidden" name="' . $name . '" value="' . $value . '"></div>';
        return $html;
    }
}

if(!function_exists('setting_input_radio_custtom')){
    function setting_input_radio_custtom($name, $value, $type = '',$inputs = array()){
        $html= '';
        $counoption = count($inputs);
        $i = 0;
        $class = '';
        foreach($inputs as $key => $input){
            $i++;
            if(is_array($input)){
                if($type == 'img'){
                    $class      = 'boximg';
                    $labelafter = '<div class="option-boximg"><img src="'.$input['img'].'" /></div>';
                } else {
                    $class = 'boxcolor';
                }
                if(isset($input['boxcolor'])){$labelafter = '<div class="option-boxcolor" style="background: '.$input['boxcolor'].'"><i class="bx bx-check"></i></div>';}
                $label = $input['label'];
            }
            else{$label = $input;}
            $active = ($key == $value) ? 'active' : '';
            $html .= '<button type="button" data-value="'.$key.'" class="option-on '.$class.' '.$active.'">'.$labelafter.' '.$label.'</button>';
        }
        $html .= '<input type="hidden" name="'.$name.'" value="'.$value.'">';
        return $html;
    }
}

if(!function_exists('selected')){
    function selected($checked, $current, $echo = true){
        if ($checked == $current) {
            $result = 'selected=""';
        } else {
            $result = '';
        }
        if ($echo) {
            echo $result;
        }
        return $result;
    }
}

if(!function_exists('get_select_delete_options')){
    function get_select_delete_options(){
        $html = '<div class="actionselect"><select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;"><option value="-1">'.admin_lang('bulk_actions').'</option><option value="delete">'.admin_lang('delete').'</option></select>&nbsp;<input type="submit" class="btn btn-sm btn-primary" value="' . admin_lang('apply') . '" onclick="return confirm(\\\'' . admin_lang('apply_confirm') . '\\\');" /></div>';
        return $html;
    }
}

if(!function_exists('get_select_actions_options')){
    function get_select_actions_options($order = false){
        $html = '<div class="actionselect"><select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;"><option value="-1">' . admin_lang('bulk_actions') . '</option>';
        if ($order) {
            $html .= '<option value="reorders">' . admin_lang('reorders') . '</option>';
        }
        $html .= '<option value="enable">' . admin_lang('enable') . '</option><option value="disable">' . admin_lang('disable') . '</option><option value="delete">' . admin_lang('delete') . '</option></select>&nbsp;<input type="submit" class="btn btn-sm btn-primary" value="' . admin_lang('apply') . '" onclick="return confirm(\\\'' . admin_lang('apply_confirm') . '\\\');" /></div>';
        return $html;
    }
}

if(!function_exists('get_in_browser')){
    function get_in_browser($serialize, $key){
        $browser = maybe_unserialize($serialize);
        return (isset($browser[$key]))? $browser[$key] : '-';
    }
}

if(!function_exists('remove_http_www')){
	function remove_http_www($input){
		$url = $input;
		$url = filter_var($url, FILTER_SANITIZE_URL);
		if (filter_var($url, FILTER_VALIDATE_URL) !== false) {
			$input = trim($input, '/');
			if (!preg_match('#^http(s)?://#', $input)) {
				$input = 'http://' . $input;
			}
			$urlParts = parse_url($input);
			$domain = preg_replace('/^www\./', '', $urlParts['host']);
			if(!empty($urlParts['path'])){
				$domain .= $urlParts['path'];
			}
			return $domain;
		} else {
			return $input;
		}
	}
}

if(!function_exists('remove_http_www_bulk')){
	function remove_http_www_bulk($inputs){
		$gd = array();
		foreach(explode(',', $inputs) as $doms){
			$url = $doms;
			$url = filter_var($url, FILTER_SANITIZE_URL);
			if (filter_var($url, FILTER_VALIDATE_URL) !== false) {
				$input = trim($doms, '/');
				if (!preg_match('#^http(s)?://#', $input)) {
					$input = 'http://' . $input;
				}
				$urlParts = parse_url($input);
				$domain = preg_replace('/^www\./', '', $urlParts['host']);
				if(!empty($urlParts['path'])){
					$domain .= $urlParts['path'];
				}
				$gd[] = $domain;
			}else{
				$gd[] = $url;
			}
		}
		return implode(',',$gd);
	}
}

if(!function_exists('time_ago')){
    function time_ago($datetime, $full = false, $lang = false){
        $now = new DateTime;
        $ago = (is_numeric($datetime))? new DateTime(date('Y-m-d H:i:s', $datetime)) :  new DateTime($datetime);
        $diff = $now->diff($ago);
        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array(
            'y' => ($lang)? admin_lang('year') : lang('year'),
            'm' => ($lang)? admin_lang('month') : lang('month'),
            'w' => ($lang)? admin_lang('week') : lang('week'),
            'd' => ($lang)? admin_lang('day') : lang('day'),
            'h' => ($lang)? admin_lang('hour') : lang('hour'),
            'i' => ($lang)? admin_lang('minute') : lang('minute'),
            's' => ($lang)? admin_lang('second') : lang('second'),
        );
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                if(get_option('language', 'en') == 'en') {
                    $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
                }
                else {
                    $v = $diff->$k . ' ' . $v ;
                }
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        if($lang) {
            if(get_option('language', 'en') == 'en') {
                return $string ? implode(', ', $string) . ' ' . admin_lang('ago') : admin_lang('justnow');
            }
            else {
                return $string ? admin_lang('ago') .' '. implode(', ', $string): admin_lang('justnow');
            }
        }
        else {
            if(get_option('language', 'en') == 'en') {
                return $string ? implode(', ', $string) . ' ' . lang('ago') : lang('justnow');
            }
            else {
                return $string ? lang('ago') .' '. implode(', ', $string): lang('justnow');
            }
        }
    }
}

if(!function_exists('get_days_diff')){
    function get_days_diff($datetime){
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago)->format("%a");
        return $diff;
    }
}

if(!function_exists('format_size')){
    function format_size($filesize){
        $size = '--';
        switch ($filesize){
            case $filesize < 1024:
                $size = $filesize .' B';
            break;
            case $filesize < 1048576:
                $size = round($filesize / 1024, 2) .' KB';
            break;
            case $filesize < 1073741824:
                $size = round($filesize / 1048576, 2) . ' MB';
            break;
            case $filesize < 1099511627776:
                $size = round($filesize / 1073741824, 2) . ' GB';
            break;
        }
        return $size;
    }
}

if(!function_exists('get_attachment_url')){
    function get_attachment_url($id, $size = 'thumbnail'){
        $attachment_file = DB::table(ATTACHMENTS_TABLE)->where('at_id', $id)->value('at_files');
        $file = maybe_unserialize($attachment_file);
        if(isset($file[$size]) and $file)
        {
            return url($file[$size]);
        }
        elseif(isset($file['file']) and $file)
        {
            return url($file['file']);
        }
        else
        {
            return false;
        }
    }
}

if(!function_exists('get_thumbnail')){
    function get_thumbnail($id){
        $file_def = [
            'thumbnail'     => false,
            'medium'        => false,
            'medium_large'  => false,
            'file'          => false,
        ];
        $attachment_file = DB::table(ATTACHMENTS_TABLE)->where('at_id', $id)->value('at_files');

        $file = maybe_unserialize($attachment_file);
        return mega_parse_args($file, $file_def);
    }
}

if(!function_exists('get_attachment_data_url')){
    function get_attachment_data_url($attachment, $size = 'thumbnail'){
        $file = maybe_unserialize($attachment);
        if(isset($file[$size]) and $file){
            return url($file[$size]);
        }
        elseif(isset($file['file']) and $file){
            return url($file['file']);
        }
        else{
            return false;
        }
    }
}

if(!function_exists('get_media_mimes_thumbnail')){
    function get_media_mimes_thumbnail($attachment, $type, $size = 'thumbnail'){
        if($attachment or in_array($type, ['svg', 'webp', 'bmp'])){
            $src = get_attachment_data_url($attachment, $size);
        }
        else {
            if(file_exists(public_path("public/libs/filetypes/{$type}.svg"))){
                $src = asset("libs/filetypes/{$type}.svg");
            } else {
                $src = asset("libs/filetypes/search.svg");
            }
        }
        return $src;
    }
}

if(!function_exists('clear_string')){
	function clear_string($string){
		$string = strtolower($string);
		$string = preg_replace("/[\s-]+/", " ", $string);
		$string = preg_replace("/[\s_]/", "-", $string);
		$string = str_replace(".","_",$string);
		return $string;
	}
}

if(!function_exists('preg_slug')){
    function preg_slug($title, $table = 'post', $type = 'posts', $id = 0){
        $slug       = Str::slug($title, '-');
        $z          = 0;
        $i          = 1;
        $atr_slug   = '';
        while ($z <= 0) {
            $slug_name = $slug . $atr_slug;
            if($table == 'post'){
                $is_slug  = DB::table(POSTS_TABLE)->where([['post_name', '=', $slug_name], ['post_type', '=', $type], ['id', '!=', $id]])->count();
            }
            elseif($table == 'categories'){
                $is_slug  = DB::table(TERMS_TABLE)->where([['slug', '=', $slug_name], ['type', '=', $type], ['id', '!=', $id]])->count();
            }

            if(!$is_slug){
                $z = 1;
                continue;
            }
            else{
                $atr_slug = '-'.$i++;
            }
            continue;
        }

        return $slug_name;
    }
}

if(!function_exists('str_strip')){
    function str_strip($string){
        $string = trim(preg_replace('/\s\s+/u', ' ', $string));
        return $string;
    }
}

if(!function_exists('sanitize_text')){
    function sanitize_text($string){
        $string = str_replace(array('‘', '’', '“', '”'), array("'", "'", '"', '"'), $string);
        return $string;
    }
}

if(!function_exists('unsanitize_text')){
    function unsanitize_text($string){
        $string = str_replace(array("'", "'", '"', '"'), array('‘', '’', '“', '”'), $string);
        return $string;
    }
}

if(!function_exists('safe_input')){
    function safe_input($string, $br = true){
        $string = trim($string);
        $string = unsanitize_text($string);
        $string = strip_tags($string);
        $string = preg_replace('/[\x{10000}-\x{10FFFF}]/u', '', $string);
        $string = htmlspecialchars($string, ENT_QUOTES);
        if($br){
            $string = str_replace("\r\n", "\n", $string);
            $string = str_replace("\n", '<br />', $string);
        }
        $string = trim($string);
        return $string;
    }
}

if(!function_exists('safe_textarea')){
    function safe_textarea($string){
        $string = unsanitize_text($string);
        $string = preg_replace('/[\x{10000}-\x{10FFFF}]/u', '', $string);
        $string = htmlspecialchars($string, ENT_QUOTES);
        $string = str_replace(array("&lt;pre&gt;", "&lt;/pre&gt;"), array("<pre>", "</pre>"), $string);
        $string = str_replace("\r\n", "\n", $string);
        $string = str_replace("\n", '<br />', $string);
        $string = trim($string);
        return $string;
    }
}

if(!function_exists('input_safe_tags_trim')){
    function input_safe_tags_trim($input){
        return strip_tags(trim($input));
    }
}

if(!function_exists('get_messages_count')){
    function get_messages_count($type){
        $count   = DB::table(POSTS_TABLE)->where([['post_type', '=', $type], ['post_status', '=', '0']])->count();
        return $count;
    }
}

if(!function_exists('get_messages_html')){
    function get_messages_html($type1, $type2 = ''){
        $count_unraed1   = DB::table(POSTS_TABLE)->where([['post_type', '=', $type1], ['post_status', '=', '0']])->count();
        if($type2)
        {
            $count_unraed2   = DB::table(POSTS_TABLE)->where([['post_type', '=', $type2], ['post_status', '=', '0']])->count();
            $count = $count_unraed1 + $count_unraed2;
        }
        else
        {
            $count = $count_unraed1;
        }


        return ($count)? '<span class="badge rounded-pill bg-danger float-end">'.$count.'</span>' : '';
    }
}

if(!function_exists('cleanup_header_comment')){
    function cleanup_header_comment($str){
        return trim(preg_replace("/\s*(?:\*\/|\?>).*/", '', $str));
    }
}

if(!function_exists('has_isset')){
    function has_isset($value, $default = ''){
        return (isset($value))? $value : $default;
    }
}

if(!function_exists('file_upload_max_size')){
    function file_upload_max_size(){
        static $max_size = -1;
        if ($max_size < 0) {
            $post_max_size = parse_size(ini_get('post_max_size'));
            if ($post_max_size > 0) {
                $max_size = $post_max_size;
            }
            $upload_max = parse_size(ini_get('upload_max_filesize'));
            if ($upload_max > 0 && $upload_max < $max_size) {
                $max_size = $upload_max;
            }
        }
        return $max_size;
    }
}

if(!function_exists('parse_size')){
    function parse_size($size){
        $unit = preg_replace('/[^bkmgtpezy]/i', '', $size);
        $size = preg_replace('/[^0-9\.]/', '', $size);
        if ($unit) {
            return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
        } else {
            return round($size);
        }
    }
}

if(!function_exists('utf8_uri_encode')){
    function utf8_uri_encode($utf8_string, $length = 0){
        $unicode = '';
        $values = array();
        $num_octets = 1;
        $unicode_length = 0;
        $string_length = strlen($utf8_string);
        for ($i = 0; $i < $string_length; $i++) {
            $value = ord($utf8_string[$i]);
            if ($value < 128) {
                if ($length && ($unicode_length >= $length))
                    break;
                $unicode .= chr($value);
                $unicode_length++;
            } else {
                if (count($values) == 0) {
                    if ($value < 224) {
                        $num_octets = 2;
                    } elseif ($value < 240) {
                        $num_octets = 3;
                    } else {
                        $num_octets = 4;
                    }
                }
                $values[] = $value;
                if ($length && ($unicode_length + ($num_octets * 3)) > $length)
                    break;
                if (count($values) == $num_octets) {
                    for ($j = 0; $j < $num_octets; $j++) {
                        $unicode .= '%' . dechex($values[$j]);
                    }
                    $unicode_length += $num_octets * 3;
                    $values = array();
                    $num_octets = 1;
                }
            }
        }
        return $unicode;
    }
}

if(!function_exists('get_front_menu')){
    function get_front_menu($id){
        $nav_main_menu = maybe_unserialize(get_post_column($id, 'post_content'));
        return (is_array($nav_main_menu))? $nav_main_menu : [];
    }
}

if(!function_exists('get_loop_nav_menu_list')){
    function get_loop_nav_menu_list($key , $value, $li = true){
        $menuopen 			= (isset($value['menuopen']) and $value['menuopen'])? 'menu-open' : '';
        $checked_target   	= (isset($value['target']) and $value['target'])? 'checked="check"' : '';
        $checked_useronly 	= (isset($value['useronly']))? 'checked="check"' : '';
        $value['title'] 	= (isset($value['title']))? $value['title'] : '';
        $value['itemtype'] 	= (isset($value['itemtype']))? $value['itemtype'] : '';
        $value['image'] 	= (isset($value['image']))? $value['image'] : '';
        $value['icon'] 	    = (isset($value['icon']))? $value['icon'] : '';
        $value['classes'] 	= (isset($value['classes']))? $value['classes'] : '';
        $value['menuopen'] 	= (isset($value['menuopen']) and $value['menuopen'])? $value['menuopen'] : '';
        $value['url'] 	    = (isset($value['url']))? $value['url'] : '';
        $html  = ($li)? '<li class="menu-item '.$menuopen.'" id="menu-item-'.$key.'" data-id="'.$key.'">' : '';
        $html .= '
        <div class="menu-item-bar">
            <div class="menu-item-handle">
                <span class="item-title"><span class="menu-item-title menu-title-'.$key.'">'.$value['title'].'</span></span>
                <span class="item-controls"><span class="item-type">'.str_replace("_", " ", $value['itemtype']).'</span><i class="item-menu-edit" data-id="'.$key.'"></i></span>
            </div>
            </div>
            <div class="menu-item-settings" id="menu-item-settings-'.$key.'">
            <div class="form-group">
                <label>'.admin_lang('title').'</label>
                <input type="text" class="form-control input-sm menu-title" data-id="'.$key.'" name="title['.$key.']" value="'.$value['title'].'">
            </div>
            <div class="form-group">
                <label>'.admin_lang('url').'</label>
                <input type="text" class="form-control input-sm menu-url" name="url['.$key.']" value="'.$value['url'].'">
            </div>
            <div class="form-group">
                <label>'.admin_lang('icon').'</label>
                <div class="megapanel-icon-select">
                    <span class="megapanel-icon-preview"><i class="'.$value['icon'].'"></i></span>
                    <button type="button" class="btn btn-primary waves-effect waves-light megapanel-icon-add" data-modal-title="'.admin_lang('icons').'">'.admin_lang('changes').'</button>
                    <button type="button" class="btn btn-secondary waves-effect waves-light megapanel-icon-default" data-geticon="'.$value['icon'].'">'.admin_lang('default').'</button>
                    <button type="button" class="btn  btn-danger waves-effect waves-light megapanel-icon-remove">'.admin_lang('remove').'</button>
                    <input type="hidden" name="icon['.$key.']" value="'.$value['icon'].'" class="megapanel-icon-value">
                </div>
            </div>
            <div class="form-group">
                <label>'.admin_lang('image').'</label>
                <div>
                    <input class="form-control" data-toggle="fileupload" data-field="fieldid'.$key.'" type="text" name="image['.$key.']" value="'.$value['image'].'" >
                </div>
            </div>
            <div class="form-group">
                <label>'.admin_lang('css_classes').'</label>
                <input type="text" class="form-control input-sm menu-class" name="classes['.$key.']" value="'.$value['classes'].'">
            </div>
            <div class="form-group">
                <input type="checkbox" value="_blank" name="target['.$key.']">
                <span class="lbl">'.admin_lang('open_link_in_new_tab').'</span>
            </div>
            <div class="menu-item-actions">
                <span class="item-delete menu-submitdelete" data-id="'.$key.'">'.admin_lang('delete').'</span>
            </div>
            <input type="hidden" class="data-itemtype-'.$key.'" name="itemtype['.$key.']" value="'.$value['itemtype'].'">
            <input type="hidden" class="menu-open-'.$key.'" name="menuopen['.$key.']" value="'.$value['menuopen'].'">
        </div>
        <script>$(document).ready(function(){$(\'[data-toggle="fileupload"]\').fileupload();});</script>
        ';
        $html .= ($li)? '</li>' : '';
        return $html;
    }
}

if(!function_exists('is_permission')){

    function is_permission($permission){
        $roles=['supervisor','user','new'];
        if(Auth::check()){
            $user = Auth::user();
            if($user->userlevel == 'admin'){
                return true;
            }
            elseif(in_array(Auth::user()->userlevel, $roles)) {
                $user_permission = [];
                $user_permission = maybe_unserialize(get_user_meta('permission', $user->id, []), []);
                return in_array($permission, $user_permission);
            }
        }
        else{
            return false;
        }
    }
}

if(!function_exists('get_array_permission')){
    function get_array_permission(){

        $permissions = [
            'pages'  => [
                'title' => admin_lang('pages'),
                'permission' => [
                    'pages' => admin_lang('pages'),
                ]
            ],
            'users'  => [
                'title' => admin_lang('users'),
                'permission' => [
                    'users' => admin_lang('users'),
                ]
            ],
            'media_library'  => [
                'title' => admin_lang('media_library'),
                'permission' => [
                    'media_library' => admin_lang('media_library'),
                ]
            ],
            'comments'  => [
                'title' => admin_lang('comments'),
                'permission' => [
                    'comments' => admin_lang('comments'),
                ]
            ],
            'themes'  => [
                'title' => admin_lang('themes'),
                'permission' => [
                    'themes' => admin_lang('themes'),
                ]
            ],
            'menus'  => [
                'title' => admin_lang('menus'),
                'permission' => [
                    'menus' => admin_lang('menus'),
                ]
            ],
            'theme_options '  => [
                'title' => admin_lang('theme_options'),
                'permission' => [
                    'theme_options' => admin_lang('theme_options'),
                ]
            ],
            'settings'  => [
                'title' => admin_lang('settings'),
                'permission' => [
                    'settings' => admin_lang('settings'),
                ]
            ],
            'extensions'  => [
                'title' => admin_lang('extensions'),
                'permission' => [
                    'extensions' => admin_lang('extensions'),
                ]
            ],
            'deceased'  => [
                'title' => admin_lang('Deceased'),
                'permission' => [
                    'deceased' => admin_lang('deceased'),
                ]
            ],
        ];

        $permissions = Eventy::filter('admin_permissions_args', $permissions);
        ksort($permissions);

        return $permissions;
    }
}

if(!function_exists('get_submenu_count_comments')){
    function get_submenu_count_comments($type, $html = true){
        if($type == 'unapproved'){
            $count = DB::table(COMMENTS_TABLE)->select('cid')->where([['spam_trash', '=', '0'], ['cstatus', '=', '0']])->get()->count();
        }

        if($count){
            return ($html)? '<span class="badge rounded-pill bg-danger float-end">'.$count.'</span>' : $count;
        }
    }
}

if(!function_exists('time_format')){
    function time_format($time, $type = 'full', $formatdate = 'd/m/Y', $formattime = 'H:i:s'){
        if(!is_numeric($time)) {
            $time = strtotime($time);
        }
        if ($type == 'time') {
            $time_format = date($formattime, $time);
        } elseif ($type == 'date') {
            $time_format = date($formatdate, $time);
        } else {
            $time_format = date($formatdate . ' ' . $formattime, $time);
        }
        return get_arabic_date($time_format);
    }
}

if(!function_exists('get_arabic_date')){
    function get_arabic_date($date){
        $en_data = [
            'January', 'Jan', 'Feburary', 'Feb', 'March', 'Mar',
            'April', 'Apr', 'May', 'June', 'Jun',
            'July', 'Jul', 'August', 'Aug', 'September', 'Sep',
            'October', 'Oct', 'November', 'Nov', 'December', 'Dec',
            'Satureday', 'Sat', 'Sunday', 'Sun', 'Monday', 'Mon',
            'Tuesday', 'Tue', 'Wednesday', 'Wed', 'Thursday', 'Thu', 'Friday', 'Fri',
            'AM', 'am', 'PM', 'pm'
        ];

        $ar_data = [
            'يناير', 'يناير', 'فبراير', 'فبراير', 'مارس', 'مارس',
            'أبريل', 'أبريل', 'مايو', 'مايو', 'يونيو', 'يونيو',
            'يوليو', 'يوليو', 'أغسطس', 'أغسطس', 'سبتمبر', 'سبتمبر',
            'أكتوبر', 'أكتوبر', 'نوفمبر', 'نوفمبر', 'ديسمبر', 'ديسمبر',
            'السبت', 'السبت', 'الأحد', 'الأحد', 'الإثنين', 'الإثنين',
            'الثلاثاء', 'الثلاثاء', 'الأربعاء', 'الأربعاء', 'الخميس', 'الخميس', 'الجمعة', 'الجمعة',
            'صباحاً', 'صباحاً', 'مساءً', 'مساءً'
        ];

        return str_replace($en_data, $ar_data, $date);
    }
}

if(!function_exists('get_class_active')){
    function get_class_active($checked = '', $current = '', $echo = true){
        if ($checked == $current) {
            $result = 'active';
        } else {
            $result = '';
        }
        if ($echo) {
            echo $result;
        }
        return $result;
    }
}

if(!function_exists('get_post_type_tags')){
    function get_post_type_tags($type){
        $tags = [];
        $posts = DB::table(POSTS_TABLE)->where(['post_type' => $type,'post_status' => 1])->get();
        foreach($posts as $post){
            if($post->post_tags) {
                $tags_array = explode(',', $post->post_tags);
                $tags = mega_parse_args( $tags, $tags_array);
            }

        }
        return array_count_values($tags);
    }
}

if(!function_exists('get_tags_args')){
    function get_tags_args($post_tags, $slug){
        $tags_args = [];
        if($post_tags){
            $x = 0;
            $tags    = explode(',', $post_tags);
            foreach($tags as $tag){
                $x++;
                $sign = (count($tags) > $x)? ', ' : '';
                $tags_args[] = ['link' => url($slug.$tag), 'name' => $tag, 'sign' => $sign];
            }
        }
        return $tags_args;
    }
}

if(!function_exists('db_select_column_as')){
    function db_select_column_as($table, $column, $as_column = false, $end = ', '){
        $db_prefix = env('DB_PREFIX');
        $new_column = ($as_column)? " AS {$as_column}" : '';
        return "{$db_prefix}{$table}.{$column}{$new_column}{$end}";
    }
}

if(!function_exists('db_select_column_as_count')){
    function db_select_column_as_count($table, $column, $as_column = false, $end = ', '){
        $db_prefix = env('DB_PREFIX');
        $new_column = ($as_column)? " AS {$as_column}" : '';
        return "count({$db_prefix}{$table}.{$column}) {$new_column}{$end}";
    }
}

/*
* EFS API FUNCTIONS
*/

if(!function_exists('CallAPI')){
    function CallAPI($method, $url, $data = false)
    {

        //echo "<pre>",print_r($method),print_r($url),print_r($data);//die;

        $curl = curl_init();
        switch ($method)
        {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
                //curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_PUT, 1);
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($curl, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        //curl_setopt($curl, CURLOPT_POST, true);
        //curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data)); // the SOAP request
        // curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($curl);

        $err = curl_error($curl);
        curl_close($curl);
                if ($err) {
                echo "$ 0.00";
                //die;
            }

        return $result;
    }
}

if(!function_exists('getEFSClientID')){
    function getEFSClientID(){
        $efs_username='wsTRANSPORTERS ';
        $efs_password='trucking3650904';
        $data=array('username' => $efs_username, 'password' => $efs_password);
        $return_data = CallAPI('POST','https://tms.tmdashboard.com/api/esfAPIS/login_api.php',$data);
        $clientid=trim($return_data);
        if($clientid == ''){
            return redirect()->back()->with('error', "Api Down.");
        }
        return $clientid;
    }
}
/**
 * other class
 */
class xssClean {

    public function clean_input( $input, $safe_level = 0 ) {
        if(!$input){
            dd($input);
        }
        if($input){
            $output = $input;
            do {
                // Treat $input as buffer on each loop, faster than new var
                $input = $output;

                // Remove unwanted tags
                $output = $this->strip_tags( $input );
                $output = $this->strip_encoded_entities( $output );

                // Use 2nd input param if not empty or '0'
                if ( $safe_level !== 0 ) {
                    $output = $this->strip_base64( $output );
                }

            } while ( $output !== $input );

            return $output;
        }
        else {
            return '';
        }

    }

    private function strip_encoded_entities( $input ) {

        // Fix &entity\n;
        $input = str_replace(array('&amp;','&lt;','&gt;'), array('&amp;amp;','&amp;lt;','&amp;gt;'), $input);
        $input = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $input);
        $input = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $input);
        $input = html_entity_decode($input, ENT_COMPAT, 'UTF-8');

        // Remove any attribute starting with "on" or xmlns
        $input = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+[>\b]?#iu', '$1>', $input);

        // Remove javascript: and vbscript: protocols
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $input);
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $input);
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $input);

        // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $input);
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $input);
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $input);

        return $input;

    }

    private function strip_tags( $input ) {
        // Remove tags
        $input = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $input);
        // Remove namespaced elements
        $input = preg_replace('#</*\w+:\w[^>]*+>#i', '', $input);
        return $input;

    }

    private function strip_base64( $input ) {
        $decoded = base64_decode( $input );
        $decoded = $this->strip_tags( $decoded );
        $decoded = $this->strip_encoded_entities( $decoded );
        $output = base64_encode( $decoded );
        return $output;
    }
}

$xssClean = new xssClean();
