<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use DB;
use Auth;
use Hash;
use Validator;

class CompanyController extends Controller
{
    public function return ($status, $message, $errors, $data)
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'errors' => $errors,
            'data' => $data
        ]);
    }
    public function companys(Request $request)
    {
        $users = DB::table(USERS_TABLE)->where('userlevel', 'supervisor')->orderBy('created_at', 'DESC')->orderBy('status', 'ASC');
        if ($request->get('s')) {
            $search = $request->get('s');
            $users->where(function ($query) use ($search) {
                $query->Where('company_name', 'LIKE', "%{$search}%");
                $query->orWhere('contract_id', 'LIKE', "%{$search}%");
                $query->orWhere('ar_id', 'LIKE', "%{$search}%");
                $query->orWhere('username', 'LIKE', "%{$search}%");
                $query->orWhere('email', 'LIKE', "%{$search}%");
            });
        }
        $data['users'] = $users->get();
        if ($data['users']) {
            return $this->return(true, 'Company Listing Successfully', [], $data);
        } else {
            return $this->return(false, 'Error Occured.', ['message' => 'No Data Found'], []);
        }
    }

    public function company_add()
    {
        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        return $this->return(true, "Data Fetched Successfully.", [], $user);
    }

    public function company_store(Request $request)
    {
        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }

        $validator = Validator::make($request->all(), [
            'userlevel' => 'required',
            'action' => 'required',
            'two_factor' => 'required',
            'status' => 'required',
            'username' => 'required|unique:users,username,',
            'email' => 'required|email|unique:users,email,',
        ], [
                'username.required' => admin_lang('username_required'),
                'username.unique' => admin_lang('username_not_unique'),
                'email.required' => admin_lang('email_required'),
                'email.email' => admin_lang('email_correct'),
                'email.unique' => admin_lang('email_not_unique'),
            ]);

        $userlevel = $request->get('userlevel');
        $userid = $request->get('userid');

        if ($request->get('action') == 'addnew') {
            $validator = Validator::make($request->all(), [
                'password' => 'required',
                'password_confirmation' => 'required|same:password',
            ], [
                    'password.required' => admin_lang('password_required'),
                    'password_confirmation.same' => 'Password And Confirm Password Do Not Match.',
                ]);
            if ($userlevel == 'admin') {
                $validator = Validator::make($request->all(), [
                    'pincode' => 'required'
                ], [
                        'pincode.required' => admin_lang('pincode_required')
                    ]);
            }
        }

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        if ($request->get('action') == 'update') {
            $user_id = $request->get('userid');
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'username' => safe_input($request->get('username'), false),
                'email' => safe_input($request->get('email'), false),
                'two_factor' => $request->two_factor,
                'updated_at' => now(),
            ]);
        } else {
            $user_id = DB::table(USERS_TABLE)->insertGetId([
                'username' => safe_input($request->get('username'), false),
                'email' => safe_input($request->get('email'), false),
                'company_name' => safe_input($request->get('company_name'), false),
                'contract_id' => safe_input($request->get('contract_id'), false),
                'ar_id' => safe_input($request->get('ar_id'), false),
                'remember_token' => NULL,
                'active_key' => NULL,
                'updated_at' => now(),
                'created_at' => now(),
            ]);
        }

        if ($user->userlevel == 'admin') {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'userlevel' => safe_input($request->get('userlevel'), false),
                'status' => safe_input($request->get('status'), false)
            ]);
        }

        // update company_name
        if ($request->has('company_name') and !empty($request->get('company_name'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['company_name' => safe_input($request->get('company_name'), false)]);
        }
        // update company_name
        if ($request->has('contract_id') and !empty($request->get('contract_id'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['contract_id' => safe_input($request->get('contract_id'), false)]);
        }

        if ($request->has('ar_id') and !empty($request->get('ar_id'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['ar_id' => safe_input($request->get('ar_id'), false)]);
        }

        // update password
        if ($request->has('password') and !empty($request->get('password'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['password' => Hash::make($request->get('password'))]);
        }

        // update pincode
        if ($request->has('pincode') and !empty($request->get('pincode'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['pincode' => md5($request->get('pincode'))]);
        }

        if ($request->has('action') == 'update') {
            $message = admin_lang('msg_profile_updated');
        } else {
            $message = admin_lang('msg_user_add');
        }

        return $this->return(true, $message, [], []);
    }

    public function company_edit(Request $request, $id = false)
    {
        $curre_user = Auth::guard('api')->user();
        if(! $curre_user){
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        $user_id = ($id) ? $id : $curre_user->id;
        $getuser = DB::table(USERS_TABLE)->where([['id', '=', $user_id]])->first();
        $data['user'] = $getuser;

        if ($data['user']) {
            return $this->return(true, "Company Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }
    }

    public function company_actions(Request $request)
    {
        if ($request->has('query') && $request->get('query') == 'action') {
            $marks['id'] = $request->get('mark');
            if ($request->get('action') == 'enable' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->update(['status' => '1']);
                }
                $success = admin_lang('msg_enable_selected');
            } elseif ($request->get('action') == 'disable' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->update(['status' => '0']);
                }
                $success = admin_lang('msg_disable_selected');
            } elseif ($request->get('action') == 'delete' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->delete();
                }
                $success = admin_lang('msg_delete_selected');
            } else {
                return $this->return(false, "Error Occured.", ['message' => 'No Action Chosen.'], []);
            }
            return $this->return(true, $success, [], []);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Something Went Wrong.'], []);
        }
    }

    public function enable_company($id)
    {
        $company = DB::table(USERS_TABLE)->where('id', $id)->update(['status' => 1]);
        if ($company) {
            return $this->return(true, "Company Enabled Successfully.", [], []);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found'], []);
        }
    }

    public function disable_company($id)
    {
        $company = DB::table(USERS_TABLE)->where('id', $id)->update(['status' => 0]);
        if ($company) {
            return $this->return(true, "Company Disabled Successfully.", [], []);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found'], []);
        }
    }

    public function delete_company($id)
    {
        $company = DB::table(USERS_TABLE)->where(['id' => $id])->delete();
        if ($company) {
            return $this->return(true, "Company Deleted Successfully.", [], []);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }
    }
}
