<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\estate;
use PHPUnit\Framework\Constraint\Count; 
use App\Http\Requests\EstateRequest;

class EstateController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'estate';
        $this->page_title   = 'estate';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('estateadd');
        $this->paginate     = 5;
    }
    public function index_estate($type = '',Request $request){

        $data['type']       = 'users';
        $data['page_class'] = 'estate';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
         //if ($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}
         return get_admin_view('estate.index_estate',["data"=> $data]);
    }

    public function ajaxlist_estate(Request $request){
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'estate';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $estate=new estate();
         
            $estate = $estate->orderBy('created_at', 'DESC');
          
            if($request->get('s')){
                $search = $request->get('s');
                $estate->orWhere('estate_name', 'LIKE', "%{$search}%");
                $estate->orWhere('created_at', 'LIKE', "%{$search}%");
                $estate->orWhere('updated_at', 'LIKE', "%{$search}%");
                
            }
            $estate = $estate->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $estate->lastPage()) {return redirect($estate->url($estate->lastPage()));}
            return get_admin_view('estate.ajaxlist_estate', ["data"=> $data,'estates'=>$estate]);
        }
   
    }
    public function esate_profile($id =0, Request $request)
    {
   
        $curre_user = Auth::user();
       
        $user_id =  $curre_user->id;
   
        $estate=estate::find($id);
     
        if($estate){
        
        $getuser = User::find($user_id);
       
        if ($getuser->count()) {
           
            $type               = 'users';
            $user               = $getuser->first();
            $data['user']       = $user;
            $data['type']       = $type;
            $data['page_class'] = $type;
            $data['action']     = 'update';
            $data['page_title'] = 'Estate';
            $data['user_meta']  = query_user_meta($data['user']->id);
            
            $datauser                   = $user;
            $data['user_userlevel']     = $curre_user->userlevel;
            $data['userlevel']          = $datauser->userlevel;
            $data['type']               = $datauser->userlevel;
            $data['page_class']         = $datauser->userlevel;
            $data['action']             = 'update';
            $data['userid']             = $datauser->id;
            $data['username']           = $datauser->username;
            $data['email']              = $datauser->email;
            $data['user_status']        = $datauser->status;
            $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
            $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
            $data['user_permission']    = (is_array($permission))? $permission : [];

            return get_admin_view('estate.profile_estate', ["data"=>$data,"estate"=>$estate]);
        }
    }
    }

     // index profile

     public function index_estateadd(Request $request)
     {
         $user = Auth::user();
     
         $data['page_title']         = "Add Estate";
         $type                       = 'users';
         $data['type']               = $type;
         $data['page_class']         = $type;
         $data['action']             = 'addnew';
         $data['user_userlevel']     = $user->userlevel;
         $data['userlevel']          = 'user';
         $data['user_vip']           = '0';
         $data['user_viptime']       = '';
         $data['userid']             = '0';
         $data['user_status']        = '1';
         $data['username']           = '';
         $data['email']              = '';
         $data['admin_language']     = 'en';
         $data['user_permission']    = [];
         return get_admin_view('estate.estate_edit', ['data'=>$data]);
     }
     // send form

     public function estate_sendform(EstateRequest $request)
     {
          
         $user = Auth::user();
     
         $userid = $request->get('userid');
         
         $estate=estate::create(["estate_name"=>$request->input('estate_name'),
         "created_at"=>$request->input("created_at"),
         "updated_at"=>$request->input('updated_at')]);
         if($estate){
             return redirect()->back()->with('success','Estate '.$request->input('estate_name') . ' added Successfully!');
           }else{
             return redirect()->back()->with('failure', "Estate ".$request->input('estate_name') . ' Not added');
           }
      
     
        // return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
     }
     // actions post

     public function estate_actions(EstateRequest $request)
     {
     
         if($request->has('query') && $request->get('query') == 'action')
         {
           
              if($request->get('action') == 'update')
             {
              
                 $estate=estate::find($request->input('id'));
                 $estate->estate_name = $request->input('estate_name');
                 $estate->created_at = $request->input('created_at');
                 $estate->updated_at = $request->input('updated_at');
                 if($estate->save()){
                     return redirect()->back()->with("success", "Esatae Updated successfully!");
                 }else{
                     return redirect()->back()->with("failure", "Esatae Not Updated!");
                 }
             }
    else{
             $marks = $request->get('mark');
              if(empty($marks)){
                 return redirect()->back();
              }
              $faileditem=0;
              $success="";
             if($request->get('action') == 'delete' and is_array($marks))
             {
              
                 foreach($marks as $markid)
                 {
                    $success= estate::find($markid)->delete();
                    if(empty($success)){
                     $faileditem= $faileditem+1;
                    }
                 }
                 if($faileditem==0){
                    $request->session()->put('success', "Selected Estate Items are Deleted Successfully!");
                    return redirect()->back();
                 }
                 else if($faileditem!=0){
                    $request->session()->put('failure', "Selected Items are deleted except $faileditem estate");
                    return redirect()->back();
                 }
                 else{
                    $request->session()->put('failure', "Selected Items are not deleted");
                    return redirect()->back();
                 }
             }
          
 
             
         }
     }
     }
     // action enable post

      // action delete post
    public function index_deleteestate($id, $token,Request $request)
    { $estate=estate::find($id);
      $estatename=$estate->estate_name;
      $estate=$estate->delete();
      if($estate){
        $request->session()->put("success", "estate $estatename deleted Successfully!");
        return redirect()->back();
      }else{
        $request->session()->put("failure", "estate $estatename Not deleted!");
        return redirect()->back();
      }
    }
}
