<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class MenusController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
    }
    
    public function index_menus($id = false, Request $request)
    {
        if(!is_permission('menus')){
            return parent::admin_handle_permission('menus');
        }
        $data['page_class'] = 'settings';
        $data['page_title'] = admin_lang('menus');
        $loop_menus = DB::table(POSTS_TABLE)->orderBy('post_modified', 'DESC')->where('post_type', 'menus')->get();
        $data['loop_menus'] = $loop_menus;
        $data['defult_menus'] = [
            'home' => ['title' => admin_lang('home'), 'url' => url('/'), 'icon' => 'pe-7s-home'],
        ];
        $pages = DB::table(POSTS_TABLE)->orderBy('post_modified', 'DESC')->where(['post_status' => '1','post_type' => 'pages'])->get();
        $data['pages'] = $pages;
        if($id){
            $menu = DB::table(POSTS_TABLE)->where(['post_type' => 'menus', 'id' => $id]);
            if($menu->count()){
                $post = $menu->first();
                $data['menu_title'] = $post->post_title;
                $nav_main_menu = maybe_unserialize($post->post_content);
                $data['nav_main_menu'] = (is_array($nav_main_menu))? $nav_main_menu : [];
                $data['nav_main_menu_key']  = get_post_meta('newkey', $post->id, 0);
                $data['menu_id'] = $post->id;
            }
            else {
                return redirect(get_admin_url('menus'));
            }
        }
        else {
            $data['menu_title'] = '';
            $data['nav_main_menu'] = [];
            $data['nav_main_menu_key']  = '1';
            $data['menu_id'] = false;
        }

        return get_admin_view('menus.menus', $data);
    }
    
    public function menus_sendform(Request $request)
    {
        if(!is_permission('menus')){
            return parent::admin_handle_permission('menus');
        }
        $main_menu  = [];
        $main_submenu = [];
        $menus_list = json_decode($request->get('menu_item_map'));
        if($menus_list == null){
            $menus_list = [];
        }
        $newkey = 0;
        foreach($menus_list as $key => $value){
            $newkey++;
            $title          = $request->get('title');
            $url            = $request->get('url');
            $itemtype       = $request->get('itemtype');
            $icon           = $request->get('icon');
            $image          = $request->get('image');
            $classes        = $request->get('classes');
            $target         = $request->get('target');
            $menuopen       = $request->get('menuopen');
            if($value == 'null') {
                $main_menu[$key] = array(
                    'title'     => $title[$key], 
                    'url'       => ($url[$key] and $url[$key] != '#')? trim($url[$key], '/') : 'javascript:void(0);',
                    'itemtype'  => $itemtype[$key],  
                    'icon'      => (isset($icon[$key]))? $icon[$key] : '', 
                    'image'     => (isset($image[$key]))? $image[$key] : '',
                    'classes'   => (isset($classes[$key]))? $classes[$key] : '', 
                    'target'    => (isset($target[$key]))? $target[$key] : '', 
                    'menuopen'  => (isset($menuopen[$key]))? $menuopen[$key] : '', 
                    'newkey'  	=> $newkey,
                    'submenu'	=> [],
                );
            }
            else {
                $main_submenu = array(
                    'title'     => $title[$key], 
                    'url'       => ($url[$key] and $url[$key] != '#')? trim($url[$key], '/') : '',
                    'itemtype'  => $itemtype[$key], 
                    'icon'      => (isset($icon[$key]))? $icon[$key] : '', 
                    'image'     => (isset($image[$key]))? $image[$key] : '', 
                    'classes'   => (isset($classes[$key]))? $classes[$key] : '', 
                    'target'    => (isset($target[$key]))? $target[$key] : '', 
                    'menuopen'  => (isset($menuopen[$key]))? $menuopen[$key] : '', 
                    'newkey'  	=> $newkey,
                    'value'  	=> $value,
                );
                if(isset($main_menu[$value]['submenu'])) {
                    array_push($main_menu[$value]['submenu'], $main_submenu);
                }
                
            }
        }

        $menu_id = $request->get('menu_id');
        $menu_title = $request->get('menu_title');

        if($request->get('menu_id')){
            DB::table(POSTS_TABLE)->where('id', $menu_id)->update([
                'post_title'        => $menu_title,
                'post_name'         => preg_slug($menu_title, 'post', 'menus', $menu_id),
                'post_content'      => maybe_serialize($main_menu),
            ]);
        }
        else {
            $user = Auth::user();
            $menu_id = DB::table(POSTS_TABLE)->insertGetId([
                'post_author'       => $user->id,
                'post_title'        => $menu_title,
                'post_name'         => preg_slug($menu_title, 'post', 'menus'),
                'post_excerpts'     => null,
                'post_content'      => maybe_serialize($main_menu),
                'post_type'         => 'menus',
                'term_id'           => 0,
                'post_views'        => 0,
                'post_tags'         => null,
                'post_pin'          => 0,
                'post_orders'       => 0,
                'comment_status'    => 0,
                'post_status'       => 0,
            ]);
        }

        update_post_meta('newkey', $newkey, $menu_id);        
        return redirect(get_admin_url('menus/'.$menu_id))->with("success", admin_lang('menu_has_been_updated', ['name' => $menu_title]));
    }
    
    public function delete_menu($id, $token)
    {
        if(!is_permission('menus')){
            return parent::admin_handle_permission('menus');
        }
        DB::table(POSTS_TABLE)->where(['id' => $id])->delete();
        return redirect(get_admin_url('menus'))->with("success", admin_lang('msg_delete_selected'));
    }

}
