<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
class Property extends Model{
    use HasFactory, Notifiable;

   


    protected $table="property_master";
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'estate_id',
        'tenament_no',
        'paiki',
        'property_size',
        'survey_no',
        'area_id',   
        'city_id',
        'rental_type',
        'current_rate',
        'property_type',
        'attribute',
        'varsai',
        'hold',
        'last_rent_paid',
        'electric_consumer_no',
        'remarks',
    ];
     /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */

    public function estate()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(estate::class ,'id','estate_id');
    }

    public function city()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(City::class ,'id','city_id');
    }
    public function area()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(Area::class ,'id','area_id');
    }


}
