

        @php
        $estate_name = "";
         $city_name="";
         $area_name="";

         @endphp

         @if(session()->has('success'))
         <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
         @elseif(session()->has('failure'))
         <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>
         @endif

         <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
             <thead>
                 <tr>
                     <th>Driver Name</th>
                     <th>Amount</th>
                     <th>Issue To</th>
                     <th>Notes</th>
                     <th>Ref ID</th>
                     <th>Created Date</th>
                 </tr>
             </thead>
             <tbody>



                 @foreach($drivers as $key => $driver)
                 @php $estate = $driver->estate;
                 $city = $driver->city;
                 $area = $driver->area;

                 if(empty($estate))
                 $estate_name="";
                 else
                 $estate_name =$estate->estate_name;


                 if(empty($city))
                 $city_name = "";
                 else
                 $city_name =$city->city_name;


                 if(empty($area))
                 $area_name = "";
                 else
                 $area_name =$area->area_name;

                 @endphp


                 <tr>
                     <td>
                        {{ $driver->drivers->USERNAME }}
                     </td>
                     <td>
                         $ {{ number_format($driver->amount, 2) }}
                     </td>
                     <td>
                         {{ $driver->issue_to }}
                     </td>
                     <td>
                         {{ $driver->notes }}
                     </td>
                     <td>
                        {{ $driver->ref_id }}
                    </td>
                    <td>
                        {{ date('m-d-Y', strtotime($driver->created_at)) }}
                    </td>
                 </tr>

                 @endforeach

             </tbody>
         </table>
         {{$drivers->links('dashboard.layouts.pagination')}}
