@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('graveyard') }}">{{ $data['page_title'] }}</a></li>
        </ol>
    </div>
</div>
      @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>
   @endif
<form method="POST" action="{{ get_admin_url('GraveyardActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$graveyard->id}}">
    <div class="row">
        
         <div class="col-md-5">   
        <div class="form-group required">
         <label class="control-label">Graveyard Name</label><br>
        <input type="text" name="graveyard_name" id="graveyard_name" class="form-control col-md-6" placeholder="GraveyardName" value="{{$graveyard->graveyard_name}}" onkeyup="autoTypeGujarati('city_name');" required>       
        </div>
    </div>
       
            <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">Graveyard Name[Gujarati]</label><br>
        <input type="text" name="graveyard_name_gj" id="graveyard_name_gj" class="form-control col-md-6 guj_text" placeholder="કબરનું નામ"  value="{{$graveyard->graveyard_name_gj}}" required>       
        </div>
    </div>

          
</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('graveyard')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        </div>
          
</form>
@endsection