@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="tacf-box-container">
    <div class="menus-select-header">
        <div class="row">
            <div class="col-md-8">
                <select id="menus-select" class="custom-select form-select form-control d-inline-block">
                    <option value="0">{{admin_lang('select')}}</option>
                    @foreach ($loop_menus as $item)
                    <option value="{{$item->id}}" @if($item->id == $menu_id) selected="" @endif>{{$item->post_title}}</option>
                    @endforeach
                </select>
                <input type="submit" id="button-menus-select" class="btn btn-primary d-inline-block" value="{{admin_lang('select')}}">
            </div>
            <div class="col-md-4 align-right"><a href="{{get_admin_url('menus')}}" class="btn btn-primary">{{admin_lang('addnew_menu')}}</a></div>
        </div>
    </div>
    <div class="p-3">
        <div class="row">
            <div class="col-md-3 border-right" id="side-sortables">
                <h5>{{admin_lang('add_menu_items')}}</h5>
                <hr />
                <div class="nav-menu-side-control-section accordion-container" id="side-sortables">
                    <ul class="outer-border">
                        <li class="control-section accordion-section" id="accordion-section-add-side-page">
                            <h3 class="accordion-section-title hndle">{{admin_lang('pages')}}<span class="screen-reader-text"></span></h3>
                            <div class="accordion-section-content">
                            <div class="section-content-checkbox">
                            <ul>
                                @foreach ($defult_menus as $key => $item)
                                <li>
                                    <div class="form-check">
                                        <input class="form-check-input menu-item-checkbox" type="checkbox" id="menu-item-{{$key}}" name="menu-item" data-url="{{$item['url']}}" data-title="{{$item['title']}}" data-icon="@if($item['icon']){{$item['icon']}}@endif">
                                        <label class="form-check-label" for="menu-item-{{$key}}">{{$item['title']}}</label>
                                    </div>
                                </li>
                                @endforeach
                                @foreach ($pages as $key => $item)
                                <div class="form-check">
                                    <input class="form-check-input menu-item-checkbox" type="checkbox" id="menu-item-page{{$key}}" name="menu-item" data-url="{{url('page/'.$item->post_name)}}" data-title="{{$item->post_title}}" data-icon="">
                                    <label class="form-check-label" for="menu-item-page{{$key}}">{{$item->post_title}}</label>
                                </div>
                                @endforeach
                            </ul>
                            </div>
                                <p class="button-controls clearfix">
                                    <span class="add-to-menu">
                                        <button type="button" id="button-side-page" class="btn btn-sm btn-primary submit-add-to-menu" data-prifx="side-page" data-type="page">{{admin_lang('add_to_menu')}}</button>
                                        <span class="spinner"></span>
                                    </span>
                                </p>
                            </div>
                        </li>
                        <li class="control-section accordion-section" id="accordion-section-add-side-custom_links">
                                <h3 class="accordion-section-title hndle">{{admin_lang('custom_links')}}<span class="screen-reader-text"></span></h3>
                                <div class="accordion-section-content">
                                <div class="section-content-checkbox">
                                    <ul>
                                        <li>
                                            <label class="menu-item-title">{{admin_lang('url')}}</label>
                                            <input type="text" class="form-control input-sm" name="custom_links_url" id="custom_links_url">
                                            <br>
                                            <label class="menu-item-title">{{admin_lang('title')}}</label><br>
                                            <input type="text" class="form-control input-sm" name="custom_links_title" id="custom_links_title"> 
                                        </li>
                                    </ul>
                                </div>
                                <p class="button-controls clearfix">
                                    <span class="add-to-menu">
                                        <button type="button" id="button-side-custom_links" class="btn btn-sm btn-primary submit-add-custom-link-to-menu" data-prifx="side-custom_links" data-type="Custom Links">{{admin_lang('add_to_menu')}}</button>
                                        <span class="spinner"></span>
                                    </span>
                                </p>
                            </div>
                        </li>
                        <li class="control-section accordion-section" id="accordion-section-add-side-extension">
                                <h3 class="accordion-section-title hndle">{{admin_lang('extension_url')}}<span class="screen-reader-text"></span></h3>
                                <div class="accordion-section-content">
                                <div class="section-content-checkbox">
                                    <ul>
                                        @action('admin_blade_action_extension_url')
                                    </ul>
                                </div>
                                <p class="button-controls clearfix">
                                    <span class="add-to-menu">
                                        <button type="button" id="button-side-extension" class="btn btn-sm btn-primary submit-add-to-menu" data-prifx="side-extension" data-type="extension">{{admin_lang('add_to_menu')}}</button>
                                        <span class="spinner"></span>
                                    </span>
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-9">
                <h5>{{admin_lang('menu_structure')}}</h5>
                <hr />
                <form method="POST" action="{{ get_admin_url('MenusSendForm') }}" id="menu-form-edit">
                    {{ csrf_field() }}
                    <input type="hidden" name="menu_item_map" id="menu_item_map" value="">
                    <input type="hidden" name="action" value="menu-save">
                    <div class="form-group">
                        <input type="text" name="menu_title" placeholder="{{admin_lang('enter_title_here')}}" value="{{$menu_title}}" class="form-control input-post-title">
                    </div>
                    <div class="menu-edit">
                        <div id="nav-menu-header">
                            <div class="publishing-actions">
                                <button type="button" name="save_menu" id="save_menu_header" class="btn btn-primary menu-save">{{admin_lang('save_menu')}}</button>
                                @if($menu_id)
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('deletemenus/'.$menu_id.'/'.csrf_token() ) }}" data-body="{{ admin_lang('delete_confirm') }} # {{ $menu_title }}?" class="btn btn-danger float-right">{{ admin_lang('delete_menu') }}</a>
                                @endif
                            </div>
                        </div>
                        <div class="nav-menu-body">
                            <div id="data-javas"></div>
                            <div id="menu-body-edit" class="">
                                <ul class="sortable ui-sortable" id="menu-to-edit">
                                    @foreach ($nav_main_menu as $menu_item)
                                    <li class="menu-item @if($menu_item['menuopen']) menu-open @endif" id="menu-item-{{$menu_item['newkey']}}" data-id="{{$menu_item['newkey']}}">
                                        @include('dashboard.menus.foreach_menu_item', ['menu_item' => $menu_item])
                                        @if(count($menu_item['submenu']))
                                        <ul>
                                            @foreach ($menu_item['submenu'] as $submenu_item)
                                            <li class="menu-item @if($submenu_item['menuopen']) menu-open @endif" id="menu-item-{{$submenu_item['newkey']}}" data-id="{{$submenu_item['newkey']}}">
                                                @include('dashboard.menus.foreach_menu_item', ['menu_item' => $submenu_item])
                                            </li>
                                            @endforeach
                                        </ul>
                                        @endif
                                    </li>
                                    @endforeach
                                </ul>
                                <input type="hidden" id="menu_item_count" value="{{$nav_main_menu_key}}">
                                <input type="hidden" name="menu_id" value="{{$menu_id}}">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('head_style')
<link href="{{ asset('libs/megapanel/megapanel_options.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="{{ asset('libs/menus/menus.css') }}" type="text/css" />
<link href="{{ asset('libs/megaupload/megaupload.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script>var menuediturl = '{{get_admin_url('menus')}}/';</script>
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('libs/tree/jquery.tree.js') }}"></script>
<script type="text/javascript" src="{{ asset('libs/menus/menus.js') }}"></script>
<script src="{{ asset('libs/megapanel/megapanel_options.js') }}"></script>
@endsection