@extends('dashboard.layouts.master')
@section('content')
@include('dashboard.posts.boxs.box_page_head')
<form method="POST" action="{{ get_admin_url('PostSendForm') }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="post_type" value="{{$type}}">
    <input type="hidden" name="action" value="{{$action}}" />
    <input type="hidden" name="post_id" value="{{$post_id}}" />
    @include('dashboard.posts.boxs.box_publish_toolbar')
    <div class="tacf-box-container">
        <div class="tacf-box-tabs">
            <a href="#" class="active" data-tab=".tab-details"><i class="bx bx-pencil"></i> {{ admin_lang('details') }}</a>
        </div>
        <div class="tacf-tabs-content">
            <div class="tacf-tab-content tab-details active">
                <div class="row">
                    <div class="col-md-9 border-right">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label>{{ admin_lang('name') }}</label>
                                    <input type="text" name="title" placeholder="{{ admin_lang('name') }}" value="{{$post_title}}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>{{extension_lang('team', 'job')}}</label>
                                    <input type="text" name="postmeta[job]" placeholder="{{extension_lang('team', 'job')}}" value="{{ $ex_data['job'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">@include('dashboard.posts.inputs.input_orders')</div>
                            </div>
                        </div>
                        @include('dashboard.posts.inputs.input_excerpts')
                        <div class="row">
                            <div class="col-md-4"><div class="form-group">
                                <label>Facebook</label>
                                <input type="text" name="postmeta[facebook]" placeholder="Facebook" value="{{ $ex_data['facebook'] }}" class="form-control" />
                            </div></div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Twitter</label>
                                    <input type="text" name="postmeta[twitter]" placeholder="Twitter" value="{{ $ex_data['twitter'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Instagram</label>
                                    <input type="text" name="postmeta[instagram]" placeholder="Instagram" value="{{ $ex_data['instagram'] }}" class="form-control" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        @include('dashboard.posts.inputs.input_featuredimage')
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection
@section('style_files')
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
@endsection