<!DOCTYPE html>
<html lang="{{$site_lang}}" dir="{{$site_dir}}">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ get_option('sitename') }} - {{ (isset($page_title))? $page_title : '' }}</title>
    <link rel="icon" href="{{ get_asset('images/favicon.ico') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500">
    <link href="{{ get_asset('css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    @if($site_dir == 'rtl')<link rel="stylesheet" href="{{ get_asset('css/auth.rtl.min.css') }}" type="text/css" />@else<link rel="stylesheet" href="{{ get_asset('css/auth.min.css') }}" type="text/css" />>@endif
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="signin {{$site_dir}}">
    <div class="container padding_60">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5 col-xl-4">
                <div class="card overflow-hidden">
                    <div class="bg-cover">
                        <div class="row">
                            <div class="col-7">
                                <div class="text-primary p-4">
                                    <h5 class="text-primary">{{ lang('welcome_back') }}</h5>
                                    <p>{{ lang('forgot_password') }}</p>
                                </div>
                            </div>
                            <div class="col-5 align-self-end">
                                <img src="{{ get_asset('images/auth.png') }}" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
                <div class="card-body signin-form-wrap">
                    <p class="font-size-13 text-center">{{ lang('forgot_password_info') }}</p>
                    @if(session()->has('errorlogin'))<div class="alert alert-warning">{{ lang('error_login') }}</div>@endif
                    @if($errors->any())
                        <div class="alert alert-warning">
                            <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
                        </div>
                    @endif
                    <form class="form-horizontal" method="POST" action="{{ url('forgot-password') }}">
                        {{ csrf_field() }}
                        <div class="mb-3">
                            <label class="form-label">{{lang('email_address')}}</label>
                            <div class="icon-group">
                                <div class="form-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M464 64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM48 96h416c8.8 0 16 7.2 16 16v41.4c-21.9 18.5-53.2 44-150.6 121.3-16.9 13.4-50.2 45.7-73.4 45.3-23.2.4-56.6-31.9-73.4-45.3C85.2 197.4 53.9 171.9 32 153.4V112c0-8.8 7.2-16 16-16zm416 320H48c-8.8 0-16-7.2-16-16V195c22.8 18.7 58.8 47.6 130.7 104.7 20.5 16.4 56.7 52.5 93.3 52.3 36.4.3 72.3-35.5 93.3-52.3 71.9-57.1 107.9-86 130.7-104.7v205c0 8.8-7.2 16-16 16z" class=""></path></svg>    
                                </div>
                                <input type="email" class="form-control" name="email" id="useremail" placeholder="{{ lang('enter_email') }}" value="{{ old('email') }}">
                            </div>
                        </div>
                        <div class="mt-3">
                            <button class="btn btn-primary btn-block" type="submit">{{ lang('restore_my_password') }}</button>
                        </div>
                    </form>
                    <div class="box-singup">
                        {{lang('remember_it')}} <a href="{{url('login')}}">{{lang('sign_in_here')}}</a>
                    </div>
                </div>
            </div>
            <div class="mt-3 text-center">
                <p class="copyright">{{lang('site_copyright', ['sitename' => get_option('sitename')])}}</p>
            </div>
        </div>
    </div>
</div>
</body>
</html>