@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($books_style == 'fixed') justify-content-center @endif">
        @if($books_style == 'left_sidebar')
        @include(get_extends('books.sidebar'))
        @endif
        <div class="@if($books_style == 'full') col-lg-12  @elseif($books_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            
            <div class="book-grid-item single-book">
                <img src="{{get_attachment_url($post_meta['thumbnails'], 'full')}}" class="book-grid-cover" alt="{{$single->post_title}}">
                <div class="book-grid-meta">
                    <h2 class="book-grid-title">{{$single->post_title}}</h2>
                    <div class="post-meta">
                        @if($books_meta_author)<span class="meta-author"><i class="pe-7s-user"></i> {{get_username($single->post_author)}}</span>@endif
                        @if($books_meta_date)<span class="meta-date"><i class="pe-7s-date"></i> {{time_format($single->post_modified, 'date')}}</span>@endif
                        @if($books_meta_comments and $single->comment_status)<span class="meta-comment"><i class="pe-7s-comment"></i> {{get_count_comments($single->id, $single->post_type)}} {{lang('comments')}}</span>@endif
                        @if($books_meta_views)<span class="meta-views"><i class="pe-7s-look"></i> {{$single->post_views}} {{lang('views')}}</span>@endif
                        @if($books_meta_cate)<span class="meta-categories"><i class="pe-7s-ticket"></i> <a href="{{url('books/'.get_term_slug($single->term_id))}}">{{get_term_name($single->term_id)}}</a></span>@endif
                    </div>
                    <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{get_post_meta('author', $single->id)}}</p>
                    <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{get_post_meta('year', $single->id)}}</p>
                    <p class="grid-details"><strong>{{extension_lang('books', 'type')}}:</strong> {{get_post_meta('type', $single->id)}}</p>
                    <p class="grid-details"><strong>{{extension_lang('books', 'paperback')}}:</strong> {{get_post_meta('paperback', $single->id)}} {{extension_lang('books', 'pages')}}</p>
                    <p class="grid-details"><strong>{{extension_lang('books', 'price')}}:</strong> {{get_post_meta('price', $single->id)}}</p>
                    <br />
                    <a class="button" href="{{get_post_meta('download', $single->id)}}" target="_blank">{{extension_lang('books', 'download')}}</a>
                </div>
            </div>
            <div class="post-content">
                {!!$single->post_content!!}
            </div>

            <div class="stars-tags">
                <div class="row">
                    <div class="col-md-8">
                        @if($books_meta_shareit)
                        @include(get_extends('plugins.share_socials'), ['title' => $single->post_title, 'link' => url('download/'.$single->post_name)])
                        @endif
                    </div>
                    <div class="col-md-4">
                        <ul class="tags">
                            @foreach ($tags as $tag)
                            <li><a href="{{$tag['link']}}">{{$tag['name']}}</a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            
            @if($books_related and count($related))
            <div class="related-post mt-50 mb-20">
                <div class="head-title"><h5>{{lang('related')}}</h5></div>
                <div class="row">
                    @foreach ($related as $item)
                    <div class="col-md-6">
                        <div class="book-grid-item">
                            <a href="{{url('book/'.$item->post_name)}}">
                                <img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="book-grid-cover" alt="{{$item->post_title}}">
                            </a>
                            <div class="book-grid-meta">
                                <h4 class="book-grid-title"><a href="{{url('book/'.$item->post_name)}}">{{$item->post_title}}</a></h4>
                                <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{$item->author}}</p>
                                <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{$item->year}}</p>
                                <p class="grid-details"><strong>{{extension_lang('books', 'type')}}:</strong> {{$item->type}}</p>
                                <p class="grid-details"><strong>{{extension_lang('books', 'paperback')}}:</strong> {{$item->paperback}} {{extension_lang('books', 'pages')}}</p>
                                <p class="grid-details"><strong>{{extension_lang('books', 'price')}}:</strong> {{$item->price}}</p>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
            @include(get_extends('plugins.comments'), ['single' => $single])
        </div>
        @if($books_style == 'right_sidebar')
        @include(get_extends('books.sidebar'))
        @endif
    </div>
</div>
@endsection