<!DOCTYPE html>
<html lang="{{$site_lang}}" dir="{{$site_dir}}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ (isset($page_title))? $page_title. ' | ' : '' }}{{ get_option('sitename') }}</title>
    @action('blade_action_header_before')
    @include(get_extends('plugins.head_seo'))
    @yield('stylesheet')
    @stack('stylesheet')
    @if(get_theme_option('minify_css'))
    <link href="{{ get_asset('app.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('libs/fonticons/icons.min.css') }}" rel="stylesheet" type="text/css" />
    @else
    <link href="{{ asset('libs/fonticons/fontawesome.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('libs/fonticons/boxicons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('libs/fonticons/linearicons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('libs/fonticons/pe-icon-7-stroke.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ get_asset('style.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ get_asset('css/responsive.css') }}" rel="stylesheet" type="text/css">
    @endif
    @if($site_dir == 'rtl')<link href="{{ get_asset('css/rtl.min.css') }}" rel="stylesheet" type="text/css">@endif
    @if($site_lang == 'ar')<link href="{{ get_asset('css/ar.min.css') }}" rel="stylesheet" type="text/css">@endif
    @yield('header_extensions')
    @yield('header_code')
    @action('blade_action_header_after')
</head>
<body class="@yield('body_class') @action('blade_body_class') {{$site_lang}}">
    @include(get_extends('plugins.pageloader'))
    @include(get_extends('plugins.alert_flash'))
    <div id="wrapper">
        @include(get_extends('layouts.header'))
        @include(get_extends('layouts.sub_header'))
        @yield('content')
        @include(get_extends('layouts.footer'))
    </div>
    <div class="modal fade modal-confirm-delete" id="confirm-delete" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title mt-0">{{admin_lang('confirm_delete')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{admin_lang('cancel')}}</button>
                    <a class="btn btn-danger btn-confirmdelete">{{admin_lang('confirm')}}</a>
                </div>
            </div>
        </div>
    </div> 
    @action('blade_action_footer_before')
    @if(get_theme_option('minify_css'))
    <script src="{{ get_asset('js/app.min.js') }}"></script>
    @else
    <script src="{{ get_asset('js/jquery.min.js') }}"></script>
    <script src="{{ get_asset('js/bootstrap.min.js') }}"></script>
    <script src="{{ get_asset('js/jquery.easing.min.js') }}"></script>
    <script src="{{ get_asset('js/modernizr.min.js') }}"></script>
    @endif
    
    @if(get_theme_option('sticky_sidebar'))
    <script src="{{ get_asset('js/ResizeSensor.min.js') }}"></script>
    <script src="{{ get_asset('js/theia-sticky-sidebar.min.js') }}"></script>
    @endif
    <script src="{{ get_asset('js/parallax.min.js') }}"></script>
    <script src="{{ get_asset('js/owl.carousel.min.js') }}"></script>
    @if(get_theme_option('class_header') == 'jpinning')<script src="{{ get_asset('js/jPinning.min.js') }}"></script>@endif
    <script>
    $.ajaxSetup({headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'}});
    var ajaxRequest = '{{ url('ajaxRequest') }}', cookie_id= '{{ get_theme_option('cookie_id') }}';
    @stack('scripts_var')
    (function($) {
        "use strict";
        $('#confirm-delete').on('shown.bs.modal', function(e) {
            $(this).find('.modal-body').html($(e.relatedTarget).data('body'));
            $(this).find('.btn-confirmdelete').attr('href', $(e.relatedTarget).data('href'));
        });
        @stack('scripts_code')
    })(jQuery);
    </script>
    <script src="{{ get_asset('js/custom.min.js') }}"></script>
    @stack('scripts')
    @include(get_extends('plugins.cookie_box'))
    @include(get_extends('plugins.crisp_chat'))
    @action('blade_action_footer_after')
</body>
</html>