<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\UsersController;
use App\Http\Controllers\Frontend\AuthController;


Route::any(get_admin_route('login'), [AuthController::class, 'adminlogin'])->middleware('guest')->name('dashboard_login');
Route::any(get_admin_route('/verification/{id}'),[AuthController::class,'verification'])->name('verification');
Route::any(get_admin_route('/verified'),[AuthController::class,'verifiedOtp'])->name('verifiedOtp');
Route::any(get_admin_route('/resend-otp/{mode?}'),[AuthController::class,'resendOtp'])->name('resendOtp');
Route::any(get_admin_route('/reset_password'),[AuthController::class,'reset_password'])->name('reset_password');
Route::any(get_admin_route('/verify_email'),[AuthController::class,'verify_email'])->name('verify_email');
Route::any(get_admin_route('/change_password/{id?}'),[AuthController::class,'change_password'])->name('change_password');
Route::any(get_admin_route('/change_password_check'),[AuthController::class,'change_password_check'])->name('change_password_check');
Route::get(get_admin_route('pincode/confirm'), [AuthController::class, 'admin_pincode_confirm'])->middleware('auth')->name('pincode.confirm');
Route::post(get_admin_route('pincode/confirm'), [AuthController::class, 'admin_pincode_confirm_post'])->middleware('auth');

Route::any('login', [AuthController::class, 'login'])->middleware('guest')->name('login');
Route::any('/register', [AuthController::class, 'register'])->middleware('guest')->name('register');
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth')->name('logout');
Route::any('forgot-password', [AuthController::class, 'forgot_password'])->middleware('guest')->name('password.email');
Route::get('low_balance_alert', [AuthController::class, 'low_balance_alert'])->name('low_balance_alert');

Route::middleware(['auth'])->group(function () {
    Route::any('profile', [UsersController::class, 'profile'])->name('profile');
});
